/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportUtils {
    private static final String URL_COULD_NOT_BE_OPENED = "URL %s could not be opened.";
    private static final String MALFORMED_TEMPLATE_URL = "Template file url %s is malformed. Using default...";
    private static final String ILLEGAL_ARGUMENT = "The path %s is incorrect. Using default...";
    private static final String DEFAULT_TEMPLATE_PATH_IN_JAR = "/static/templates/default-template.odt";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtils.class);

    private ReportUtils() {
    }

    public static InputStream getTemplateInputStream(String string) {
        InputStream inputStream;
        if (string == null) {
            inputStream = ReportUtils.getDefaultTemplate();
        } else {
            try {
                inputStream = new URL(string).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.warn(String.format(MALFORMED_TEMPLATE_URL, string));
                inputStream = ReportUtils.getDefaultTemplate();
            }
            catch (IOException iOException) {
                LOGGER.warn(String.format(URL_COULD_NOT_BE_OPENED, string), iOException);
                inputStream = ReportUtils.getDefaultTemplate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn(String.format(ILLEGAL_ARGUMENT, string), illegalArgumentException);
                inputStream = ReportUtils.getDefaultTemplate();
            }
        }
        return inputStream;
    }

    public static InputStream getDefaultTemplate() {
        return ReportUtils.class.getResourceAsStream(DEFAULT_TEMPLATE_PATH_IN_JAR);
    }

    public static String getVersion() {
        try {
            Properties properties = new Properties();
            properties.load(ReportUtils.class.getResourceAsStream("/META-INF/maven/com.bitegarden.sonar.plugins/bitegarden-sonarcloud-report/pom.properties"));
            return properties.getProperty("version", "unknown");
        }
        catch (IOException iOException) {
            LOGGER.warn("Unable to get version: {}", (Object)iOException.getMessage(), (Object)iOException);
            return "unknown";
        }
    }

    public static String getExpirationDateFromRemainingDays(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(5, (int)l);
        int n = gregorianCalendar.get(5);
        String string = gregorianCalendar.getDisplayName(2, 2, Locale.ENGLISH);
        int n2 = gregorianCalendar.get(1);
        return string + ", " + n + ", " + n2;
    }
}

