/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.gson.Gson;
import es.sonarqube.api.SonarQubeAppResponse;
import es.sonarqube.api.SonarQubeProject;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeMeasureManager;
import es.sonarqube.managers.SonarQubeServerManager;
import es.sonarqube.managers.SonarQubeURLManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Components;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.Qualitygates;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.components.AppRequest;
import org.sonarqube.ws.client.components.SearchProjectsRequest;
import org.sonarqube.ws.client.components.ShowRequest;
import org.sonarqube.ws.client.components.TreeRequest;
import org.sonarqube.ws.client.projectbranches.ListRequest;
import org.sonarqube.ws.client.qualitygates.ProjectStatusRequest;

public class SonarQubeProjectManager {
    public static final String TOTAL_PROJECTS_FOUND_LOG_MESSAGE = "Total projects found: {}";
    public static final String PAGE_SIZE_PARAM = "500";
    public static final String PAGE_SIZE_LOG_MESSAGE = "Page size:            {}";
    public static final String TOTAL_PAGES_LOG_MESSAGE = "Total pages:          {}";
    public static final String REQUESTING_PAGE_LOG_MESSAGE = "Requesting page {} of {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeProjectManager.class);
    private static final String ANALISYS_DATE = "analysisDate";
    private final WsClient wsClient;
    private final Locale userLocale;

    public SonarQubeProjectManager(WsClient wsClient, Locale locale) {
        this.wsClient = wsClient;
        this.userLocale = locale;
    }

    public SonarQubeProjectManager(String string, String string2, Locale locale) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
        this.userLocale = locale;
    }

    protected static List<SonarQubeProject> getProjectInformation(WsClient wsClient, List<String> list, List<String> list2, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectInformation(list, list2);
    }

    protected static SonarQubeProject getProjectInformation(WsClient wsClient, String string, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectInformation(string, list);
    }

    protected static SonarQubeProject getBasicProjectInformation(WsClient wsClient, String string, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getBasicProjectInformation(string);
    }

    protected static List<SonarQubeProject> getBasicProjectInformation(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getBasicProjectInformation(list);
    }

    protected static List<String> getPortfolioResourcesId(WsClient wsClient, String string, Locale locale) {
        return new SonarQubeProjectManager(wsClient, locale).getPortfolioResourcesId(string);
    }

    protected static List<String> getUuids(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getUuids(list);
    }

    protected static List<ProjectBranches.Branch> getProjectBranches(WsClient wsClient, String string, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectBranches(string);
    }

    protected static ProjectBranches.Branch getProjectMainBranch(WsClient wsClient, List<ProjectBranches.Branch> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectMainBranch(list);
    }

    public SonarQubeProject getProjectInformation(String string, List<String> list) throws SonarQubeException {
        List<SonarQubeProject> list2 = this.getProjectInformation(Collections.singletonList(string), list);
        for (SonarQubeProject sonarQubeProject : list2) {
            if (!string.equals(sonarQubeProject.getKey())) continue;
            return sonarQubeProject;
        }
        throw new SonarQubeException(String.format("Error getting basic information. Project %s not found!", string));
    }

    public List<SonarQubeProject> getProjectInformation(List<String> list, List<String> list2) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
            searchProjectsRequest.setF(Collections.singletonList(ANALISYS_DATE));
            searchProjectsRequest.setPs(PAGE_SIZE_PARAM);
            LOGGER.debug("Getting info from projects ({})", (Object)list);
            arrayList.addAll(this.getProjectList(list, list2, searchProjectsRequest));
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting projects (%s) info: %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    private List<SonarQubeProject> getProjectList(List<String> list, List<String> list2, SearchProjectsRequest searchProjectsRequest) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        for (String string : list) {
            searchProjectsRequest.setFilter(String.format("query=%s", string));
            Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
            for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                String string2 = component.getKey().isEmpty() ? string : component.getKey();
                if (!string.equals(string2)) continue;
                arrayList.add(this.getSonarQubeProject(component, string2, list2));
            }
            if (!searchProjectsWsResponse.hasPaging()) continue;
            arrayList.addAll(this.getPagingProjects(searchProjectsRequest, list2, searchProjectsWsResponse));
        }
        return arrayList;
    }

    private SonarQubeProject getSonarQubeProject(Components.Component component, String string, List<String> list) throws SonarQubeException {
        Object object;
        String string2 = component.getAnalysisDate().isEmpty() ? "" : component.getAnalysisDate().substring(0, 10);
        SonarQubeProject sonarQubeProject = this.generateSonarQubeProjectWithBasicInfo(string, component, string2);
        sonarQubeProject.setUrl(SonarQubeURLManager.getProjectUrl(this.wsClient.wsConnector().baseUrl(), string, SonarQubeServerManager.getSonarQubeVersion(this.wsClient)));
        sonarQubeProject.setUuid(string);
        sonarQubeProject.setSonarQubeMeasureList(SonarQubeMeasureManager.getMeasures(this.wsClient, string, list, this.userLocale));
        sonarQubeProject.setTags(component.getTags());
        sonarQubeProject.setVersion(this.getProjectVersion(string));
        Qualitygates.ProjectStatusResponse projectStatusResponse = this.getProjectStatusResponse(string);
        if (sonarQubeProject.getSonarQubeMeasureList().isEmpty()) {
            object = Qualitygates.ProjectStatusResponse.Status.forNumber(4);
            sonarQubeProject.setQualityGate(Qualitygates.ProjectStatusResponse.ProjectStatus.newBuilder().setStatus((Qualitygates.ProjectStatusResponse.Status)object).build());
        } else {
            sonarQubeProject.setQualityGate(projectStatusResponse.getProjectStatus());
        }
        object = this.getProjectBranches(string);
        sonarQubeProject.setSonarQubeBranchList((List<ProjectBranches.Branch>)object);
        sonarQubeProject.setMainBranch(this.getProjectMainBranch((List<ProjectBranches.Branch>)object));
        return sonarQubeProject;
    }

    public SonarQubeProject getBasicProjectInformation(String string) throws SonarQubeException {
        List<SonarQubeProject> list = this.getBasicProjectInformation(Collections.singletonList(string));
        for (SonarQubeProject sonarQubeProject : list) {
            if (!string.equals(sonarQubeProject.getKey())) continue;
            return sonarQubeProject;
        }
        throw new SonarQubeException(String.format("Error getting basic information. Project %s not found!", string));
    }

    public List<SonarQubeProject> getBasicProjectInformation(List<String> list) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
            searchProjectsRequest.setF(Collections.singletonList(ANALISYS_DATE));
            for (String string : list) {
                searchProjectsRequest.setFilter(String.format("query=%s", string));
                Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                if (searchProjectsWsResponse == null) continue;
                searchProjectsWsResponse.getComponentsList().forEach(component -> {
                    String string2 = component.getKey().isEmpty() ? string : component.getKey();
                    String string3 = component.getAnalysisDate().isEmpty() ? "" : component.getAnalysisDate().substring(0, 10);
                    SonarQubeProject sonarQubeProject = this.generateSonarQubeProjectWithBasicInfo(string2, (Components.Component)component, string3);
                    sonarQubeProject.setUuid(string2);
                    arrayList.add(sonarQubeProject);
                });
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting basic project info (%s) info: %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    public List<String> getUuids(List<String> list) throws SonarQubeException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            LOGGER.debug("Getting project ({}) uuids...", (Object)list);
            list.forEach(string -> {
                AppRequest appRequest = new AppRequest();
                appRequest.setComponent((String)string);
                String string2 = this.wsClient.components().app(appRequest);
                SonarQubeAppResponse sonarQubeAppResponse = new Gson().fromJson(string2, SonarQubeAppResponse.class);
                LOGGER.debug("Project ({}) uuid received: {}", string, (Object)sonarQubeAppResponse.getUuid());
                arrayList.add(sonarQubeAppResponse.getUuid());
            });
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) uuids: %s", list, exception.getMessage()));
        }
        return arrayList;
    }

    public List<String> getPortfolioResourcesId(String string) {
        LOGGER.debug("Getting portfolio resources from : {}", (Object)string);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            TreeRequest treeRequest = new TreeRequest();
            treeRequest.setComponent(string);
            treeRequest.setPs(PAGE_SIZE_PARAM);
            treeRequest.setQualifiers(Collections.singletonList("TRK"));
            Components.TreeWsResponse treeWsResponse = this.wsClient.components().tree(treeRequest);
            if (treeWsResponse.getComponentsCount() == 0) {
                LOGGER.debug("No portfolio or portfolio with empty projects, returning empty list");
                return Collections.emptyList();
            }
            LOGGER.debug("Portfolio projects founded: {}", (Object)treeWsResponse.getComponentsCount());
            treeWsResponse.getComponentsList().forEach(component -> {
                if (!component.getRefKey().isEmpty()) {
                    LOGGER.debug("Project founded into portfolio with name: {}", (Object)component.getRefKey());
                    arrayList.add(component.getRefKey());
                }
            });
            arrayList.addAll(this.getPagingPortfolioProjects(treeWsResponse, arrayList, string));
            return arrayList;
        }
        catch (Exception exception) {
            LOGGER.debug("Error getting portfolio resources id from ({}), error: {}. Returning list with value NOT_FOUND...", (Object)string, (Object)exception.getMessage());
            return Collections.singletonList("NOT_FOUND");
        }
    }

    private List<String> getPagingPortfolioProjects(Components.TreeWsResponse treeWsResponse, List<String> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (treeWsResponse.hasPaging()) {
            Integer n = treeWsResponse.getPaging().getTotal();
            LOGGER.debug(TOTAL_PROJECTS_FOUND_LOG_MESSAGE, (Object)n);
            LOGGER.debug(PAGE_SIZE_LOG_MESSAGE, (Object)PAGE_SIZE_PARAM);
            double d = Math.ceil((double)n.intValue() / 500.0);
            LOGGER.debug(TOTAL_PAGES_LOG_MESSAGE, (Object)d);
            int n2 = 2;
            while ((double)n2 <= d) {
                LOGGER.debug(REQUESTING_PAGE_LOG_MESSAGE, (Object)n2, (Object)d);
                TreeRequest treeRequest = new TreeRequest();
                treeRequest.setComponent(string);
                treeRequest.setPs(PAGE_SIZE_PARAM);
                treeRequest.setP(Integer.toString(n2));
                treeRequest.setQualifiers(Collections.singletonList("TRK"));
                treeWsResponse = this.wsClient.components().tree(treeRequest);
                treeWsResponse.getComponentsList().forEach(component -> {
                    if (!list.contains(component.getRefKey()) && !component.getRefKey().isEmpty()) {
                        LOGGER.debug("Project founded into portfolio with name: {}", (Object)component.getRefKey());
                        arrayList.add(component.getRefKey());
                    }
                });
                ++n2;
            }
        }
        return arrayList;
    }

    private SonarQubeProject generateSonarQubeProjectWithBasicInfo(String string, Components.Component component, String string2) {
        SonarQubeProject sonarQubeProject = new SonarQubeProject();
        String string3 = component.getName().isEmpty() ? string : component.getName();
        sonarQubeProject.setKey(string);
        sonarQubeProject.setName(string3);
        sonarQubeProject.setLastAnalysis(string2);
        return sonarQubeProject;
    }

    public List<ProjectBranches.Branch> getProjectBranches(String string) throws SonarQubeException {
        LOGGER.debug("Getting project ({}) branches...", (Object)string);
        try {
            ArrayList<ProjectBranches.Branch> arrayList = new ArrayList<ProjectBranches.Branch>();
            ListRequest listRequest = new ListRequest();
            listRequest.setProject(string);
            ProjectBranches.ListWsResponse listWsResponse = this.wsClient.projectBranches().list(listRequest);
            if (listWsResponse != null && listWsResponse.getBranchesList() != null) {
                LOGGER.debug("Project branches found -> {}", (Object)listWsResponse.getBranchesCount());
                listWsResponse.getBranchesList().forEach(branch -> {
                    LOGGER.debug("Adding branch ({}) to result...", (Object)branch.getName());
                    arrayList.add((ProjectBranches.Branch)branch);
                });
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) branches, error -> %s", string, exception.getMessage()));
        }
    }

    public String getProjectVersion(String string) throws SonarQubeException {
        return this.getProjectVersion(string, null);
    }

    public String getProjectVersion(String string, String string2) throws SonarQubeException {
        LOGGER.debug("Getting project ({}) version for branch {}...", (Object)string, (Object)string2);
        try {
            Components.ShowWsResponse showWsResponse;
            String string3 = "";
            ShowRequest showRequest = new ShowRequest();
            showRequest.setComponent(string);
            if (string2 != null && !string2.isEmpty()) {
                showRequest.setBranch(string2);
            }
            if ((showWsResponse = this.wsClient.components().show(showRequest)) != null && showWsResponse.getComponent() != null) {
                LOGGER.debug("Project version found -> {}", (Object)showWsResponse.getComponent().getVersion());
                if (showWsResponse.getComponent().getVersion() != null) {
                    string3 = showWsResponse.getComponent().getVersion();
                } else {
                    LOGGER.warn("Project ({}) version is null", (Object)string);
                }
            }
            return string3;
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) version, error -> %s", string, exception.getMessage()));
        }
    }

    public String getProjectAnalysisDate(String string) throws SonarQubeException {
        return this.getProjectAnalysisDate(string, null);
    }

    public String getProjectAnalysisDate(String string, String string2) throws SonarQubeException {
        LOGGER.debug("Getting project ({}) version for branch {}...", (Object)string, (Object)string2);
        try {
            Components.ShowWsResponse showWsResponse;
            String string3 = "";
            ShowRequest showRequest = new ShowRequest();
            showRequest.setComponent(string);
            if (string2 != null && !string2.isEmpty()) {
                showRequest.setBranch(string2);
            }
            if ((showWsResponse = this.wsClient.components().show(showRequest)) != null && showWsResponse.getComponent() != null) {
                LOGGER.debug("Project analysis date found -> {}", (Object)showWsResponse.getComponent().getVersion());
                if (showWsResponse.getComponent().getAnalysisDate() != null) {
                    string3 = showWsResponse.getComponent().getAnalysisDate();
                } else {
                    LOGGER.warn("Project ({}) analysis date is null", (Object)string);
                }
            }
            return string3.isEmpty() ? "" : string3.substring(0, 10);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) analysis date, error -> %s", string, exception.getMessage()));
        }
    }

    public ProjectBranches.Branch getProjectMainBranch(List<ProjectBranches.Branch> list) throws SonarQubeException {
        LOGGER.debug("Getting main branch from list of branches... {} branches found", (Object)list.size());
        for (ProjectBranches.Branch branch : list) {
            if (!branch.getIsMain()) continue;
            return branch;
        }
        throw new SonarQubeException("Error: main Branch not found!");
    }

    public List<SonarQubeProject> getProjectsWithOnlyResourceIdsByTags(List<String> list) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
            searchProjectsRequest.setPs(PAGE_SIZE_PARAM);
            LOGGER.debug("Getting resource ids from tags ({})", (Object)list);
            if (list != null && !list.isEmpty()) {
                String string = String.join((CharSequence)",", list);
                searchProjectsRequest.setFilter("tags in (" + string + ")");
                Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                for (Components.Component serializable : searchProjectsWsResponse.getComponentsList()) {
                    SonarQubeProject n2 = new SonarQubeProject();
                    n2.setTags(serializable.getTags());
                    n2.setKey(serializable.getKey());
                    arrayList.add(n2);
                }
                if (searchProjectsWsResponse.hasPaging()) {
                    Integer n = searchProjectsWsResponse.getPaging().getTotal();
                    LOGGER.debug(TOTAL_PROJECTS_FOUND_LOG_MESSAGE, (Object)n);
                    LOGGER.debug(PAGE_SIZE_LOG_MESSAGE, (Object)PAGE_SIZE_PARAM);
                    Double d = Math.ceil((double)n.intValue() / 500.0);
                    LOGGER.debug(TOTAL_PAGES_LOG_MESSAGE, (Object)d);
                    int n2 = 2;
                    while ((double)n2 <= d) {
                        LOGGER.debug(REQUESTING_PAGE_LOG_MESSAGE, (Object)n2, (Object)d);
                        searchProjectsRequest = new SearchProjectsRequest();
                        searchProjectsRequest.setPs(PAGE_SIZE_PARAM);
                        searchProjectsRequest.setP(Integer.toString(n2));
                        searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                        for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                            SonarQubeProject sonarQubeProject = new SonarQubeProject();
                            sonarQubeProject.setTags(component.getTags());
                            sonarQubeProject.setKey(component.getKey());
                            arrayList.add(sonarQubeProject);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting resources ids info by tags (%s) : %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    public List<SonarQubeProject> getProjectInformationByTags(List<String> list, List<String> list2) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
            searchProjectsRequest.setF(Collections.singletonList(ANALISYS_DATE));
            searchProjectsRequest.setPs(PAGE_SIZE_PARAM);
            LOGGER.debug("Getting info from projects ({})", (Object)list);
            if (list != null && !list.isEmpty()) {
                String string = String.join((CharSequence)",", list);
                searchProjectsRequest.setFilter("tags in (" + string + ")");
                Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                    String string2 = component.getKey();
                    arrayList.add(this.getSonarQubeProject(component, string2, list2));
                }
                if (searchProjectsWsResponse.hasPaging()) {
                    arrayList.addAll(this.getPagingProjects(searchProjectsRequest, list2, searchProjectsWsResponse));
                }
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting projects  (%s) info by tags : %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    private List<SonarQubeProject> getPagingProjects(SearchProjectsRequest searchProjectsRequest, List<String> list, Components.SearchProjectsWsResponse searchProjectsWsResponse) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        Integer n = searchProjectsWsResponse.getPaging().getTotal();
        LOGGER.debug(TOTAL_PROJECTS_FOUND_LOG_MESSAGE, (Object)n);
        LOGGER.debug(PAGE_SIZE_LOG_MESSAGE, (Object)PAGE_SIZE_PARAM);
        Double d = Math.ceil((double)n.intValue() / 500.0);
        LOGGER.debug(TOTAL_PAGES_LOG_MESSAGE, (Object)d);
        int n2 = 2;
        while ((double)n2 <= d) {
            LOGGER.debug(REQUESTING_PAGE_LOG_MESSAGE, (Object)n2, (Object)d);
            searchProjectsRequest.setP(Integer.toString(n2));
            searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
            for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                String string = component.getKey();
                arrayList.add(this.getSonarQubeProject(component, string, list));
            }
            ++n2;
        }
        return arrayList;
    }

    public Qualitygates.ProjectStatusResponse getProjectStatusResponse(String string) {
        return this.getProjectStatusResponse(string, null);
    }

    public Qualitygates.ProjectStatusResponse getProjectStatusResponse(String string, String string2) {
        ProjectStatusRequest projectStatusRequest = new ProjectStatusRequest();
        projectStatusRequest.setProjectKey(string);
        if (string2 != null && !string2.isEmpty()) {
            projectStatusRequest.setBranch(string2);
        }
        LOGGER.debug("Getting project status from : ({}) for branch ({})", (Object)string, (Object)string2);
        Qualitygates.ProjectStatusResponse projectStatusResponse = this.wsClient.qualitygates().projectStatus(projectStatusRequest);
        LOGGER.debug("Project status: ({})", (Object)projectStatusResponse.getProjectStatus().getStatus());
        return projectStatusResponse;
    }
}

