/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.license.utils;

import com.bitegarden.license.pojo.BitegardenLicenseContext;
import com.bitegarden.license.pojo.BitegardenLicenseStatus;
import com.bitegarden.licenser.checker.LicenseChecker;
import com.bitegarden.licenser.common.data.DownloadInfo;
import com.bitegarden.licenser.common.data.LicenseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ce.measure.Settings;
import org.sonar.api.config.Configuration;

public final class BitegardenLicenseChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitegardenLicenseChecker.class);
    private final Configuration configuration;
    private final Settings settings;
    private final String pluginKey;
    private final BitegardenLicenseContext context;
    private final String sonarId;
    private final String licenseKey;

    public BitegardenLicenseChecker(Configuration configuration, String string) {
        this.configuration = configuration;
        this.settings = null;
        this.pluginKey = string;
        this.licenseKey = "";
        this.context = BitegardenLicenseContext.SONARQUBE_SERVER;
        this.sonarId = this.getSonarQubeServerId(configuration);
    }

    public BitegardenLicenseChecker(Settings settings, String string) {
        this.configuration = null;
        this.settings = settings;
        this.pluginKey = string;
        this.licenseKey = "";
        this.context = BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE;
        this.sonarId = this.getSonarQubeServerId(settings);
    }

    public BitegardenLicenseChecker(String string, String string2, String string3) {
        this.configuration = null;
        this.settings = null;
        this.pluginKey = string;
        this.licenseKey = string2;
        this.sonarId = string3;
        this.context = BitegardenLicenseContext.SONARCLOUD;
    }

    public String getLicensedServerId() {
        String string = this.licenseKey;
        if (BitegardenLicenseContext.SONARQUBE_SERVER.equals((Object)this.context)) {
            if (this.configuration == null) {
                return "";
            }
            string = this.configuration.get(this.pluginKey + ".license_cert.secured").orElse("");
        } else if (BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE.equals((Object)this.context)) {
            if (this.settings == null) {
                return "";
            }
            string = this.settings.getString(this.pluginKey + ".license_cert.secured");
            if (string == null) {
                string = "";
            }
        } else if (BitegardenLicenseContext.SONARCLOUD.equals((Object)this.context)) {
            string = LicenseChecker.getServerId(this.licenseKey);
        }
        return string;
    }

    public BitegardenLicenseStatus getLicenseStatus() {
        if (BitegardenLicenseContext.SONARQUBE_SERVER.equals((Object)this.context)) {
            return this.getLicenseStatus(this.configuration, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE.equals((Object)this.context)) {
            return this.getLicenseStatus(this.settings, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARCLOUD.equals((Object)this.context)) {
            return this.getLicenseStatus(this.licenseKey, this.sonarId);
        }
        return BitegardenLicenseStatus.INVALID_LICENSE;
    }

    private BitegardenLicenseStatus getLicenseStatus(String string, String string2) {
        LicenseStatus licenseStatus = LicenseChecker.getLicenseStatus(string);
        if (string.isEmpty() && licenseStatus.equals((Object)LicenseStatus.INVALID_LICENSE)) {
            return BitegardenLicenseStatus.NO_LICENSE;
        }
        if (string.isEmpty() && (licenseStatus.equals((Object)LicenseStatus.EVALUATION) || licenseStatus.equals((Object)LicenseStatus.EVALUATION_EXPIRED))) {
            return BitegardenLicenseStatus.getLicenseStatus(licenseStatus);
        }
        if (!string.isEmpty() && Boolean.TRUE.equals(LicenseChecker.getDownloadInfo().getIsServerIdRequired())) {
            String string3 = LicenseChecker.getServerId(string);
            if (string2.equals(string3) || licenseStatus.equals((Object)LicenseStatus.EVALUATION) || licenseStatus.equals((Object)LicenseStatus.INVALID_LICENSE) || licenseStatus.equals((Object)LicenseStatus.EVALUATION_EXPIRED)) {
                return BitegardenLicenseStatus.getLicenseStatus(licenseStatus);
            }
            return BitegardenLicenseStatus.INVALID_SERVER_ID;
        }
        if (!string.isEmpty() && Boolean.FALSE.equals(LicenseChecker.getDownloadInfo().getIsServerIdRequired())) {
            return BitegardenLicenseStatus.getLicenseStatus(licenseStatus);
        }
        return BitegardenLicenseStatus.NO_LICENSE;
    }

    private BitegardenLicenseStatus getLicenseStatus(Configuration configuration, String string) {
        if (configuration == null) {
            return BitegardenLicenseStatus.FREE_LICENSE;
        }
        String string2 = configuration.get(string + ".license_cert.secured").orElse("");
        return this.getLicenseStatus(string2, this.sonarId);
    }

    private BitegardenLicenseStatus getLicenseStatus(Settings settings, String string) {
        if (settings == null) {
            return BitegardenLicenseStatus.FREE_LICENSE;
        }
        String string2 = settings.getString(string + ".license_cert.secured");
        if (string2 == null) {
            string2 = "";
        }
        return this.getLicenseStatus(string2, this.sonarId);
    }

    public long getUseRemainingDays() {
        if (BitegardenLicenseContext.SONARQUBE_SERVER.equals((Object)this.context)) {
            return LicenseChecker.getUseRemainingDays(this.configuration.get(this.pluginKey + ".license_cert.secured").orElse(""));
        }
        if (BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE.equals((Object)this.context)) {
            return LicenseChecker.getUseRemainingDays(this.settings.getString(this.pluginKey + ".license_cert.secured"));
        }
        if (BitegardenLicenseContext.SONARCLOUD.equals((Object)this.context)) {
            return LicenseChecker.getUseRemainingDays(this.licenseKey);
        }
        return 0L;
    }

    public long getSupportRemainingDays() {
        if (BitegardenLicenseContext.SONARQUBE_SERVER.equals((Object)this.context)) {
            return LicenseChecker.getSupportRemainingDays(this.configuration.get(this.pluginKey + ".license_cert.secured").orElse(""));
        }
        if (BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE.equals((Object)this.context)) {
            return LicenseChecker.getSupportRemainingDays(this.settings.getString(this.pluginKey + ".license_cert.secured"));
        }
        if (BitegardenLicenseContext.SONARCLOUD.equals((Object)this.context)) {
            return LicenseChecker.getSupportRemainingDays(this.licenseKey);
        }
        return 0L;
    }

    public Long getEvaluationDays() {
        if (BitegardenLicenseContext.SONARQUBE_SERVER.equals((Object)this.context)) {
            return this.getEvaluationDays(this.configuration, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE.equals((Object)this.context)) {
            return this.getEvaluationDays(this.settings, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARCLOUD.equals((Object)this.context)) {
            return this.getEvaluationDays(this.licenseKey, this.sonarId);
        }
        return 0L;
    }

    private Long getEvaluationDays(Configuration configuration, String string) {
        String string2 = configuration.get(string + ".license_cert.secured").orElse("");
        return this.getEvaluationDays(string2, this.sonarId);
    }

    private Long getEvaluationDays(Settings settings, String string) {
        String string2 = settings.getString(string + ".license_cert.secured");
        return this.getEvaluationDays(string2, this.sonarId);
    }

    private Long getEvaluationDays(String string, String string2) {
        BitegardenLicenseStatus bitegardenLicenseStatus = this.getLicenseStatus(string, string2);
        String string3 = this.getDownloadInfo().getProductName();
        if (BitegardenLicenseStatus.EVALUATION.equals((Object)bitegardenLicenseStatus)) {
            Long l = this.getUseRemainingDays();
            LOGGER.debug("{} license days remaining: {}", (Object)string3, (Object)l);
            return l;
        }
        LOGGER.debug("{} trying to get evaluation days but license status is not evaluation: {}", (Object)string3, (Object)bitegardenLicenseStatus.name());
        return 0L;
    }

    public DownloadInfo getDownloadInfo() {
        return LicenseChecker.getDownloadInfo();
    }

    public boolean isValidLicense() {
        if (BitegardenLicenseContext.SONARQUBE_SERVER.equals((Object)this.context)) {
            return this.isValidLicense(this.configuration, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE.equals((Object)this.context)) {
            return this.isValidLicense(this.settings, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARCLOUD.equals((Object)this.context)) {
            return this.isValidLicense(this.licenseKey, this.sonarId);
        }
        return false;
    }

    private boolean isValidLicense(String string, String string2) {
        BitegardenLicenseStatus bitegardenLicenseStatus = this.getLicenseStatus(string, string2);
        String string3 = this.getDownloadInfo().getProductName();
        LOGGER.debug("{} license Status: {}", (Object)string3, (Object)bitegardenLicenseStatus);
        switch (bitegardenLicenseStatus) {
            case EVALUATION: 
            case LICENSED: 
            case SUPPORTED: 
            case FREE_LICENSE: {
                return true;
            }
        }
        return false;
    }

    private boolean isValidLicense(Configuration configuration, String string) {
        if (configuration != null) {
            String string2 = configuration.get(string + ".license_cert.secured").orElse("");
            return this.isValidLicense(string2, this.sonarId);
        }
        return true;
    }

    private boolean isValidLicense(Settings settings, String string) {
        if (settings != null) {
            String string2 = settings.getString(string + ".license_cert.secured");
            if (string2 == null) {
                string2 = "";
            }
            return this.isValidLicense(string2, this.sonarId);
        }
        return true;
    }

    public boolean isEvaluationLicense() {
        if (BitegardenLicenseContext.SONARQUBE_SERVER.equals((Object)this.context)) {
            return this.isEvaluationLicense(this.configuration, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARQUBE_COMPUTE_ENGINE.equals((Object)this.context)) {
            return this.isEvaluationLicense(this.settings, this.pluginKey);
        }
        if (BitegardenLicenseContext.SONARCLOUD.equals((Object)this.context)) {
            return this.isEvaluationLicense(this.licenseKey, this.sonarId);
        }
        return false;
    }

    private boolean isEvaluationLicense(Configuration configuration, String string) {
        BitegardenLicenseStatus bitegardenLicenseStatus = this.getLicenseStatus(configuration, string);
        LOGGER.debug("Checking if {} license is evaluation: {}", (Object)string, (Object)bitegardenLicenseStatus);
        return bitegardenLicenseStatus.equals((Object)BitegardenLicenseStatus.EVALUATION);
    }

    private boolean isEvaluationLicense(Settings settings, String string) {
        BitegardenLicenseStatus bitegardenLicenseStatus = this.getLicenseStatus(settings, string);
        LOGGER.debug("Checking if {} license is evaluation: {}", (Object)string, (Object)bitegardenLicenseStatus);
        return bitegardenLicenseStatus.equals((Object)BitegardenLicenseStatus.EVALUATION);
    }

    private boolean isEvaluationLicense(String string, String string2) {
        BitegardenLicenseStatus bitegardenLicenseStatus = this.getLicenseStatus(string, string2);
        LOGGER.debug("Checking if {} license is evaluation: {}", (Object)string2, (Object)bitegardenLicenseStatus);
        return bitegardenLicenseStatus.equals((Object)BitegardenLicenseStatus.EVALUATION);
    }

    public void printLicenseStatusInfo() {
        LOGGER.info("{} License Status: {}", (Object)this.pluginKey, (Object)this.getLicenseStatus());
    }

    private String getSonarQubeServerId(Configuration configuration) {
        if (configuration != null) {
            return configuration.get("sonar.core.id").orElse("");
        }
        return "";
    }

    private String getSonarQubeServerId(Settings settings) {
        if (settings != null) {
            String string = settings.getString("sonar.core.id");
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }
}

