/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.AddNode;
import com.graphbuilder.math.DivNode;
import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionParseException;
import com.graphbuilder.math.FuncNode;
import com.graphbuilder.math.MultNode;
import com.graphbuilder.math.PowNode;
import com.graphbuilder.math.SubNode;
import com.graphbuilder.math.ValNode;
import com.graphbuilder.math.VarNode;
import com.graphbuilder.struc.Stack;

public class ExpressionTree {
    private ExpressionTree() {
    }

    public static Expression parse(String s2) {
        if (s2 == null) {
            throw new ExpressionParseException("Expression string cannot be null.", -1);
        }
        return ExpressionTree.build(s2, 0);
    }

    private static Expression build(String s2, int indexErrorOffset) {
        if (s2.trim().length() == 0) {
            return null;
        }
        Stack s1 = new Stack();
        Stack s22 = new Stack();
        boolean term = true;
        boolean signed = false;
        boolean negate = false;
        for (int i = 0; i < s2.length(); ++i) {
            char c2 = s2.charAt(i);
            if (c2 == ' ' || c2 == '\t' || c2 == '\n') continue;
            if (term) {
                if (c2 == '(') {
                    if (negate) {
                        throw new ExpressionParseException("Open bracket found after negate.", i);
                    }
                    s22.push("(");
                    continue;
                }
                if (!(signed || c2 != '+' && c2 != '-')) {
                    signed = true;
                    if (c2 != '-') continue;
                    negate = true;
                    continue;
                }
                if (c2 >= '0' && c2 <= '9' || c2 == '.') {
                    int j;
                    for (j = i + 1; j < s2.length(); ++j) {
                        c2 = s2.charAt(j);
                        if (c2 >= '0' && c2 <= '9' || c2 == '.') {
                            continue;
                        }
                        if (c2 != 'e' && c2 != 'E') break;
                        if (++j < s2.length()) {
                            c2 = s2.charAt(j);
                            if (c2 != '+' && c2 != '-' && (c2 < '0' || c2 > '9')) {
                                throw new ExpressionParseException("Expected digit, plus sign or minus sign but found: " + String.valueOf(c2), j + indexErrorOffset);
                            }
                            ++j;
                        }
                        while (j < s2.length() && (c2 = s2.charAt(j)) >= '0' && c2 <= '9') {
                            ++j;
                        }
                        break block3;
                    }
                    double d2 = 0.0;
                    String _d = s2.substring(i, j);
                    try {
                        d2 = Double.parseDouble(_d);
                    }
                    catch (Throwable t) {
                        throw new ExpressionParseException("Improperly formatted value: " + _d, i + indexErrorOffset);
                    }
                    if (negate) {
                        d2 = -d2;
                    }
                    s1.push(new ValNode(d2));
                    i = j - 1;
                    negate = false;
                    term = false;
                    signed = false;
                    continue;
                }
                if (c2 != ',' && c2 != ')' && c2 != '^' && c2 != '*' && c2 != '/' && c2 != '+' && c2 != '-') {
                    int j;
                    for (j = i + 1; j < s2.length() && (c2 = s2.charAt(j)) != ',' && c2 != ' ' && c2 != '\t' && c2 != '\n' && c2 != '(' && c2 != ')' && c2 != '^' && c2 != '*' && c2 != '/' && c2 != '+' && c2 != '-'; ++j) {
                    }
                    if (j < s2.length()) {
                        int k = j;
                        while ((c2 == ' ' || c2 == '\t' || c2 == '\n') && ++k != s2.length()) {
                            c2 = s2.charAt(k);
                        }
                        if (c2 == '(') {
                            Expression o;
                            FuncNode fn = new FuncNode(s2.substring(i, j), negate);
                            int b2 = 1;
                            int kOld = k + 1;
                            while (b2 != 0) {
                                if (++k >= s2.length()) {
                                    throw new ExpressionParseException("Missing function close bracket.", i + indexErrorOffset);
                                }
                                c2 = s2.charAt(k);
                                if (c2 == ')') {
                                    --b2;
                                    continue;
                                }
                                if (c2 == '(') {
                                    ++b2;
                                    continue;
                                }
                                if (c2 != ',' || b2 != 1) continue;
                                o = ExpressionTree.build(s2.substring(kOld, k), kOld);
                                if (o == null) {
                                    throw new ExpressionParseException("Incomplete function.", kOld + indexErrorOffset);
                                }
                                fn.add(o);
                                kOld = k + 1;
                            }
                            o = ExpressionTree.build(s2.substring(kOld, k), kOld);
                            if (o == null) {
                                if (fn.numChildren() > 0) {
                                    throw new ExpressionParseException("Incomplete function.", kOld + indexErrorOffset);
                                }
                            } else {
                                fn.add(o);
                            }
                            s1.push(fn);
                            i = k;
                        } else {
                            s1.push(new VarNode(s2.substring(i, j), negate));
                            i = k - 1;
                        }
                    } else {
                        s1.push(new VarNode(s2.substring(i, j), negate));
                        i = j - 1;
                    }
                    negate = false;
                    term = false;
                    signed = false;
                    continue;
                }
                throw new ExpressionParseException("Unexpected character: " + String.valueOf(c2), i + indexErrorOffset);
            }
            if (c2 == ')') {
                Stack s3 = new Stack();
                Stack s4 = new Stack();
                while (true) {
                    if (s22.isEmpty()) {
                        throw new ExpressionParseException("Missing open bracket.", i + indexErrorOffset);
                    }
                    Object o = s22.pop();
                    if (o.equals("(")) break;
                    s3.addToTail(s1.pop());
                    s4.addToTail(o);
                }
                s3.addToTail(s1.pop());
                s1.push(ExpressionTree.build(s3, s4));
                continue;
            }
            if (c2 == '^' || c2 == '*' || c2 == '/' || c2 == '+' || c2 == '-') {
                term = true;
                s22.push(String.valueOf(c2));
                continue;
            }
            throw new ExpressionParseException("Expected operator or close bracket but found: " + String.valueOf(c2), i + indexErrorOffset);
        }
        if (s1.size() != s22.size() + 1) {
            throw new ExpressionParseException("Incomplete expression.", indexErrorOffset + s2.length());
        }
        return ExpressionTree.build(s1, s22);
    }

    private static Expression build(Stack s1, Stack s2) {
        Object o2;
        Object o1;
        Object o;
        Stack s3 = new Stack();
        Stack s4 = new Stack();
        while (!s2.isEmpty()) {
            o = s2.removeTail();
            o1 = s1.removeTail();
            o2 = s1.removeTail();
            if (o.equals("^")) {
                s1.addToTail(new PowNode((Expression)o1, (Expression)o2));
                continue;
            }
            s1.addToTail(o2);
            s4.push(o);
            s3.push(o1);
        }
        s3.push(s1.pop());
        while (!s4.isEmpty()) {
            o = s4.removeTail();
            o1 = s3.removeTail();
            o2 = s3.removeTail();
            if (o.equals("*")) {
                s3.addToTail(new MultNode((Expression)o1, (Expression)o2));
                continue;
            }
            if (o.equals("/")) {
                s3.addToTail(new DivNode((Expression)o1, (Expression)o2));
                continue;
            }
            s3.addToTail(o2);
            s2.push(o);
            s1.push(o1);
        }
        s1.push(s3.pop());
        while (!s2.isEmpty()) {
            o = s2.removeTail();
            o1 = s1.removeTail();
            o2 = s1.removeTail();
            if (o.equals("+")) {
                s1.addToTail(new AddNode((Expression)o1, (Expression)o2));
                continue;
            }
            if (o.equals("-")) {
                s1.addToTail(new SubNode((Expression)o1, (Expression)o2));
                continue;
            }
            throw new ExpressionParseException("Unknown operator: " + o, -1);
        }
        return (Expression)s1.pop();
    }
}

