/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.api;

import es.sonarqube.api.SonarQubeHistoryMeasure;
import es.sonarqube.api.SonarQubeHistoryMetricValue;
import es.sonarqube.exceptions.SonarQubeException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SonarQubeProjectSummary {
    private Map<String, String> measures;
    private String key;
    private String name;
    private String lastAnalysis;
    private String url;
    private String ncloc;
    private String bugs;
    private String vulnerabilities;
    private String codeSmells;
    private String securityHotspots;
    private String duplicationsDensity;
    private String coverage;
    private String reliabilityRating;
    private String securityRating;
    private String securityReviewRating;
    private String maintainabilityRating;
    private String sizeRating;
    private String duplicationsRating;
    private String healthRating;
    private String alertStatus;
    private Map<String, String> languageDistribution;
    private SonarQubeHistoryMeasure sonarQubeHistoryMeasure;
    private List<SonarQubeHistoryMetricValue> bugsHistoryValues;
    private List<SonarQubeHistoryMetricValue> vulnerabilitiesHistoryValues;
    private List<SonarQubeHistoryMetricValue> codeSmellsHistoryValues;

    public SonarQubeProjectSummary() {
    }

    public SonarQubeProjectSummary(String string, Map<String, String> map, Map<String, String> map2) {
        this.key = string;
        this.name = map2.get("name");
        this.lastAnalysis = map2.get("date");
        this.measures = map;
        this.ncloc = map.get("ncloc");
        this.bugs = map.get("bugs");
        this.vulnerabilities = map.get("vulnerabilities");
        this.codeSmells = map.get("code_smells");
        this.securityHotspots = map.get("security_hotspots");
        this.duplicationsDensity = map.get("duplications");
        this.coverage = map.get("coverage");
        this.reliabilityRating = map.get("reliability_rating");
        this.maintainabilityRating = map.get("sqale_rating");
        this.securityRating = map.get("security_rating");
        this.securityReviewRating = map.get("security_review_rating");
        this.sizeRating = map.get("sizeRating");
        this.duplicationsRating = map.get("duplicationsRating");
        this.healthRating = map.get("healthRating");
        this.alertStatus = map.get("alert_status");
        this.languageDistribution = new HashMap<String, String>();
    }

    public Map<String, String> getMeasures() {
        return this.measures;
    }

    public void setMeasures(Map<String, String> map) {
        this.measures = map;
    }

    public String getMeasureValueForMetric(String string) throws SonarQubeException {
        if (this.measures != null && this.measures.containsKey(string)) {
            return this.measures.get(string);
        }
        throw new SonarQubeException("Metric key not found in project summary measures");
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getLastAnalysis() {
        return this.lastAnalysis.isEmpty() ? "" : this.lastAnalysis.substring(0, 10);
    }

    public void setLastAnalysis(String string) {
        this.lastAnalysis = string;
    }

    public String getNcloc() {
        return this.ncloc;
    }

    public void setNcloc(String string) {
        this.ncloc = string;
    }

    public String getBugs() {
        return this.bugs;
    }

    public void setBugs(String string) {
        this.bugs = string;
    }

    public String getVulnerabilities() {
        return this.vulnerabilities;
    }

    public void setVulnerabilities(String string) {
        this.vulnerabilities = string;
    }

    public String getCodeSmells() {
        return this.codeSmells;
    }

    public void setCodeSmells(String string) {
        this.codeSmells = string;
    }

    public String getSecurityHotspots() {
        return this.securityHotspots;
    }

    public void setSecurityHotspots(String string) {
        this.securityHotspots = string;
    }

    public String getDuplicationsDensity() {
        return this.duplicationsDensity;
    }

    public void setDuplicationsDensity(String string) {
        this.duplicationsDensity = string;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String string) {
        this.coverage = string;
    }

    public String getReliabilityRating() {
        return this.reliabilityRating;
    }

    public void setReliabilityRating(String string) {
        this.reliabilityRating = string;
    }

    public String getSecurityRating() {
        return this.securityRating;
    }

    public void setSecurityRating(String string) {
        this.securityRating = string;
    }

    public String getSecurityReviewRating() {
        return this.securityReviewRating;
    }

    public void setSecurityReviewRating(String string) {
        this.securityReviewRating = string;
    }

    public String getMaintainabilityRating() {
        return this.maintainabilityRating;
    }

    public void setMaintainabilityRating(String string) {
        this.maintainabilityRating = string;
    }

    public String getSizeRating() {
        return this.sizeRating;
    }

    public void setSizeRating(String string) {
        this.sizeRating = string;
    }

    public String getDuplicationsRating() {
        return this.duplicationsRating;
    }

    public void setDuplicationsRating(String string) {
        this.duplicationsRating = string;
    }

    public String getHealthRating() {
        return this.healthRating;
    }

    public void setHealthRating(String string) {
        this.healthRating = string;
    }

    public String getAlertStatus() {
        return this.alertStatus;
    }

    public void setAlertStatus(String string) {
        this.alertStatus = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public Map<String, String> getLanguageDistribution() {
        return this.languageDistribution;
    }

    public void setLanguageDistribution(Map<String, String> map) {
        this.languageDistribution = map;
    }

    public SonarQubeHistoryMeasure getSonarQubeHistoryMeasure() {
        return this.sonarQubeHistoryMeasure;
    }

    public void setSonarQubeHistoryMeasure(SonarQubeHistoryMeasure sonarQubeHistoryMeasure) {
        this.sonarQubeHistoryMeasure = sonarQubeHistoryMeasure;
    }

    public List<SonarQubeHistoryMetricValue> getBugsHistoryValues() {
        return this.bugsHistoryValues;
    }

    public void setBugsHistoryValues(List<SonarQubeHistoryMetricValue> list) {
        this.bugsHistoryValues = list;
    }

    public List<SonarQubeHistoryMetricValue> getVulnerabilitiesHistoryValues() {
        return this.vulnerabilitiesHistoryValues;
    }

    public void setVulnerabilitiesHistoryValues(List<SonarQubeHistoryMetricValue> list) {
        this.vulnerabilitiesHistoryValues = list;
    }

    public List<SonarQubeHistoryMetricValue> getCodeSmellsHistoryValues() {
        return this.codeSmellsHistoryValues;
    }

    public void setCodeSmellsHistoryValues(List<SonarQubeHistoryMetricValue> list) {
        this.codeSmellsHistoryValues = list;
    }
}

