/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.gson.Gson;
import es.sonarqube.api.SonarQubeAppResponse;
import es.sonarqube.api.SonarQubeApplication;
import es.sonarqube.api.SonarQubeApplicationQualityGate;
import es.sonarqube.api.SonarQubeApplicationShowResponse;
import es.sonarqube.api.SonarQubePortfolio;
import es.sonarqube.api.SonarQubeProject;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeMeasureManager;
import es.sonarqube.managers.SonarQubeServerManager;
import es.sonarqube.managers.SonarQubeURLManager;
import es.sonarqube.model.SonarQubeQualifier;
import es.sonarqube.utils.FormatUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Components;
import org.sonarqube.ws.Measures;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.Qualitygates;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.WsResponse;
import org.sonarqube.ws.client.applications.ShowRequest;
import org.sonarqube.ws.client.components.AppRequest;
import org.sonarqube.ws.client.components.SearchProjectsRequest;
import org.sonarqube.ws.client.components.TreeRequest;
import org.sonarqube.ws.client.measures.ComponentRequest;
import org.sonarqube.ws.client.projectbranches.ListRequest;
import org.sonarqube.ws.client.qualitygates.GetByProjectRequest;
import org.sonarqube.ws.client.qualitygates.ProjectStatusRequest;

public class SonarQubeProjectManager {
    public static final String TOTAL_PROJECTS_FOUND_LOG_MESSAGE = "Total projects found: {}";
    public static final String PAGE_SIZE_PARAM = "500";
    public static final String PAGE_SIZE_LOG_MESSAGE = "Page size:            {}";
    public static final String TOTAL_PAGES_LOG_MESSAGE = "Total pages:          {}";
    public static final String REQUESTING_PAGE_LOG_MESSAGE = "Requesting page {} of {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeProjectManager.class);
    private static final String ANALISYS_DATE = "analysisDate";
    private final WsClient wsClient;
    private final Locale userLocale;

    public SonarQubeProjectManager(WsClient wsClient, Locale locale) {
        this.wsClient = wsClient;
        this.userLocale = locale;
    }

    public SonarQubeProjectManager(String string, String string2, Locale locale) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
        this.userLocale = locale;
    }

    protected static List<SonarQubeProject> getProjectInformation(WsClient wsClient, List<String> list, List<String> list2, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectInformation(list, list2);
    }

    protected static SonarQubeProject getProjectInformation(WsClient wsClient, String string, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectInformation(string, list);
    }

    protected static SonarQubeProject getBasicProjectInformation(WsClient wsClient, String string, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getBasicProjectInformation(string);
    }

    protected static List<SonarQubeProject> getBasicProjectInformation(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getBasicProjectInformation(list);
    }

    protected static List<String> getPortfolioResourcesId(WsClient wsClient, String string, Locale locale) {
        return new SonarQubeProjectManager(wsClient, locale).getPortfolioResourcesId(string);
    }

    protected static List<String> getUuids(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getUuids(list);
    }

    protected static List<ProjectBranches.Branch> getProjectBranches(WsClient wsClient, String string, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectBranches(string);
    }

    protected static ProjectBranches.Branch getProjectMainBranch(WsClient wsClient, List<ProjectBranches.Branch> list, Locale locale) throws SonarQubeException {
        return new SonarQubeProjectManager(wsClient, locale).getProjectMainBranch(list);
    }

    public SonarQubeProject getProjectInformation(String string, List<String> list) throws SonarQubeException {
        List<SonarQubeProject> list2 = this.getProjectInformation(Collections.singletonList(string), list);
        for (SonarQubeProject sonarQubeProject : list2) {
            if (!string.equals(sonarQubeProject.getKey())) continue;
            return sonarQubeProject;
        }
        throw new SonarQubeException(String.format("Error getting basic information. Project %s not found!", string));
    }

    public List<SonarQubeProject> getProjectInformation(List<String> list, List<String> list2) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            LOGGER.debug("Getting info from projects ({})", (Object)list);
            arrayList.addAll(this.getProjectList(list, list2));
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting projects (%s) info: %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    private List<SonarQubeProject> getProjectList(List<String> list, List<String> list2) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        for (String string : list) {
            Components.Component component;
            String string2;
            org.sonarqube.ws.client.components.ShowRequest showRequest = new org.sonarqube.ws.client.components.ShowRequest();
            showRequest.setComponent(string);
            Components.ShowWsResponse showWsResponse = this.wsClient.components().show(showRequest);
            if (showWsResponse == null || !(string2 = (component = showWsResponse.getComponent()).getKey().isEmpty() ? string : component.getKey()).equals(string)) continue;
            arrayList.add(this.getSonarQubeProject(component, string2, list2));
        }
        return arrayList;
    }

    private SonarQubeProject getSonarQubeProject(Components.Component component, String string, List<String> list) throws SonarQubeException {
        Object object;
        SonarQubeProject sonarQubeProject = this.generateSonarQubeProjectWithBasicInfo(string, component);
        sonarQubeProject.setUrl(SonarQubeURLManager.getProjectUrl(this.wsClient.wsConnector().baseUrl(), string, SonarQubeServerManager.getSonarQubeVersion(this.wsClient)));
        sonarQubeProject.setUuid(string);
        sonarQubeProject.setSonarQubeMeasureList(SonarQubeMeasureManager.getMeasures(this.wsClient, string, list, this.userLocale));
        sonarQubeProject.setTagList(component.getTags());
        sonarQubeProject.setVersion(this.getProjectVersion(string));
        Qualitygates.ProjectStatusResponse projectStatusResponse = this.getProjectStatusResponse(string);
        if (sonarQubeProject.getSonarQubeMeasureList().isEmpty()) {
            object = Qualitygates.ProjectStatusResponse.Status.forNumber(4);
            sonarQubeProject.setQualityGate(Qualitygates.ProjectStatusResponse.ProjectStatus.newBuilder().setStatus((Qualitygates.ProjectStatusResponse.Status)object).build());
        } else {
            sonarQubeProject.setQualityGate(projectStatusResponse.getProjectStatus());
        }
        object = this.getProjectBranches(string);
        sonarQubeProject.setSonarQubeBranchList((List<ProjectBranches.Branch>)object);
        sonarQubeProject.setMainBranch(this.getProjectMainBranch((List<ProjectBranches.Branch>)object));
        return sonarQubeProject;
    }

    public SonarQubeProject getBasicProjectInformation(String string) throws SonarQubeException {
        List<SonarQubeProject> list = this.getBasicProjectInformation(Collections.singletonList(string));
        for (SonarQubeProject sonarQubeProject : list) {
            if (!string.equals(sonarQubeProject.getKey())) continue;
            return sonarQubeProject;
        }
        throw new SonarQubeException(String.format("Error getting basic information. Project %s not found!", string));
    }

    public List<SonarQubeProject> getBasicProjectInformation(List<String> list) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            for (String string : list) {
                LOGGER.debug("Getting basic project information from resource id -> {}", (Object)string);
                arrayList.add(this.searchBasicProjectInformation(string));
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting basic project info (%s) info: %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    public SonarQubeProject searchBasicProjectInformation(String string) throws SonarQubeException {
        if (string == null || string.isEmpty()) {
            LOGGER.warn("We cannot getting basic info from null or empty project key");
            return new SonarQubeProject();
        }
        try {
            LOGGER.debug("Searching basic project information from resource id -> {}", (Object)string);
            org.sonarqube.ws.client.components.ShowRequest showRequest = new org.sonarqube.ws.client.components.ShowRequest();
            showRequest.setComponent(string);
            Components.ShowWsResponse showWsResponse = this.wsClient.components().show(showRequest);
            if (showWsResponse != null) {
                String string2;
                Components.Component component = showWsResponse.getComponent();
                String string3 = string2 = component.getKey().isEmpty() ? string : component.getKey();
                if (string2.equals(string)) {
                    return this.generateSonarQubeProjectWithBasicInfo(string2, component);
                }
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error searching for basic project info (%s) info: %s", string, exception.getMessage()), exception);
        }
        return new SonarQubeProject();
    }

    public List<String> getUuids(List<String> list) throws SonarQubeException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            LOGGER.debug("Getting project ({}) uuids...", (Object)list);
            list.forEach(string -> {
                AppRequest appRequest = new AppRequest();
                appRequest.setComponent((String)string);
                String string2 = this.wsClient.components().app(appRequest);
                SonarQubeAppResponse sonarQubeAppResponse = new Gson().fromJson(string2, SonarQubeAppResponse.class);
                LOGGER.debug("Project ({}) uuid received: {}", string, (Object)sonarQubeAppResponse.getUuid());
                arrayList.add(sonarQubeAppResponse.getUuid());
            });
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) uuids: %s", list, exception.getMessage()));
        }
        return arrayList;
    }

    public List<String> getPortfolioResourcesId(String string) {
        LOGGER.debug("Getting portfolio resources from : {}", (Object)string);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            TreeRequest treeRequest = new TreeRequest();
            treeRequest.setComponent(string);
            treeRequest.setPs(PAGE_SIZE_PARAM);
            treeRequest.setQualifiers(Collections.singletonList("TRK"));
            Components.TreeWsResponse treeWsResponse = this.wsClient.components().tree(treeRequest);
            if (treeWsResponse.getComponentsCount() == 0) {
                LOGGER.debug("No portfolio or portfolio with empty projects, returning empty list");
                return Collections.emptyList();
            }
            LOGGER.debug("Portfolio projects founded: {}", (Object)treeWsResponse.getComponentsCount());
            treeWsResponse.getComponentsList().forEach(component -> {
                if (!component.getRefKey().isEmpty()) {
                    LOGGER.debug("Project founded into portfolio with name: {}", (Object)component.getRefKey());
                    arrayList.add(component.getRefKey());
                }
            });
            arrayList.addAll(this.getPagingPortfolioProjects(treeWsResponse, arrayList, string));
            return arrayList;
        }
        catch (Exception exception) {
            LOGGER.debug("Error getting portfolio resources id from ({}), error: {}. Returning list with value NOT_FOUND...", (Object)string, (Object)exception.getMessage());
            return Collections.singletonList("NOT_FOUND");
        }
    }

    private List<String> getPagingPortfolioProjects(Components.TreeWsResponse treeWsResponse, List<String> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (treeWsResponse.hasPaging()) {
            Integer n = treeWsResponse.getPaging().getTotal();
            LOGGER.debug(TOTAL_PROJECTS_FOUND_LOG_MESSAGE, (Object)n);
            LOGGER.debug(PAGE_SIZE_LOG_MESSAGE, (Object)PAGE_SIZE_PARAM);
            double d2 = Math.ceil((double)n.intValue() / 500.0);
            LOGGER.debug(TOTAL_PAGES_LOG_MESSAGE, (Object)d2);
            int n2 = 2;
            while ((double)n2 <= d2) {
                LOGGER.debug(REQUESTING_PAGE_LOG_MESSAGE, (Object)n2, (Object)d2);
                TreeRequest treeRequest = new TreeRequest();
                treeRequest.setComponent(string);
                treeRequest.setPs(PAGE_SIZE_PARAM);
                treeRequest.setP(Integer.toString(n2));
                treeRequest.setQualifiers(Collections.singletonList("TRK"));
                treeWsResponse = this.wsClient.components().tree(treeRequest);
                treeWsResponse.getComponentsList().forEach(component -> {
                    if (!list.contains(component.getRefKey()) && !component.getRefKey().isEmpty()) {
                        LOGGER.debug("Project founded into portfolio with name: {}", (Object)component.getRefKey());
                        arrayList.add(component.getRefKey());
                    }
                });
                ++n2;
            }
        }
        return arrayList;
    }

    private SonarQubeProject generateSonarQubeProjectWithBasicInfo(String string, Components.Component component) {
        LOGGER.debug("Generating sonarqube project basic info for {}", (Object)string);
        SonarQubeProject sonarQubeProject = new SonarQubeProject();
        String string2 = component.getAnalysisDate().isEmpty() ? "" : component.getAnalysisDate().substring(0, 10);
        String string3 = component.getName().isEmpty() ? string : component.getName();
        sonarQubeProject.setKey(string);
        sonarQubeProject.setName(string3);
        sonarQubeProject.setLastAnalysis(string2);
        sonarQubeProject.setUuid(component.getKey());
        return sonarQubeProject;
    }

    public List<ProjectBranches.Branch> getProjectBranches(String string) throws SonarQubeException {
        LOGGER.debug("Getting project ({}) branches...", (Object)string);
        try {
            ArrayList<ProjectBranches.Branch> arrayList = new ArrayList<ProjectBranches.Branch>();
            ListRequest listRequest = new ListRequest();
            listRequest.setProject(string);
            ProjectBranches.ListWsResponse listWsResponse = this.wsClient.projectBranches().list(listRequest);
            if (listWsResponse != null && listWsResponse.getBranchesList() != null) {
                LOGGER.debug("Project branches found -> {}", (Object)listWsResponse.getBranchesCount());
                listWsResponse.getBranchesList().forEach(branch -> {
                    LOGGER.debug("Adding branch ({}) to result...", (Object)branch.getName());
                    arrayList.add((ProjectBranches.Branch)branch);
                });
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) branches, error -> %s", string, exception.getMessage()));
        }
    }

    public String getProjectVersion(String string) throws SonarQubeException {
        return this.getProjectVersion(string, null);
    }

    public String getProjectVersion(String string, String string2) throws SonarQubeException {
        LOGGER.debug("Getting project ({}) version for branch {}...", (Object)string, (Object)string2);
        try {
            Components.ShowWsResponse showWsResponse;
            String string3 = "";
            org.sonarqube.ws.client.components.ShowRequest showRequest = new org.sonarqube.ws.client.components.ShowRequest();
            showRequest.setComponent(string);
            if (string2 != null && !string2.isEmpty()) {
                showRequest.setBranch(string2);
            }
            if ((showWsResponse = this.wsClient.components().show(showRequest)) != null) {
                LOGGER.debug("Project version found -> {}", (Object)showWsResponse.getComponent().getVersion());
                string3 = showWsResponse.getComponent().getVersion();
            }
            return string3;
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) version, error -> %s", string, exception.getMessage()));
        }
    }

    public String getProjectAnalysisDate(String string) throws SonarQubeException {
        return this.getProjectAnalysisDate(string, null);
    }

    public String getProjectAnalysisDateFullFormat(String string) throws SonarQubeException {
        return this.getProjectAnalysisDate(string, null, true);
    }

    private String getProjectAnalysisDate(String string, String string2, boolean bl) throws SonarQubeException {
        LOGGER.debug("Getting project ({}) analysis date for branch {}...", (Object)string, (Object)string2);
        try {
            Components.ShowWsResponse showWsResponse;
            String string3 = "";
            org.sonarqube.ws.client.components.ShowRequest showRequest = new org.sonarqube.ws.client.components.ShowRequest();
            showRequest.setComponent(string);
            if (string2 != null && !string2.isEmpty()) {
                showRequest.setBranch(string2);
            }
            if ((showWsResponse = this.wsClient.components().show(showRequest)) != null && showWsResponse.getComponent() != null) {
                LOGGER.debug("Project analysis date found -> {}", (Object)showWsResponse.getComponent().getAnalysisDate());
                if (showWsResponse.getComponent().getAnalysisDate() != null) {
                    string3 = showWsResponse.getComponent().getAnalysisDate();
                } else {
                    LOGGER.warn("Project ({}) analysis date is null", (Object)string);
                }
            }
            if (bl) {
                return string3.isEmpty() ? "" : string3;
            }
            return string3.isEmpty() ? "" : string3.substring(0, 10);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting project (%s) analysis date, error -> %s", string, exception.getMessage()));
        }
    }

    public String getProjectAnalysisDate(String string, String string2) throws SonarQubeException {
        return this.getProjectAnalysisDate(string, string2, false);
    }

    public String getProjectAnalysisDateFullFormat(String string, String string2) throws SonarQubeException {
        return this.getProjectAnalysisDate(string, string2, true);
    }

    public ProjectBranches.Branch getProjectMainBranch(List<ProjectBranches.Branch> list) throws SonarQubeException {
        LOGGER.debug("Getting main branch from list of branches... {} branches found", (Object)list.size());
        for (ProjectBranches.Branch branch : list) {
            if (!branch.getIsMain()) continue;
            return branch;
        }
        throw new SonarQubeException("Error: main Branch not found!");
    }

    public List<SonarQubeProject> getProjectsWithOnlyResourceIdsByTags(List<String> list) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
            searchProjectsRequest.setPs(PAGE_SIZE_PARAM);
            LOGGER.debug("Getting resource ids from tags ({})", (Object)list);
            if (list != null && !list.isEmpty()) {
                String string = String.join((CharSequence)",", list);
                searchProjectsRequest.setFilter("tags in (" + string + ")");
                Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                for (Components.Component serializable : searchProjectsWsResponse.getComponentsList()) {
                    SonarQubeProject n2 = new SonarQubeProject();
                    n2.setTagList(serializable.getTags());
                    n2.setKey(serializable.getKey());
                    arrayList.add(n2);
                }
                if (searchProjectsWsResponse.hasPaging()) {
                    Integer n = searchProjectsWsResponse.getPaging().getTotal();
                    LOGGER.debug(TOTAL_PROJECTS_FOUND_LOG_MESSAGE, (Object)n);
                    LOGGER.debug(PAGE_SIZE_LOG_MESSAGE, (Object)PAGE_SIZE_PARAM);
                    Double d2 = Math.ceil((double)n.intValue() / 500.0);
                    LOGGER.debug(TOTAL_PAGES_LOG_MESSAGE, (Object)d2);
                    int n2 = 2;
                    while ((double)n2 <= d2) {
                        LOGGER.debug(REQUESTING_PAGE_LOG_MESSAGE, (Object)n2, (Object)d2);
                        searchProjectsRequest = new SearchProjectsRequest();
                        searchProjectsRequest.setPs(PAGE_SIZE_PARAM);
                        searchProjectsRequest.setP(Integer.toString(n2));
                        searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                        for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                            SonarQubeProject sonarQubeProject = new SonarQubeProject();
                            sonarQubeProject.setTagList(component.getTags());
                            sonarQubeProject.setKey(component.getKey());
                            arrayList.add(sonarQubeProject);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting resources ids info by tags (%s) : %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    public List<SonarQubeProject> getProjectInformationByTags(List<String> list, List<String> list2) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        try {
            SearchProjectsRequest searchProjectsRequest = new SearchProjectsRequest();
            searchProjectsRequest.setF(Collections.singletonList(ANALISYS_DATE));
            searchProjectsRequest.setPs(PAGE_SIZE_PARAM);
            LOGGER.debug("Getting info from projects ({})", (Object)list);
            if (list != null && !list.isEmpty()) {
                String string = String.join((CharSequence)",", list);
                searchProjectsRequest.setFilter("tags in (" + string + ")");
                Components.SearchProjectsWsResponse searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
                for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                    String string2 = component.getKey();
                    arrayList.add(this.getSonarQubeProject(component, string2, list2));
                }
                if (searchProjectsWsResponse.hasPaging()) {
                    arrayList.addAll(this.getPagingProjects(searchProjectsRequest, list2, searchProjectsWsResponse));
                }
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting projects  (%s) info by tags : %s", list, exception.getMessage()), exception);
        }
        return arrayList;
    }

    private List<SonarQubeProject> getPagingProjects(SearchProjectsRequest searchProjectsRequest, List<String> list, Components.SearchProjectsWsResponse searchProjectsWsResponse) throws SonarQubeException {
        ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
        Integer n = searchProjectsWsResponse.getPaging().getTotal();
        LOGGER.debug(TOTAL_PROJECTS_FOUND_LOG_MESSAGE, (Object)n);
        LOGGER.debug(PAGE_SIZE_LOG_MESSAGE, (Object)PAGE_SIZE_PARAM);
        Double d2 = Math.ceil((double)n.intValue() / 500.0);
        LOGGER.debug(TOTAL_PAGES_LOG_MESSAGE, (Object)d2);
        int n2 = 2;
        while ((double)n2 <= d2) {
            LOGGER.debug(REQUESTING_PAGE_LOG_MESSAGE, (Object)n2, (Object)d2);
            searchProjectsRequest.setP(Integer.toString(n2));
            searchProjectsWsResponse = this.wsClient.components().searchProjects(searchProjectsRequest);
            for (Components.Component component : searchProjectsWsResponse.getComponentsList()) {
                String string = component.getKey();
                arrayList.add(this.getSonarQubeProject(component, string, list));
            }
            ++n2;
        }
        return arrayList;
    }

    public Qualitygates.ProjectStatusResponse getProjectStatusResponse(String string) {
        return this.getProjectStatusResponse(string, null);
    }

    public Qualitygates.ProjectStatusResponse getProjectStatusResponse(String string, String string2) {
        ProjectStatusRequest projectStatusRequest = new ProjectStatusRequest();
        projectStatusRequest.setProjectKey(string);
        if (string2 != null && !string2.isEmpty()) {
            projectStatusRequest.setBranch(string2);
        }
        LOGGER.debug("Getting project status from : ({}) for branch ({})", (Object)string, (Object)string2);
        Qualitygates.ProjectStatusResponse projectStatusResponse = this.wsClient.qualitygates().projectStatus(projectStatusRequest);
        LOGGER.debug("Project status: ({})", (Object)projectStatusResponse.getProjectStatus().getStatus());
        return projectStatusResponse;
    }

    public SonarQubeQualifier getSonarQubeQualifier(String string) {
        LOGGER.debug("Getting SonarQube qualifier for ({})", (Object)string);
        TreeRequest treeRequest = new TreeRequest();
        treeRequest.setComponent(string);
        Components.TreeWsResponse treeWsResponse = this.wsClient.components().tree(treeRequest);
        if (treeWsResponse != null) {
            switch (treeWsResponse.getBaseComponent().getQualifier()) {
                case "TRK": {
                    LOGGER.debug("Resource key is from SonarQube project");
                    return SonarQubeQualifier.PROJECT;
                }
                case "APP": {
                    LOGGER.debug("Resource key is from SonarQube app");
                    return SonarQubeQualifier.APPLICATION;
                }
                case "VW": 
                case "SVW": {
                    LOGGER.debug("Resource key is from SonarQube portfolio");
                    return SonarQubeQualifier.PORTFOLIO;
                }
                case "BRC": {
                    LOGGER.debug("Resource key is from SonarQube sub project");
                    return SonarQubeQualifier.SUBPROJECTS;
                }
                case "UTS": {
                    LOGGER.debug("Resource key is from SonarQube test files");
                    return SonarQubeQualifier.TEST_FILES;
                }
                case "FIL": {
                    LOGGER.debug("Resource key is from SonarQube files");
                    return SonarQubeQualifier.FILES;
                }
                case "DIR": {
                    LOGGER.debug("Resource key is from SonarQube directories");
                    return SonarQubeQualifier.DIRECTORIES;
                }
            }
            LOGGER.warn("We cannot identify SonarQube Qualifier for resource key ({})", (Object)string);
            return SonarQubeQualifier.NOT_FOUND;
        }
        LOGGER.warn("We cannot identify SonarQube Qualifier for resource key ({})", (Object)string);
        return SonarQubeQualifier.NOT_FOUND;
    }

    public SonarQubeProject getSonarQubeProjectWithBasicInfo(String string, String string2) throws SonarQubeException {
        LOGGER.debug("Getting SonarQube Project with basic info for resource key ({}) and branch ({})", (Object)string, (Object)string2);
        SonarQubeQualifier sonarQubeQualifier = this.getSonarQubeQualifier(string);
        String string3 = this.getProjectAnalysisDate(string, string2);
        switch (sonarQubeQualifier) {
            case PROJECT: {
                LOGGER.debug("Getting basic info for SonarQube Project");
                SonarQubeProject sonarQubeProject = this.getBasicProjectInformation(string);
                sonarQubeProject.setLastAnalysis(string3);
                sonarQubeProject.setSonarQubeBranchList(this.getProjectBranches(string));
                sonarQubeProject.setMainBranch(this.getProjectMainBranch(sonarQubeProject.getSonarQubeBranchList()));
                sonarQubeProject.setSonarQubeQualifier(SonarQubeQualifier.PROJECT);
                sonarQubeProject.setQualityGate(this.getProjectStatusResponse(string, string2).getProjectStatus());
                sonarQubeProject.setVersion(this.getProjectVersion(string, string2));
                sonarQubeProject.setSonarQubeQualityGate(this.getSonarQubeProjectQualityGate(string));
                return sonarQubeProject;
            }
            case PORTFOLIO: {
                LOGGER.debug("Getting basic info for SonarQube Portfolio");
                SonarQubePortfolio sonarQubePortfolio = new SonarQubePortfolio();
                sonarQubePortfolio.setKey(string);
                sonarQubePortfolio.setSonarQubeQualifier(SonarQubeQualifier.PORTFOLIO);
                sonarQubePortfolio.setQualityGate(Qualitygates.ProjectStatusResponse.ProjectStatus.newBuilder().setStatus(Qualitygates.ProjectStatusResponse.Status.NONE).build());
                sonarQubePortfolio.setLastAnalysis("-");
                sonarQubePortfolio.setMainBranch(ProjectBranches.Branch.newBuilder().setIsMain(true).setName("").build());
                sonarQubePortfolio.setSonarQubeQualityGate(Qualitygates.QualityGate.newBuilder().build());
                List<String> list = this.getPortfolioResourcesId(string);
                ArrayList<SonarQubeProject> arrayList = new ArrayList<SonarQubeProject>();
                for (String string4 : list) {
                    arrayList.add(this.getBasicProjectInformation(string4));
                }
                sonarQubePortfolio.setSonarQubeProjectList(arrayList);
                Components.TreeWsResponse treeWsResponse = this.wsClient.components().tree(new TreeRequest().setComponent(string));
                sonarQubePortfolio.setName(treeWsResponse.getBaseComponent().getName());
                this.getReleasabilityMeasure(string).getComponent().getMeasuresList().forEach(measure -> {
                    sonarQubePortfolio.setReleasabilityValue(measure.getValue());
                    sonarQubePortfolio.setReleasabilityRating(FormatUtils.toRating(measure.getValue()));
                });
                return sonarQubePortfolio;
            }
            case APPLICATION: {
                SonarQubeApplicationShowResponse sonarQubeApplicationShowResponse;
                SonarQubeApplication sonarQubeApplication;
                LOGGER.debug("Getting basic info for SonarQube Application");
                ShowRequest showRequest = new ShowRequest();
                showRequest.setApplication(string);
                if (string2 != null && !string2.isEmpty()) {
                    showRequest.setBranch(string2);
                }
                if ((sonarQubeApplication = (sonarQubeApplicationShowResponse = new Gson().fromJson(this.wsClient.applications().show(showRequest), SonarQubeApplicationShowResponse.class)).getApplication()).getProjects() != null) {
                    for (SonarQubeProject sonarQubeProject : sonarQubeApplication.getProjects()) {
                        sonarQubeProject.setLastAnalysis(this.getProjectAnalysisDate(sonarQubeProject.getKey(), sonarQubeProject.getBranchName()));
                        sonarQubeProject.setSonarQubeQualifier(SonarQubeQualifier.PROJECT);
                        sonarQubeProject.setQualityGate(this.getProjectStatusResponse(sonarQubeProject.getKey(), sonarQubeProject.getBranchName()).getProjectStatus());
                        sonarQubeProject.setVersion(this.getProjectVersion(sonarQubeProject.getKey(), sonarQubeProject.getBranchName()));
                        sonarQubeProject.setSonarQubeQualityGate(this.getSonarQubeProjectQualityGate(sonarQubeProject.getKey()));
                    }
                }
                SonarQubeApplicationQualityGate sonarQubeApplicationQualityGate = this.getApplicationQualityGate(string, string2);
                sonarQubeApplication.setQualityGate(Qualitygates.ProjectStatusResponse.ProjectStatus.newBuilder().setStatus(Qualitygates.ProjectStatusResponse.Status.valueOf(sonarQubeApplicationQualityGate.getStatus())).build());
                sonarQubeApplication.setVersion(this.getProjectVersion(string, string2));
                sonarQubeApplication.setSonarQubeQualifier(SonarQubeQualifier.APPLICATION);
                sonarQubeApplication.setLastAnalysis(string3);
                sonarQubeApplication.setSonarQubeQualityGate(Qualitygates.QualityGate.newBuilder().build());
                sonarQubeApplication.setApplicationQualityGate(sonarQubeApplicationQualityGate);
                sonarQubeApplication.setSonarQubeBranchList(this.getProjectBranches(string));
                sonarQubeApplication.setMainBranch(this.getProjectMainBranch(sonarQubeApplication.getSonarQubeBranchList()));
                this.getReleasabilityMeasure(string).getComponent().getMeasuresList().forEach(measure -> {
                    sonarQubeApplication.setReleasabilityValue(measure.getValue());
                    sonarQubeApplication.setReleasabilityRating(FormatUtils.toRating(measure.getValue()));
                });
                return sonarQubeApplication;
            }
        }
        return null;
    }

    private Measures.ComponentWsResponse getReleasabilityMeasure(String string) {
        return this.wsClient.measures().component(new ComponentRequest().setComponent(string).setMetricKeys(Collections.singletonList("releasability_rating")));
    }

    public SonarQubeApplicationQualityGate getApplicationQualityGate(String string, String string2) {
        GetRequest getRequest = new GetRequest(this.wsClient.wsConnector().baseUrl() + "api/qualitygates/application_status");
        getRequest.setParam("application", string);
        if (string2 != null && !string2.isEmpty()) {
            getRequest.setParam("branch", string2);
        }
        WsResponse wsResponse = this.wsClient.wsConnector().call(getRequest).failIfNotSuccessful();
        return new Gson().fromJson(wsResponse.content(), SonarQubeApplicationQualityGate.class);
    }

    public Qualitygates.QualityGate getSonarQubeProjectQualityGate(String string) throws SonarQubeException {
        LOGGER.debug("Getting quality gate by project for {}", (Object)string);
        try {
            GetByProjectRequest getByProjectRequest = new GetByProjectRequest();
            getByProjectRequest.setProject(string);
            Qualitygates.GetByProjectResponse getByProjectResponse = this.wsClient.qualitygates().getByProject(getByProjectRequest);
            if (getByProjectResponse != null) {
                return getByProjectResponse.getQualityGate();
            }
        }
        catch (HttpException httpException) {
            LOGGER.debug("Error getting quality gate by project for {}", (Object)string);
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug("Global exception getting quality gate by project for {}", (Object)string);
            throw new SonarQubeException("Global exception getting quality gate by project for " + string);
        }
        return Qualitygates.QualityGate.newBuilder().build();
    }
}

