/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.model;

public class CoverageSVGParams {
    private static final double DEFAULT_COVERAGE_SVG_MAX_PERCENTAGE = 95.0;
    private static final double DEFAULT_COVERAGE_SVG_MIN_PERCENTAGE = 5.0;
    private final Double coverageValue;
    private final Double size;

    public CoverageSVGParams(Double d2, Double d3) {
        this.coverageValue = d2;
        this.size = d3;
    }

    private static double getPercentageValue(double d2, double d3) {
        return d2 * d3 / 100.0;
    }

    public Double getEllipticalArc() {
        return this.getCoordinate() - this.getRadio();
    }

    public Double getCoordinate() {
        return this.size / 2.0;
    }

    public Double getRadio() {
        return CoverageSVGParams.getPercentageValue(this.size / 2.0, 90.0);
    }

    public Double getStrokeWidth() {
        return this.size / 10.0;
    }

    public Double getStrokeGapWidth() {
        return this.getStrokeWidth() + 1.0;
    }

    public Double getGapWidth() {
        return CoverageSVGParams.getPercentageValue(2.0, this.getTotal());
    }

    public Double getSVGValue() {
        return CoverageSVGParams.getPercentageValue(this.getValue(), this.getTotal());
    }

    public Double getValue() {
        double d2 = this.coverageValue > 0.0 && this.coverageValue < 100.0 ? (95.0 < this.coverageValue ? 95.0 : Math.max(5.0, this.coverageValue)) : this.coverageValue;
        return d2;
    }

    public Double getTotal() {
        return this.getRadio() * Math.PI * 2.0;
    }
}

