/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.utils;

import es.sonarqube.api.SonarQubeCustomRequestParam;
import es.sonarqube.api.SonarQubeRule;
import es.sonarqube.model.SonarQubeIssueType;
import java.util.List;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Rules;

public class ParamsUtils {
    public static final String RELEASABILITY_RATING_METRIC = "releasability_rating";

    private ParamsUtils() {
    }

    public static boolean hasValue(Object object) {
        return object != null && !object.toString().isEmpty();
    }

    public static boolean addBugs(List<SonarQubeIssueType> list) {
        return list.contains((Object)SonarQubeIssueType.ALL) || list.contains((Object)SonarQubeIssueType.BUG);
    }

    public static boolean addVulnerabilities(List<SonarQubeIssueType> list) {
        return list.contains((Object)SonarQubeIssueType.ALL) || list.contains((Object)SonarQubeIssueType.VULNERABILITY);
    }

    public static boolean addCodeSmells(List<SonarQubeIssueType> list) {
        return list.contains((Object)SonarQubeIssueType.ALL) || list.contains((Object)SonarQubeIssueType.CODE_SMELL);
    }

    public static Rules.Rule sonarQubeRuleToRule(SonarQubeRule sonarQubeRule) {
        Rules.Rule.Builder builder = Rules.Rule.newBuilder();
        builder.setKey(sonarQubeRule.getKey()).setRepo(sonarQubeRule.getRepo()).setName(sonarQubeRule.getName()).setCreatedAt(sonarQubeRule.getCreatedAt()).setHtmlDesc(sonarQubeRule.getHtmlDesc()).setMdDesc(sonarQubeRule.getMdDesc()).setHtmlNote(sonarQubeRule.getHtmlDesc()).setMdDesc(sonarQubeRule.getMdDesc()).setSeverity(sonarQubeRule.getSeverity()).setIsTemplate(sonarQubeRule.isTemplate()).setTags(Rules.Tags.newBuilder().addAllTags(sonarQubeRule.getTags()).build()).setSysTags(Rules.SysTags.newBuilder().addAllSysTags(sonarQubeRule.getSysTags()).build()).setLang(sonarQubeRule.getLang()).setLangName(sonarQubeRule.getLangName()).setDefaultDebtRemFnType(sonarQubeRule.getDefaultDebtRemFnType()).setDefaultDebtRemFnOffset(sonarQubeRule.getDefaultDebtRemFnOffset()).setDebtRemFnType(sonarQubeRule.getDebtRemFnType()).setDebtRemFnOffset(sonarQubeRule.getDebtRemFnOffset()).setDefaultRemFnType(sonarQubeRule.getDefaultRemFnType()).setDefaultRemFnBaseEffort(sonarQubeRule.getDefaultRemFnBaseEffort()).setRemFnType(sonarQubeRule.getRemFnType()).setRemFnBaseEffort(sonarQubeRule.getRemFnBaseEffort()).setIsExternal(sonarQubeRule.isExternal());
        if (ParamsUtils.hasValue(sonarQubeRule.getStatus())) {
            builder.setStatus(Common.RuleStatus.valueOf(sonarQubeRule.getStatus()));
        }
        if (ParamsUtils.hasValue(sonarQubeRule.getDebtOverloaded())) {
            builder.setDebtOverloaded(Boolean.parseBoolean(sonarQubeRule.getDebtOverloaded()));
        }
        if (ParamsUtils.hasValue(sonarQubeRule.getRemFnOverloaded())) {
            builder.setRemFnOverloaded(Boolean.parseBoolean(sonarQubeRule.getRemFnOverloaded()));
        }
        if (ParamsUtils.hasValue(sonarQubeRule.getType())) {
            builder.setType(Common.RuleType.valueOf(sonarQubeRule.getType()));
        }
        if (ParamsUtils.hasValue(sonarQubeRule.getScope())) {
            builder.setScope(Common.RuleScope.valueOf(sonarQubeRule.getScope()));
        }
        Rules.Rule.Params.Builder builder2 = Rules.Rule.Params.newBuilder();
        sonarQubeRule.getParams().forEach(sonarQubeRuleParam -> builder2.addParams(Rules.Rule.Param.newBuilder().setKey(sonarQubeRuleParam.getKey()).setType(sonarQubeRuleParam.getType()).setDefaultValue(sonarQubeRuleParam.getDefaultValue()).setHtmlDesc(sonarQubeRuleParam.getHtmlDesc()).build()));
        builder.setParams(builder2.build());
        return builder.build();
    }

    public static SonarQubeCustomRequestParam getOrganizationParam(String string) {
        SonarQubeCustomRequestParam sonarQubeCustomRequestParam = new SonarQubeCustomRequestParam();
        sonarQubeCustomRequestParam.setParamKey("organization");
        sonarQubeCustomRequestParam.setParamValue(string);
        return sonarQubeCustomRequestParam;
    }
}

