/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.util;

import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.poi.xslf.util.DummyGraphics2d;
import org.apache.poi.xslf.util.MFProxy;
import org.apache.poi.xslf.util.OutputFormat;

public class DummyFormat
implements OutputFormat {
    private final ByteArrayOutputStream bos;
    private final DummyGraphics2d dummy2d;

    public DummyFormat() {
        try {
            this.bos = new ByteArrayOutputStream();
            this.dummy2d = new DummyGraphics2d(new PrintStream((OutputStream)this.bos, true, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Graphics2D addSlide(double width, double height) throws IOException {
        this.bos.reset();
        return this.dummy2d;
    }

    @Override
    public void writeSlide(MFProxy proxy, File outFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            this.bos.writeTo(fos);
            this.bos.reset();
        }
    }

    @Override
    public void writeDocument(MFProxy proxy, File outFile) throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.bos.reset();
    }
}

