/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeRuleManager;
import es.sonarqube.managers.SonarQubeServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Hotspots;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.hotspots.SearchRequest;
import org.sonarqube.ws.client.hotspots.ShowRequest;

public class SonarQubeHotspotManager {
    private static final String TO_REVIEW = "TO_REVIEW";
    private static final String RULES = "rules";
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeHotspotManager.class);
    private final WsClient wsClient;

    public SonarQubeHotspotManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeHotspotManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    public Map<String, Long> getSecurityHotspotsByRule(String string) {
        return this.getSecurityHotspotsByRule(string, null);
    }

    public Map<String, Long> getSecurityHotspotsByRule(String string, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string3 = "7.9";
        try {
            string3 = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
        }
        catch (SonarQubeException sonarQubeException) {
            LOGGER.error("Unable to get SonarQube version from server: {}", (Object)sonarQubeException.getMessage(), (Object)sonarQubeException);
            LOGGER.warn("We will use {} LTS to retrieve hotsposts", (Object)string3);
        }
        int n = Integer.parseInt(string3.substring(0, 1));
        int n2 = Integer.parseInt(string3.substring(2, 3));
        boolean bl = this.wsClient.wsConnector().baseUrl().contains("sonarcloud.io");
        boolean bl2 = n > 8 || n == 8 && n2 >= 2;
        LOGGER.debug("Retrieving hotspots from SonarQube version: {} (major version {} minor version {})", string3, n, n2);
        if (bl2 || bl) {
            List<Hotspots.SearchWsResponse.Hotspot> list = this.getSecurityHotspotsForSonarQubeHigherThan7(string, string2);
            for (Hotspots.SearchWsResponse.Hotspot hotspot : list) {
                String string4 = hotspot.getKey();
                ShowRequest showRequest = new ShowRequest();
                showRequest.setHotspot(string4);
                Hotspots.ShowWsResponse showWsResponse = this.wsClient.hotspots().show(showRequest);
                String string5 = showWsResponse.getRule().getKey();
                Long l = hashMap.getOrDefault(string5, 0L) + 1L;
                hashMap.put(string5, l);
            }
        } else if (n >= 7) {
            org.sonarqube.ws.client.issues.SearchRequest searchRequest = new org.sonarqube.ws.client.issues.SearchRequest();
            searchRequest.setComponentKeys(Collections.singletonList(string));
            searchRequest.setTypes(Collections.singletonList("SECURITY_HOTSPOT"));
            searchRequest.setFacets(Collections.singletonList(RULES));
            searchRequest.setResolved("false");
            if (string2 != null && !string2.isEmpty()) {
                searchRequest.setBranch(string2);
            }
            hashMap.putAll(this.getSecurityHotspotsForSonarQube7(searchRequest));
            LOGGER.debug("Total hotspots rules with issues found:  {}", (Object)hashMap.size());
        } else {
            LOGGER.warn("SonarQube {} version doesn't support Security HotSpots. No HotSpots found.", (Object)string3);
        }
        return this.sortByValue(hashMap);
    }

    protected Map<String, Long> getSecurityHotspotsForSonarQube7(org.sonarqube.ws.client.issues.SearchRequest searchRequest) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        for (Common.Facet facet : searchWsResponse.getFacets().getFacetsList()) {
            if (!RULES.equals(facet.getProperty())) continue;
            List<Common.FacetValue> list = facet.getValuesList();
            for (Common.FacetValue facetValue : list) {
                String string = facetValue.getVal();
                Long l = facetValue.getCount();
                hashMap.put(string, l);
            }
        }
        return hashMap;
    }

    public Map<String, Long> getAllSecurityHotspots(String string) throws SonarQubeException {
        return this.getSecurityHotspotsForSeverity(string, null, null);
    }

    public Map<String, Long> getAllSecurityHotspots(String string, String string2) throws SonarQubeException {
        return this.getSecurityHotspotsForSeverity(string, null, string2);
    }

    public Map<String, Long> getSecurityHotspotsForSeverity(String string, String string2) throws SonarQubeException {
        return this.getSecurityHotspotsForSeverity(string, string2, null);
    }

    public Map<String, Long> getSecurityHotspotsForSeverity(String string, String string2, String string3) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string4 = "7.9";
        try {
            string4 = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
        }
        catch (SonarQubeException sonarQubeException) {
            LOGGER.error("Unable to get SonarQube version from server: {}", (Object)sonarQubeException.getMessage(), (Object)sonarQubeException);
            LOGGER.warn("We will use {} LTS to retrieve hotsposts", (Object)string4);
        }
        int n = Integer.parseInt(string4.substring(0, 1));
        int n2 = Integer.parseInt(string4.substring(2, 3));
        boolean bl = this.wsClient.wsConnector().baseUrl().contains("sonarcloud.io");
        boolean bl2 = n > 8 || n == 8 && n2 >= 2;
        LOGGER.debug("Retrieving hotspots from SonarQube version for severity {}: {} (major version {} minor version {})", string2, string4, n, n2);
        if (bl2 || bl) {
            List<Hotspots.SearchWsResponse.Hotspot> list = this.getSecurityHotspotsForSonarQubeHigherThan7(string, string3);
            for (Hotspots.SearchWsResponse.Hotspot hotspot : list) {
                String string5 = hotspot.getKey();
                ShowRequest showRequest = new ShowRequest();
                showRequest.setHotspot(string5);
                Hotspots.ShowWsResponse showWsResponse = this.wsClient.hotspots().show(showRequest);
                String string6 = showWsResponse.getRule().getKey();
                String string7 = SonarQubeRuleManager.getRule(this.wsClient, string6).getSeverity();
                if (string2 != null && !string2.equals(string7)) continue;
                Long l = hashMap.getOrDefault(string6, 0L) + 1L;
                hashMap.put(string6, l);
            }
        } else if (n >= 7) {
            org.sonarqube.ws.client.issues.SearchRequest searchRequest = new org.sonarqube.ws.client.issues.SearchRequest();
            searchRequest.setComponentKeys(Collections.singletonList(string));
            searchRequest.setTypes(Collections.singletonList("SECURITY_HOTSPOT"));
            if (string2 != null) {
                searchRequest.setSeverities(Collections.singletonList(string2));
            }
            searchRequest.setFacets(Collections.singletonList(RULES));
            searchRequest.setResolved("false");
            if (string3 != null && !string3.isEmpty()) {
                searchRequest.setBranch(string3);
            }
            hashMap.putAll(this.getSecurityHotspotsForSonarQube7(searchRequest));
            LOGGER.debug("Total hotspots rules with issues found for severity {}:  {}", (Object)string2, (Object)hashMap.size());
        } else {
            LOGGER.warn("SonarQube {} version doesn't support Security HotSpots. No HotSpots found.", (Object)string4);
        }
        return this.sortByValue(hashMap);
    }

    public List<Hotspots.ShowWsResponse> getSecurityHotspotsForRule(String string, String string2) {
        return this.getSecurityHotspotsForRule(string, null);
    }

    public List<Hotspots.ShowWsResponse> getSecurityHotspotsForRule(String string, String string2, String string3) {
        ArrayList<Hotspots.ShowWsResponse> arrayList = new ArrayList<Hotspots.ShowWsResponse>();
        List<Hotspots.SearchWsResponse.Hotspot> list = this.getSecurityHotspotsForSonarQubeHigherThan7(string, string3);
        for (Hotspots.SearchWsResponse.Hotspot hotspot : list) {
            String string4 = hotspot.getKey();
            ShowRequest showRequest = new ShowRequest();
            showRequest.setHotspot(string4);
            Hotspots.ShowWsResponse showWsResponse = this.wsClient.hotspots().show(showRequest);
            String string5 = showWsResponse.getRule().getKey();
            if (!string2.equals(string5)) continue;
            arrayList.add(showWsResponse);
        }
        return arrayList;
    }

    protected List<Hotspots.SearchWsResponse.Hotspot> getSecurityHotspotsForSonarQubeHigherThan7(String string, String string2) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setPs("500");
        searchRequest.setProjectKey(string);
        searchRequest.setStatus(TO_REVIEW);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        Hotspots.SearchWsResponse searchWsResponse = this.wsClient.hotspots().search(searchRequest);
        ArrayList<Hotspots.SearchWsResponse.Hotspot> arrayList = new ArrayList<Hotspots.SearchWsResponse.Hotspot>(searchWsResponse.getHotspotsList());
        if (searchWsResponse.hasPaging()) {
            Integer n = searchWsResponse.getPaging().getTotal();
            LOGGER.debug("Total hotspots found: {}", (Object)n);
            Double d = Math.ceil((double)n.intValue() / 500.0);
            LOGGER.debug("Total hotspot pages:  {}", (Object)d);
            int n2 = 2;
            while ((double)n2 <= d) {
                LOGGER.debug("Requesting hotspots page {} of {}", (Object)n2, (Object)d);
                searchRequest = new SearchRequest();
                searchRequest.setPs("500");
                searchRequest.setProjectKey(string);
                searchRequest.setStatus(TO_REVIEW);
                searchRequest.setP(Integer.toString(n2));
                if (string2 != null && !string2.isEmpty()) {
                    searchRequest.setBranch(string2);
                }
                searchWsResponse = this.wsClient.hotspots().search(searchRequest);
                arrayList.addAll(searchWsResponse.getHotspotsList());
                ++n2;
            }
        }
        return arrayList;
    }

    private Map<String, Long> sortByValue(Map<String, Long> map) {
        return map.entrySet().stream().sorted((entry, entry2) -> ((Long)entry2.getValue()).compareTo((Long)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, l2) -> l, LinkedHashMap::new));
    }
}

