/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.common.util.concurrent.AtomicDouble;
import es.sonarqube.api.Metric;
import es.sonarqube.api.SonarQubeMeasure;
import es.sonarqube.api.SonarQubeMetric;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeMetricManager;
import es.sonarqube.managers.SonarQubeProjectManager;
import es.sonarqube.utils.FormatUtils;
import es.sonarqube.utils.WorkDuration;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Measures;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.measures.ComponentRequest;

public class SonarQubeMeasureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeMeasureManager.class);
    private final WsClient wsClient;
    private final Locale userLocale;

    public SonarQubeMeasureManager(WsClient wsClient, Locale locale) {
        this.wsClient = wsClient;
        this.userLocale = locale;
    }

    public SonarQubeMeasureManager(String string, String string2, Locale locale) {
        this.userLocale = locale;
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static List<SonarQubeMeasure> getMeasures(WsClient wsClient, String string, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeMeasureManager(wsClient, locale).getMeasures(string, list);
    }

    protected static List<SonarQubeMeasure> getMeasures(WsClient wsClient, List<String> list, List<String> list2, Locale locale) throws SonarQubeException {
        return new SonarQubeMeasureManager(wsClient, locale).getMeasures(list, list2);
    }

    protected static Map<String, Object> getAggregatedMeasures(WsClient wsClient, List<String> list, List<String> list2, Locale locale) throws SonarQubeException {
        return new SonarQubeMeasureManager(wsClient, locale).getAggregatedMeasures(list, list2);
    }

    public Map<String, String> getMeasuresMap(String string, String string2, List<String> list) throws SonarQubeException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (SonarQubeMeasure sonarQubeMeasure : this.getMeasures(Collections.singletonList(string), string2, list)) {
            LOGGER.debug("Measure {}", (Object)sonarQubeMeasure.getName());
            for (SonarQubeMetric sonarQubeMetric : sonarQubeMeasure.getSonarQubeMetricList()) {
                LOGGER.debug("{}: {}", (Object)sonarQubeMetric.getKey(), (Object)sonarQubeMetric.getValue());
                hashMap.put(sonarQubeMetric.getKey(), sonarQubeMetric.getValue());
            }
        }
        return hashMap;
    }

    public List<SonarQubeMeasure> getMeasures(String string, String string2, List<String> list) throws SonarQubeException {
        return this.getMeasures(Collections.singletonList(string), string2, list);
    }

    public List<SonarQubeMeasure> getMeasures(List<String> list, List<String> list2) throws SonarQubeException {
        return this.getMeasures(list, null, list2);
    }

    public Map<String, Object> getAggregatedMeasures(List<String> list, List<String> list2) throws SonarQubeException {
        return this.getAggregatedMeasures(list, list2, Collections.emptyList());
    }

    public Map<String, Object> getAggregatedMeasures(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getAggregatedMeasures(list, list2, Arrays.asList(string));
    }

    public Map<String, Object> getAggregatedMeasures(List<String> list, List<String> list2, List<String> list3) throws SonarQubeException {
        String string = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        try {
            AtomicDouble atomicDouble = new AtomicDouble(0.0);
            AtomicDouble atomicDouble2 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble3 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble4 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble5 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble6 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble7 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble8 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble9 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble10 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble11 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble12 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble13 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble14 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble15 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble16 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble17 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble18 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble19 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble20 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble21 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble22 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble23 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble24 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble25 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble26 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble27 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble28 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble29 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble30 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble31 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble32 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble33 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble34 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble35 = new AtomicDouble(0.0);
            AtomicDouble atomicDouble36 = new AtomicDouble(0.0);
            Map<String, Integer> map = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map2 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map3 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map4 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map5 = this.createDistributionMap(Arrays.asList("XL", "L", "M", "S", "XS"), 0);
            Map<String, Integer> map6 = this.createDistributionMap(Arrays.asList("A", "B", "C", "D", "E"), 0);
            Map<String, Integer> map7 = this.createDistributionMap(Arrays.asList("NO_DATA", "A", "B", "C", "D", "E"), 0);
            String string2 = "-period1";
            String string3 = "-period1";
            String string4 = "-diff";
            LOGGER.debug("Getting info for {} projects...", (Object)list.size());
            for (String string5 : list) {
                string5 = string5.trim();
                List<ProjectBranches.Branch> list4 = SonarQubeProjectManager.getProjectBranches(this.wsClient, string5, this.userLocale);
                boolean bl = true;
                for (String string6 : list3) {
                    if (list4 != null) {
                        for (ProjectBranches.Branch branch : list4) {
                            if (!branch.getName().equals(string6)) continue;
                            bl = false;
                            string = string6;
                            break;
                        }
                    }
                    if (bl) continue;
                    break;
                }
                List<SonarQubeMeasure> list5 = bl ? this.getMeasures(string5, null, list2) : this.getMeasures(string5, string, list2);
                list5.forEach(sonarQubeMeasure -> sonarQubeMeasure.getSonarQubeMetricList().forEach(sonarQubeMetric -> {
                    try {
                        if ("lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble2.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("ncloc".equals(sonarQubeMetric.getKey())) {
                            atomicDouble3.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble4.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("bugs".equals(sonarQubeMetric.getKey())) {
                            atomicDouble6.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("bugs" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble11.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_bugs" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble10.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("vulnerabilities".equals(sonarQubeMetric.getKey())) {
                            atomicDouble12.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("vulnerabilities" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble13.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_vulnerabilities" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble14.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("security_hotspots".equals(sonarQubeMetric.getKey())) {
                            atomicDouble15.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("security_hotspots" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble16.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_security_hotspots" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble17.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("code_smells".equals(sonarQubeMetric.getKey())) {
                            atomicDouble18.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("code_smells" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble19.getAndAdd(FormatUtils.getNumber().parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_code_smells" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble20.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("sqale_index".equals(sonarQubeMetric.getKey())) {
                            if (sonarQubeMetric.getValue().equals("0")) {
                                atomicDouble21.getAndAdd(WorkDuration.decode("0d", 8).toMinutes());
                            } else {
                                atomicDouble21.getAndAdd(WorkDuration.decode(sonarQubeMetric.getValue(), 8).toMinutes());
                            }
                        }
                        if (("sqale_index" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble22.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("duplicated_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble5.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("duplicated_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble7.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("comment_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble8.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("comment_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble9.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("reliability_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble33.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map.putAll(this.processDistribution(map, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("security_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble34.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map2.putAll(this.processDistribution(map2, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("security_review_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble35.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map3.putAll(this.processDistribution(map3, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("sqale_rating".equals(sonarQubeMetric.getKey())) {
                            atomicDouble36.getAndAdd(FormatUtils.ratingToDouble(sonarQubeMetric.getValue()));
                            map4.putAll(this.processDistribution(map4, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("size_rating".equals(sonarQubeMetric.getKey())) {
                            map5.putAll(this.processDistribution(map5, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("duplicated_lines_rating".equals(sonarQubeMetric.getKey())) {
                            map6.putAll(this.processDistribution(map6, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("coverage_rating".equals(sonarQubeMetric.getKey())) {
                            map7.putAll(this.processDistribution(map7, (SonarQubeMetric)sonarQubeMetric));
                        }
                        if ("conditions_to_cover".equals(sonarQubeMetric.getKey())) {
                            atomicDouble26.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("uncovered_conditions".equals(sonarQubeMetric.getKey())) {
                            atomicDouble25.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("lines_to_cover".equals(sonarQubeMetric.getKey())) {
                            atomicDouble27.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if ("uncovered_lines".equals(sonarQubeMetric.getKey())) {
                            atomicDouble28.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_conditions_to_cover" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble30.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_uncovered_conditions" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble29.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_lines_to_cover" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble31.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                        if (("new_uncovered_lines" + string2).equals(sonarQubeMetric.getKey())) {
                            atomicDouble32.getAndAdd(FormatUtils.getNumber(this.userLocale).parse(sonarQubeMetric.getValue()).doubleValue());
                        }
                    }
                    catch (ParseException parseException) {
                        LOGGER.error("Error calculating aggregated measures : {}", (Object)parseException.getMessage());
                    }
                }));
            }
            atomicDouble23.set((atomicDouble26.get() - atomicDouble25.get() + atomicDouble27.get() - atomicDouble28.get()) / (atomicDouble26.get() + atomicDouble27.get()));
            if (Double.isNaN(atomicDouble23.get())) {
                atomicDouble23.set(0.0);
            }
            atomicDouble24.set((atomicDouble30.get() - atomicDouble29.get() + atomicDouble31.get() - atomicDouble32.get()) / (atomicDouble30.get() + atomicDouble31.get()));
            if (Double.isNaN(atomicDouble24.get())) {
                atomicDouble24.set(0.0);
            }
            hashMap2.put("lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble.get()));
            hashMap2.put("lines" + string2, FormatUtils.getNumber(this.userLocale).format(atomicDouble2.get()));
            hashMap2.put("size_rating", FormatUtils.toSizeRating(atomicDouble3.get()));
            hashMap2.put("bugs", FormatUtils.getNumber(this.userLocale).format(atomicDouble6.get()));
            hashMap2.put("bugs" + string4, FormatUtils.getNumber(this.userLocale).format(atomicDouble11));
            hashMap2.put("bugs" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble10));
            hashMap2.put("vulnerabilities", FormatUtils.getNumber(this.userLocale).format(atomicDouble12));
            hashMap2.put("vulnerabilities" + string4, FormatUtils.getNumber(this.userLocale).format(atomicDouble13));
            hashMap2.put("vulnerabilities" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble14));
            hashMap2.put("security_hotspots", FormatUtils.getNumber(this.userLocale).format(atomicDouble15));
            hashMap2.put("security_hotspots" + string4, FormatUtils.getNumber(this.userLocale).format(atomicDouble16));
            hashMap2.put("security_hotspots" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble17));
            hashMap2.put("code_smells", FormatUtils.getNumber(this.userLocale).format(atomicDouble18));
            hashMap2.put("code_smells" + string4, FormatUtils.getNumber().format(atomicDouble19));
            hashMap2.put("code_smells" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble20));
            double d = atomicDouble21.get() / (atomicDouble3.get() * 30.0);
            hashMap2.put("sqale_debt_ratio", FormatUtils.getPercentage(this.userLocale).format(d));
            double d2 = d - (atomicDouble21.get() - atomicDouble22.get()) / ((atomicDouble3.get() - atomicDouble4.get()) * 30.0);
            hashMap2.put("sqale_debt_ratio" + string3, FormatUtils.getPercentage(this.userLocale).format(d2));
            hashMap2.put("ncloc", FormatUtils.getNumber(this.userLocale).format(atomicDouble3.get()));
            hashMap2.put("ncloc" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble4.get()));
            hashMap2.put("duplicated_lines", FormatUtils.getNumber(this.userLocale).format(atomicDouble5.get()));
            hashMap2.put("duplicated_lines" + string3, FormatUtils.getNumber(this.userLocale).format(atomicDouble7.get()));
            double d3 = atomicDouble5.get() / atomicDouble.get();
            double d4 = 1.0 - d3;
            hashMap2.put("duplicated_lines_density_value", FormatUtils.getNumber(Locale.US).format(d3 * 100.0));
            hashMap2.put("duplicated_lines_density_rest", FormatUtils.getNumber(Locale.US).format(d4 * 100.0));
            hashMap2.put("duplicated_lines_density", FormatUtils.getPercentage(this.userLocale).format(d3));
            double d5 = (atomicDouble5.get() + atomicDouble7.get()) / (atomicDouble.get() + atomicDouble2.get()) - d3;
            hashMap2.put("duplicated_lines_density" + string3, FormatUtils.getPercentage(this.userLocale).format(d5));
            double d6 = atomicDouble8.get() / atomicDouble.get();
            double d7 = 1.0 - d6;
            hashMap2.put("comment_lines_density_value", FormatUtils.getNumber(Locale.US).format(d6 * 100.0));
            hashMap2.put("comment_lines_density_rest", FormatUtils.getNumber(Locale.US).format(d7 * 100.0));
            hashMap2.put("comment_lines_density", FormatUtils.getPercentage(this.userLocale).format(d6));
            double d8 = d6 - (atomicDouble8.get() - atomicDouble9.get()) / (atomicDouble.get() - atomicDouble2.get());
            hashMap2.put("comment_lines_density" + string3, FormatUtils.getPercentage(this.userLocale).format(d8));
            double d9 = atomicDouble23.get();
            double d10 = 1.0 - d9;
            hashMap2.put("coverage_value", FormatUtils.getNumber(Locale.US).format(d9 * 100.0));
            hashMap2.put("coverage_rest", FormatUtils.getNumber(Locale.US).format(d10 * 100.0));
            hashMap2.put("coverage", FormatUtils.getPercentage(this.userLocale).format(d9));
            hashMap2.put("coverage" + string3, FormatUtils.getPercentage(this.userLocale).format(atomicDouble24.get()));
            atomicDouble33.set(atomicDouble33.get() / (double)list.size());
            atomicDouble34.set(atomicDouble34.get() / (double)list.size());
            atomicDouble35.set(atomicDouble35.get() / (double)list.size());
            atomicDouble36.set(atomicDouble36.get() / (double)list.size());
            hashMap2.put("reliability_rating", FormatUtils.doubleToRating(atomicDouble33.get()));
            hashMap2.put("security_rating", FormatUtils.doubleToRating(atomicDouble34.get()));
            hashMap2.put("security_review_rating", FormatUtils.doubleToRating(atomicDouble35.get()));
            hashMap2.put("sqale_rating", FormatUtils.doubleToRating(atomicDouble36.get()));
            hashMap2.put("duplicated_lines_rating", FormatUtils.duplicatedLinesToRating(d3 * 100.0));
            hashMap2.put("coverage_rating", FormatUtils.coverageToRating(d9 * 100.0));
            hashMap.put("reliability_rating_distribution", map);
            hashMap.put("security_rating_distribution", map2);
            hashMap.put("security_review_rating_distribution", map3);
            hashMap.put("sqale_rating_distribution", map4);
            hashMap.put("size_rating_distribution", map5);
            hashMap.put("duplicated_lines_rating_distribution", map6);
            hashMap.put("coverage_rating_distribution", map7);
        }
        catch (HttpException httpException) {
            LOGGER.error("Error HTTP getting aggregated measures from ({}) with metrics ({}), error -> {}", list, list2, httpException.content(), httpException);
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.error("Error getting aggregated measures from ({}) with metrics ({}), error -> {}", list, list2, exception.getMessage(), exception);
            throw new SonarQubeException(String.format("Error getting aggregated measures: %s", exception.getMessage()), exception);
        }
        hashMap.put("aggregatedMeasuresMap", hashMap2);
        return hashMap;
    }

    private List<SonarQubeMeasure> getMeasures(String string, List<String> list) throws SonarQubeException {
        return this.getMeasures(Collections.singletonList(string), list);
    }

    private List<SonarQubeMeasure> getMeasures(List<String> list, String string, List<String> list2) throws SonarQubeException {
        ArrayList<SonarQubeMeasure> arrayList = new ArrayList<SonarQubeMeasure>();
        Map<String, Metric> map = SonarQubeMetricManager.getMetrics(this.wsClient);
        try {
            list.forEach(string2 -> {
                LOGGER.debug("getting measures for {}", string2);
                ArrayList<SonarQubeMetric> arrayList = new ArrayList<SonarQubeMetric>();
                ComponentRequest componentRequest = new ComponentRequest();
                componentRequest.setMetricKeys(list2.stream().distinct().collect(Collectors.toList()));
                componentRequest.setComponent((String)string2);
                componentRequest.setAdditionalFields(Arrays.asList("periods"));
                if (string != null && !string.isEmpty()) {
                    componentRequest.setBranch(string);
                }
                LOGGER.debug("Component Request is ready...");
                Measures.ComponentWsResponse componentWsResponse = this.wsClient.measures().component(componentRequest);
                LOGGER.debug("Component Request done!");
                componentWsResponse.getComponent().getMeasuresList().forEach(measure -> {
                    ArrayList<SonarQubeMeasure> arrayList = measure.getPeriods() == null ? Collections.emptyList() : measure.getPeriods().getPeriodsValueList();
                    String string = ((Metric)map.get(measure.getMetric())).getType();
                    SonarQubeMetric sonarQubeMetric = new SonarQubeMetric();
                    sonarQubeMetric.setKey(measure.getMetric());
                    sonarQubeMetric.setType(string);
                    LOGGER.debug("Processing metric: {} ... type {}", (Object)measure.getMetric(), (Object)string);
                    if ("ncloc".equals(measure.getMetric())) {
                        Object object = new SonarQubeMetric();
                        ((SonarQubeMetric)object).setKey("size_rating");
                        ((SonarQubeMetric)object).setValue(FormatUtils.toSizeRating(measure.getValue()));
                        ((SonarQubeMetric)object).setType(string);
                        arrayList.add((SonarQubeMetric)object);
                    }
                    switch (sonarQubeMetric.getType()) {
                        case "PERCENT": {
                            SonarQubeMetric sonarQubeMetric2;
                            double d = 0.0;
                            if (!measure.getValue().isEmpty()) {
                                d = Double.parseDouble(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                d = Double.parseDouble(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            double d2 = 100.0 - d;
                            if ("duplicated_lines_density".equals(sonarQubeMetric.getKey())) {
                                sonarQubeMetric2 = new SonarQubeMetric();
                                sonarQubeMetric2.setKey("duplicated_lines_rating");
                                sonarQubeMetric2.setValue(FormatUtils.duplicatedLinesToRating(d));
                                sonarQubeMetric2.setType(string);
                                arrayList.add(sonarQubeMetric2);
                            }
                            if ("coverage".equals(sonarQubeMetric.getKey())) {
                                sonarQubeMetric2 = new SonarQubeMetric();
                                sonarQubeMetric2.setKey("coverage_rating");
                                sonarQubeMetric2.setValue(FormatUtils.coverageToRating(d));
                                sonarQubeMetric2.setType(string);
                                arrayList.add(sonarQubeMetric2);
                            }
                            sonarQubeMetric.setValue(FormatUtils.getNumber(this.userLocale).format(d));
                            sonarQubeMetric2 = new SonarQubeMetric();
                            sonarQubeMetric2.setKey(sonarQubeMetric.getKey() + "_value");
                            sonarQubeMetric2.setValue(FormatUtils.getNumber(Locale.US).format(d));
                            sonarQubeMetric2.setType(sonarQubeMetric.getType());
                            arrayList.add(sonarQubeMetric2);
                            SonarQubeMetric sonarQubeMetric3 = new SonarQubeMetric();
                            sonarQubeMetric3.setKey(sonarQubeMetric.getKey() + "_rest");
                            sonarQubeMetric3.setValue(FormatUtils.getNumber(Locale.US).format(d2));
                            sonarQubeMetric3.setType(sonarQubeMetric.getType());
                            arrayList.add(sonarQubeMetric3);
                            arrayList.forEach(periodValue -> {
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.getPercentage(this.userLocale).format(Double.parseDouble(periodValue.getValue()) / 100.0), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "RATING": {
                            sonarQubeMetric.setValue("A");
                            if (!measure.getValue().isEmpty()) {
                                sonarQubeMetric.setValue(FormatUtils.toRating(measure.getValue()));
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                sonarQubeMetric.setValue(FormatUtils.toRating(((Measures.PeriodValue)arrayList.get(0)).getValue()));
                            }
                            arrayList.forEach(periodValue -> {
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.toRating(periodValue.getValue()), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "WORK_DUR": {
                            long l = 0L;
                            if (!measure.getValue().isEmpty()) {
                                l = Long.parseLong(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                l = Long.parseLong(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            WorkDuration workDuration = WorkDuration.create(l);
                            sonarQubeMetric.setValue(WorkDuration.format(workDuration));
                            arrayList.forEach(periodValue -> {
                                long l = Long.parseLong(periodValue.getValue());
                                WorkDuration workDuration = WorkDuration.create(l);
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), WorkDuration.format(workDuration), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "INT": {
                            int n = 0;
                            if (!measure.getValue().isEmpty()) {
                                n = Integer.parseInt(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                n = Integer.parseInt(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            sonarQubeMetric.setValue(FormatUtils.getNumber(this.userLocale).format(n));
                            arrayList.forEach(periodValue -> {
                                int n = periodValue.getValue().isEmpty() ? 0 : Integer.parseInt(periodValue.getValue());
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.getNumber(this.userLocale).format(n), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        case "FLOAT": {
                            double d = 0.0;
                            if (!measure.getValue().isEmpty()) {
                                d = Double.parseDouble(measure.getValue());
                            } else if (measure.getValue().isEmpty() && !arrayList.isEmpty()) {
                                d = Double.parseDouble(((Measures.PeriodValue)arrayList.get(0)).getValue());
                            }
                            sonarQubeMetric.setValue(FormatUtils.getNumber(this.userLocale).format(d));
                            arrayList.forEach(periodValue -> {
                                double d = periodValue.getValue().isEmpty() ? 0.0 : Double.parseDouble(periodValue.getValue());
                                SonarQubeMetric sonarQubeMetric2 = this.createPeriodMetric(sonarQubeMetric.getKey(), sonarQubeMetric.getType(), FormatUtils.getNumber(this.userLocale).format(d), periodValue.getIndex());
                                arrayList.add(sonarQubeMetric2);
                            });
                            break;
                        }
                        default: {
                            sonarQubeMetric.setValue(measure.getValue());
                        }
                    }
                    arrayList.add(sonarQubeMetric);
                });
                SonarQubeMeasure sonarQubeMeasure = new SonarQubeMeasure();
                sonarQubeMeasure.setComponentKey((String)string2);
                sonarQubeMeasure.setComponentName(componentWsResponse.getComponent().getName());
                sonarQubeMeasure.setSonarQubeMetricList(arrayList);
                arrayList.add(sonarQubeMeasure);
            });
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting measures from (%s), with metrics (%s), error -> %s", list, list2, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting measures from (%s), with metrics (%s), error -> %s", list, list2, exception));
            throw new SonarQubeException(String.format("Error getting measures: %s", exception.getMessage()));
        }
        SonarQubeMeasureManager.printMeasuresMap(arrayList);
        return arrayList;
    }

    private Map<String, Integer> processDistribution(Map<String, Integer> map, SonarQubeMetric sonarQubeMetric) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = map.get(sonarQubeMetric.getValue()) == null ? 0 : map.get(sonarQubeMetric.getValue());
        hashMap.put(sonarQubeMetric.getValue(), n + 1);
        return hashMap;
    }

    private Map<String, Integer> createDistributionMap(List<String> list, int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        list.forEach(string -> hashMap.put((String)string, n));
        return hashMap;
    }

    private SonarQubeMetric createSonarQubeMetric(String string, String string2, String string3) {
        SonarQubeMetric sonarQubeMetric = new SonarQubeMetric();
        sonarQubeMetric.setKey(string);
        sonarQubeMetric.setValue(string3);
        sonarQubeMetric.setType(string2);
        LOGGER.debug("{}   value: {}", (Object)sonarQubeMetric.getKey(), (Object)sonarQubeMetric.getValue());
        return sonarQubeMetric;
    }

    private SonarQubeMetric createPeriodMetric(String string, String string2, String string3, int n) {
        return this.createSonarQubeMetric(string + "-period" + n, string2, string3);
    }

    private static void printMeasuresMap(List<SonarQubeMeasure> list) {
        list.forEach(sonarQubeMeasure -> sonarQubeMeasure.getSonarQubeMetricList().forEach(sonarQubeMetric -> LOGGER.debug("Metric Key: {} ... Metric Value: {}", (Object)sonarQubeMetric.getKey(), (Object)sonarQubeMetric.getValue())));
    }
}

