/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.gson.Gson;
import es.sonarqube.api.Metric;
import es.sonarqube.api.MetricResponse;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.metrics.SearchRequest;

public class SonarQubeMetricManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeMetricManager.class);
    private final WsClient wsClient;

    public SonarQubeMetricManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeMetricManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static Map<String, Metric> getMetrics(WsClient wsClient) throws SonarQubeException {
        return new SonarQubeMetricManager(wsClient).getMetrics();
    }

    public Map<String, Metric> getMetrics() throws SonarQubeException {
        HashMap<String, Metric> hashMap = new HashMap<String, Metric>();
        String string = "Error getting metrics, error -> %s";
        try {
            LOGGER.debug("Getting metrics...");
            SearchRequest searchRequest = new SearchRequest();
            String string2 = this.wsClient.metrics().search(searchRequest);
            MetricResponse metricResponse = new Gson().fromJson(string2, MetricResponse.class);
            if (metricResponse.getTotal() > metricResponse.getPs()) {
                LOGGER.debug("More than one page metrics found, getting all rest metrics...");
                int n = (int)Math.floor((double)metricResponse.getTotal() / (double)metricResponse.getPs()) + 1;
                for (int i = 2; i <= n; ++i) {
                    searchRequest.setP("" + i);
                    string2 = this.wsClient.metrics().search(searchRequest);
                    metricResponse.getMetrics().addAll(new Gson().fromJson(string2, MetricResponse.class).getMetrics());
                }
            }
            LOGGER.debug("Total metrics founds: {}", (Object)metricResponse.getTotal());
            metricResponse.getMetrics().forEach(metric -> hashMap.put(metric.getKey(), (Metric)metric));
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format(string, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.debug(String.format(string, exception));
            throw new SonarQubeException(String.format(string, exception.getMessage()));
        }
        return hashMap;
    }
}

