/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import es.sonarqube.cache.Cache;
import es.sonarqube.cache.CacheManager;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.rules.SearchRequest;

public class SonarQubeRuleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeRuleManager.class);
    private final WsClient wsClient;

    public SonarQubeRuleManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeRuleManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static Rules.Rule getRule(WsClient wsClient, String string) throws SonarQubeException {
        return new SonarQubeRuleManager(wsClient).getRule(string);
    }

    public Rules.Rule getRule(String string) throws SonarQubeException {
        try {
            Cache cache = CacheManager.getCacheInstance();
            Rules.Rule rule = (Rules.Rule)cache.get(string);
            if (rule == null) {
                Rules.SearchResponse searchResponse;
                LOGGER.debug("Contacting SonarQube to get rule: {}", (Object)string);
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.setRuleKey(string);
                if (this.wsClient.wsConnector().baseUrl().contains("sonarcloud.io")) {
                    searchRequest.setOrganization("sonarsource");
                }
                rule = (searchResponse = this.wsClient.rules().search(searchRequest)) != null && searchResponse.getRulesList().size() == 1 ? searchResponse.getRulesList().get(0) : Rules.Rule.newBuilder().setName(string).setLang("-").setLangName("-").build();
                cache.add(string, rule);
            } else {
                LOGGER.debug("Rule obtained from cache: {}", (Object)string);
            }
            return rule;
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting rule (%s), error -> %s", string, httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting rule (%s), error -> %s", string, exception));
            throw new SonarQubeException(String.format("Error getting rule, error -> %s", exception.getMessage()));
        }
    }
}

