/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.licenser.common;

import com.bitegarden.licenser.common.data.DownloadCert;
import com.bitegarden.licenser.common.data.DownloadInfo;
import com.bitegarden.licenser.common.data.LicenseCert;
import com.bitegarden.licenser.common.data.LicenseCertServerID;
import com.bitegarden.licenser.common.exception.LicenserFatalException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import net.iharder.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CriptoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CriptoUtil.class);
    private static final String ENCODING = "utf8";
    private static final String CRIPTO_TRANSFORMATION = "RSA";
    private static final String BREAK_STRING = "A";
    private static final String CHECK_MSG = "Lorem ipsum dolor sit amet, consectetur adipiscing elit.";
    private static final String WARN_CLOSING_OUTPUT = "Could'n close input stream";
    private static final String CANNOT_DECRYPT = "Cannot decrypt";
    private static final String CANNOT_GET_PK = "Cannot get private key from string";
    private static final int ENCRYPT_PKG_SIZE = 117;
    private static final int KEY_SIZE = 1024;
    private static final int DECRYPT_PKG_SIZE = 128;
    private static KeyPairGenerator keyGen;

    private CriptoUtil() {
    }

    protected static void close(InputStream inputStream2) {
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (IOException iOException) {
            LOG.warn(WARN_CLOSING_OUTPUT, iOException);
        }
    }

    protected static void close(OutputStream outputStream2) {
        try {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            LOG.warn(WARN_CLOSING_OUTPUT, iOException);
        }
    }

    private static byte[] encrypt(byte[] byArray, Key key, String string) {
        byte[] byArray2 = null;
        try {
            Key key2 = key;
            if (string != null && string.compareTo("1.5") >= 0 && RSAPrivateKey.class.isAssignableFrom(key2.getClass())) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                KeyFactory keyFactory = KeyFactory.getInstance(CRIPTO_TRANSFORMATION);
                key2 = keyFactory.generatePublic(rSAPublicKeySpec);
            }
            byArray2 = CriptoUtil.encrypt14Mode(byArray, key2);
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot encrypt", exception);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("ENCRYPTED: {}", (Object)Base64.encodeBytes(byArray2));
        }
        return byArray2;
    }

    protected static byte[] encrypt14Mode(byte[] byArray, Key key) throws Exception {
        byte[] byArray2 = new byte[]{};
        for (int i = 0; i < byArray.length; i += 117) {
            int n = i + 117;
            if (n > byArray.length) {
                n = byArray.length;
            }
            byte[] byArray3 = ArrayUtils.subarray(byArray, i, n);
            Cipher cipher = Cipher.getInstance(CRIPTO_TRANSFORMATION);
            cipher.init(1, key);
            byArray2 = ArrayUtils.addAll(byArray2, cipher.doFinal(byArray3));
        }
        return byArray2;
    }

    protected static String encryptObj(Serializable serializable, Key key, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = CriptoUtil.encrypt(byArray, key, string);
            String string2 = Base64.encodeBytes(byArray2);
            return string2;
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot encrypt object", exception);
        }
        finally {
            CriptoUtil.close(byteArrayOutputStream);
        }
    }

    protected static byte[] decrypt(byte[] byArray, Key key) {
        boolean bl = true;
        byte[] byArray2 = null;
        try {
            try {
                byArray2 = CriptoUtil.decrypt14Mode(byArray, key);
                LOG.debug("Decripted with old Licenser 1.4 method");
            }
            catch (BadPaddingException badPaddingException) {
                bl = false;
            }
            catch (InvalidKeyException invalidKeyException) {
                bl = false;
            }
            if (!bl) {
                Key key2 = key;
                if (RSAPublicKey.class.isAssignableFrom(key.getClass())) {
                    RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                    RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                    KeyFactory keyFactory = KeyFactory.getInstance(CRIPTO_TRANSFORMATION);
                    key2 = keyFactory.generatePrivate(rSAPrivateKeySpec);
                }
                byArray2 = CriptoUtil.decrypt14Mode(byArray, key2);
            }
        }
        catch (Exception exception) {
            throw new LicenserFatalException(CANNOT_DECRYPT, exception);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("DECRYPTED: {}", (Object)Base64.encodeBytes(byArray2));
        }
        return byArray2;
    }

    private static byte[] decrypt14Mode(byte[] byArray, Key key) throws Exception {
        byte[] byArray2 = new byte[]{};
        for (int i = 0; i < byArray.length; i += 128) {
            int n = i + 128;
            if (n > byArray.length) {
                n = byArray.length;
            }
            byte[] byArray3 = ArrayUtils.subarray(byArray, i, n);
            Cipher cipher = Cipher.getInstance(CRIPTO_TRANSFORMATION);
            cipher.init(2, key);
            byArray2 = ArrayUtils.addAll(byArray2, cipher.doFinal(byArray3));
        }
        return byArray2;
    }

    protected static Object decryptObj(String string, Key key) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] byArray = Base64.decode(string);
            byte[] byArray2 = CriptoUtil.decrypt(byArray, key);
            byteArrayInputStream = new ByteArrayInputStream(byArray2);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            try {
                throw new LicenserFatalException(CANNOT_DECRYPT, exception);
            }
            catch (Throwable throwable) {
                CriptoUtil.close(byteArrayInputStream);
                throw throwable;
            }
        }
        CriptoUtil.close(byteArrayInputStream);
        return object;
    }

    private static synchronized void initKeyPairGenerator() {
        try {
            if (keyGen == null) {
                keyGen = KeyPairGenerator.getInstance(CRIPTO_TRANSFORMATION);
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                keyGen.initialize(1024, secureRandom);
            }
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot init key pair generator", exception);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            long l = System.currentTimeMillis();
            CriptoUtil.initKeyPairGenerator();
            KeyPair keyPair = keyGen.generateKeyPair();
            long l2 = System.currentTimeMillis();
            LOG.debug("Key pair generated in {} millis.", (Object)(l2 - l));
            if (LOG.isTraceEnabled()) {
                LOG.trace("\n------------  Public key  ------------\n" + CriptoUtil.publicKeyToStr(keyPair.getPublic()) + "\n------------  Private key ------------\n" + CriptoUtil.privateKeyToStr(keyPair.getPrivate()) + "\n-------------------------------------");
            }
            return keyPair;
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot generate key pair", exception);
        }
    }

    public static boolean checkKeyPair(Key key, Key key2, String string) {
        byte[] byArray = CHECK_MSG.getBytes();
        byte[] byArray2 = CriptoUtil.encrypt(byArray, key, string);
        byte[] byArray3 = CriptoUtil.decrypt(byArray2, key2);
        return byArray3 != null && Arrays.equals(byArray, byArray3);
    }

    public static KeyPair strToKeyPair(String string) {
        KeyPair keyPair;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] byArray = Base64.decode(string);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            keyPair = (KeyPair)objectInputStream.readObject();
        }
        catch (Exception exception) {
            try {
                throw new LicenserFatalException(CANNOT_DECRYPT, exception);
            }
            catch (Throwable throwable) {
                CriptoUtil.close(byteArrayInputStream);
                throw throwable;
            }
        }
        CriptoUtil.close(byteArrayInputStream);
        return keyPair;
    }

    public static String keyPairToStr(KeyPair keyPair) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(keyPair);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string = Base64.encodeBytes(byArray);
            return string;
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot serialize object", exception);
        }
        finally {
            CriptoUtil.close(byteArrayOutputStream);
        }
    }

    public static PublicKey strToPublicKey(String string) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        try {
            object = new String(Base64.decode(string), ENCODING).split(BREAK_STRING);
            bigInteger2 = new BigInteger(object[0]);
            bigInteger = new BigInteger(object[1]);
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot get public key from string: Incorrect format", exception);
        }
        try {
            object = new RSAPublicKeySpec(bigInteger2, bigInteger);
            KeyFactory keyFactory = KeyFactory.getInstance(CRIPTO_TRANSFORMATION);
            return keyFactory.generatePublic((KeySpec)object);
        }
        catch (Exception exception) {
            throw new LicenserFatalException(CANNOT_GET_PK, exception);
        }
    }

    public static String publicKeyToStr(PublicKey publicKey) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            stringBuilder.append(rSAPublicKey.getModulus().toString()).append(BREAK_STRING);
            stringBuilder.append(rSAPublicKey.getPublicExponent().toString());
            return Base64.encodeBytes(stringBuilder.toString().getBytes(ENCODING));
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot convert public key to string", exception);
        }
    }

    public static PrivateKey strToPrivateKey(String string) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        try {
            object = new String(Base64.decode(string), ENCODING).split(BREAK_STRING);
            bigInteger2 = new BigInteger(object[0]);
            bigInteger = new BigInteger(object[1]);
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot get private key from string: Incorrect format", exception);
        }
        try {
            object = new RSAPrivateKeySpec(bigInteger2, bigInteger);
            KeyFactory keyFactory = KeyFactory.getInstance(CRIPTO_TRANSFORMATION);
            return keyFactory.generatePrivate((KeySpec)object);
        }
        catch (Exception exception) {
            throw new LicenserFatalException(CANNOT_GET_PK, exception);
        }
    }

    public static String privateKeyToStr(PrivateKey privateKey) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            stringBuilder.append(rSAPrivateKey.getModulus().toString()).append(BREAK_STRING);
            stringBuilder.append(rSAPrivateKey.getPrivateExponent().toString());
            return Base64.encodeBytes(stringBuilder.toString().getBytes(ENCODING));
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot convert private key to string", exception);
        }
    }

    public static String downloadCertToStr(DownloadCert downloadCert, Key key, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CriptoUtil.publicKeyToStr(downloadCert.getKey())).append('\n');
        stringBuilder.append(CriptoUtil.encryptObj(downloadCert.getDownloadInfo(), key, string));
        return stringBuilder.toString();
    }

    public static String downloadCertToStr(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('\n');
        stringBuilder.append(string2);
        String string3 = stringBuilder.toString();
        if (CriptoUtil.strToDownloadCert(string3) == null) {
            throw new LicenserFatalException("Couldn't generate download cert string. Invalid public key or download info string.");
        }
        return stringBuilder.toString();
    }

    public static DownloadCert strToDownloadCert(String string) {
        String[] stringArray = string.split("\n");
        PublicKey publicKey = CriptoUtil.strToPublicKey(stringArray[0]);
        DownloadInfo downloadInfo = (DownloadInfo)CriptoUtil.decryptObj(stringArray[1], publicKey);
        return new DownloadCert(publicKey, downloadInfo);
    }

    public static String licenseCertToStr(LicenseCert licenseCert, PrivateKey privateKey, String string) {
        return CriptoUtil.encryptObj(licenseCert, privateKey, string);
    }

    public static Serializable strToLicenseCert(String string, PublicKey publicKey) {
        Object object = CriptoUtil.decryptObj(string, publicKey);
        LicenseCert licenseCert = null;
        if (object instanceof LicenseCertServerID) {
            licenseCert = (LicenseCertServerID)object;
        } else if (object instanceof LicenseCert) {
            licenseCert = (LicenseCert)object;
        }
        return licenseCert;
    }

    public static String downloadInfoToStr(DownloadInfo downloadInfo, PrivateKey privateKey, String string) {
        return CriptoUtil.encryptObj(downloadInfo, privateKey, string);
    }

    public static DownloadInfo strToDownloadInfo(String string, PublicKey publicKey) {
        return (DownloadInfo)CriptoUtil.decryptObj(string, publicKey);
    }

    protected static InputStream getDownloadCertInputStream(String string) {
        LOG.debug("Reading download cert from classpath resource: {}", (Object)string);
        InputStream inputStream2 = CriptoUtil.class.getResourceAsStream(string);
        if (inputStream2 == null) {
            throw new LicenserFatalException("cert resource doesn't exist");
        }
        return inputStream2;
    }

    public static DownloadCert readDownloadCertFromResource(String string) {
        return CriptoUtil.strToDownloadCert(CriptoUtil.readDownloadCertStrFromResource(string));
    }

    public static String readDownloadCertStrFromResource(String string) {
        InputStream inputStream2 = null;
        try {
            inputStream2 = CriptoUtil.getDownloadCertInputStream(string);
            String string2 = IOUtils.toString(inputStream2, ENCODING);
            return string2;
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot read download cert from resource: " + string, exception);
        }
        finally {
            CriptoUtil.close(inputStream2);
        }
    }

    public static void writeDownloadCert(OutputStream outputStream2, String string) {
        try {
            IOUtils.write(string, outputStream2, ENCODING);
        }
        catch (IOException iOException) {
            throw new LicenserFatalException("Cannot not write download cert to stream", iOException);
        }
    }

    public static String readDownloadInfoStrFromResource(String string) {
        InputStream inputStream2 = null;
        try {
            inputStream2 = CriptoUtil.getDownloadCertInputStream(string);
            String[] stringArray = IOUtils.toString(inputStream2, ENCODING).split("\n");
            String string2 = stringArray[1];
            return string2;
        }
        catch (Exception exception) {
            throw new LicenserFatalException("Cannot read download info from resource: " + string, exception);
        }
        finally {
            CriptoUtil.close(inputStream2);
        }
    }
}

