/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.licenser;

import com.bitegarden.licenser.checker.LicenseChecker;
import com.bitegarden.sonar.licenser.LicensedPlugin;
import com.bitegarden.sonar.licenser.LicensedPluginShared;
import com.bitegarden.sonar.plugins.common.ctx.PluginContext;
import org.sonar.api.config.Settings;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class LicenseWS
implements WebService {
    private static final Logger LOGGER = Loggers.get(LicenseWS.class);
    private static Settings settings;
    private static String serverID;
    private static String pluginKey;
    private static String pluginArtifactId;
    private static String pluginVersion;

    public LicenseWS(Settings settings) {
        LicenseWS.settings = settings;
        LOGGER.debug("licenseCertStr: " + this.getLicenseStr());
        pluginArtifactId = PluginContext.get().getPomArtifactId();
        LOGGER.debug("pluginArtifactId: " + pluginArtifactId);
        pluginVersion = PluginContext.get().getPluginVersion();
        LOGGER.debug("pluginVersion: " + pluginVersion);
        serverID = settings.getString("sonar.server_id");
        LOGGER.debug("serverID: " + serverID);
        pluginKey = PluginContext.get().getPluginKey();
        LOGGER.debug("pluginKey: " + pluginKey);
    }

    private String getLicenseStr() {
        return LicensedPlugin.getLicenseCertFromConfig(settings);
    }

    @Override
    public void define(WebService.Context context) {
        LOGGER.info("Creating service: api/" + pluginKey + "License");
        WebService.NewController newController = context.createController("api/" + pluginKey + "License");
        newController.setDescription("Licenser Web Service. Manage information of the license for " + pluginKey);
        newController.setSince("6.0");
        this.addGetUseRemainingDays(newController);
        this.addGetSupportRemainingDays(newController);
        this.addGetLicenseStatusAndWriteMsgIfNotValid(newController);
        this.addGetHtmlEvalWaterMark(newController);
        this.addGetDownloadKey(newController);
        this.addGetLicenseStatus(newController);
        this.addGetHtmlLicenseInfo(newController);
        this.addAllLicenseInfo(newController);
        newController.done();
        LOGGER.info("Service created: api/" + pluginKey + "License");
    }

    private void addAllLicenseInfo(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/allLicenseInfo");
        newController.createAction("allLicenseInfo").setDescription("Return all information about the license key.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getUseRemainingDays", LicenseChecker.getUseRemainingDays(LicenseWS.this.getLicenseStr())).prop("getSupportRemainingDays", LicenseChecker.getSupportRemainingDays(LicenseWS.this.getLicenseStr())).prop("getLicenseStatusAndWriteMsgIfNotValid", LicensedPlugin.getLicenseStatusAndWriteMsgIfNotValid(LicenseWS.this.getLicenseStr(), serverID).toString()).prop("getHtmlEvalWaterMark", LicensedPlugin.getHtmlEvalWaterMark(LicenseWS.this.getLicenseStr())).prop("getDownloadKey", LicenseChecker.getDownloadKey()).prop("getLicenseStatus", LicenseChecker.getLicenseStatus(LicenseWS.this.getLicenseStr()).toString()).prop("getHtmlLicenseInfo", LicenseWS.this.getHtmlLicenseInfo()).endObject().close();
            }
        });
    }

    private void addGetUseRemainingDays(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/getUseRemainingDays");
        newController.createAction("getUseRemainingDays").setDescription("Return the maximum number of days remaining until expiration of the evaluation period of use.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getUseRemainingDays", LicenseChecker.getUseRemainingDays(LicenseWS.this.getLicenseStr())).endObject().close();
            }
        });
    }

    private void addGetSupportRemainingDays(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/getSupportRemainingDays");
        newController.createAction("getSupportRemainingDays").setDescription("Return the maximum number of days remaining until expiration of the support period.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getSupportRemainingDays", LicenseChecker.getSupportRemainingDays(LicenseWS.this.getLicenseStr())).endObject().close();
            }
        });
    }

    private void addGetLicenseStatusAndWriteMsgIfNotValid(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/getLicenseStatusAndWriteMsgIfNotValid");
        newController.createAction("getLicenseStatusAndWriteMsgIfNotValid").setDescription("Get license status checking if license is valid and writting an advice in the log if not.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getLicenseStatusAndWriteMsgIfNotValid", LicensedPlugin.getLicenseStatusAndWriteMsgIfNotValid(LicenseWS.this.getLicenseStr(), serverID).toString()).endObject().close();
            }
        });
    }

    private void addGetHtmlEvalWaterMark(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/getHtmlEvalWaterMark");
        newController.createAction("getHtmlEvalWaterMark").setDescription("Gets the html to draw an html watermark into your widget. You can append this html to your widget in order to show this water mark.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getHtmlEvalWaterMark", LicensedPlugin.getHtmlEvalWaterMark(LicenseWS.this.getLicenseStr())).endObject().close();
            }
        });
    }

    private void addGetDownloadKey(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/getDownloadKey");
        newController.createAction("getDownloadKey").setDescription("Returns the download key that identifies the download. This value must be indicated when ordering a new license to keep track it.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getDownloadKey", LicenseChecker.getDownloadKey()).endObject().close();
            }
        });
    }

    private void addGetLicenseStatus(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/getLicenseStatus");
        newController.createAction("getLicenseStatus").setDescription("Gets the license status collating the license certificate indicated the download information stored in the artifact.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getLicenseStatus", LicenseChecker.getLicenseStatus(LicenseWS.this.getLicenseStr()).toString()).endObject().close();
            }
        });
    }

    private void addGetHtmlLicenseInfo(WebService.NewController newController) {
        LOGGER.debug("Creating action /api/" + pluginKey + "License/getHtmlLicenseInfo");
        newController.createAction("getHtmlLicenseInfo").setDescription("Gets the license status, the support remaining days and a link to download a new license or buy the plugin.").setSince("6.0").setInternal(true).setHandler(new RequestHandler(){

            @Override
            public void handle(Request request, Response response) {
                response.newJsonWriter().beginObject().prop("getHtmlLicenseInfo", LicenseWS.this.getHtmlLicenseInfo()).endObject().close();
            }
        });
    }

    private String getHtmlLicenseInfo() {
        String string;
        String string2;
        String string3 = LicensedPlugin.getLicenseStatusAndWriteMsgIfNotValid(this.getLicenseStr(), serverID).toString().replace("_", " ");
        String string4 = "";
        String string5 = "<a href=\"http://www.excentia.es/register/license_request_en.html?productKey=" + pluginArtifactId + "&productVersion=" + pluginVersion + "\" target=\"_blank\">";
        if (LicensedPluginShared.isValidStatus(string3)) {
            long l = LicenseChecker.getUseRemainingDays(this.getLicenseStr());
            long l2 = LicenseChecker.getSupportRemainingDays(this.getLicenseStr());
            String string6 = string2 = string3 == "EVALUATION" ? "class=\"yellowHighlight\"" : "style=\"color:green\"";
            if (l == l2 && l >= 0L) {
                string = "You will be able to use the plugin and get product support for " + l + " days. ";
            } else {
                string = l >= 0L ? "You will be able to use the plugin for " + l + " days" : "You will be able to use the plugin with no time limit";
                string = string + (l >= 0L && l2 > 0L ? " and " : " but ");
                string = string + (l2 > 0L ? " get product support for " + l2 + " days. " : " product support is not provided or has expired. ");
                string4 = "Click here to renew the license";
            }
        } else {
            string2 = "style=\"color:#880000\"";
            string = "You need a valid license certificate to use the plugin. ";
            string4 = "Click here to request one";
        }
        String string7 = "<span " + string2 + ">" + string3 + "</span>. " + string + string5 + string4 + "</a>";
        return string7;
    }
}

