/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.common.ctx;

import com.bitegarden.sonar.plugins.common.ctx.PluginManifestInfo;
import com.bitegarden.sonar.plugins.common.exception.NoPluginManifestException;
import com.bitegarden.sonar.plugins.common.exception.PluginFatalException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class PluginContext {
    private static final String PLUGIN_TERMS_CONDITIONS_URL = "Plugin-TermsConditionsUrl";
    private static final String PLUGIN_HOMEPAGE = "Plugin-Homepage";
    private static final String PLUGIN_LICENSE = "Plugin-License";
    private static final String PLUGIN_DESCRIPTION = "Plugin-Description";
    private static final String PLUGIN_BUILD_DATE = "Plugin-BuildDate";
    private static final String PLUGIN_VERSION = "Plugin-Version";
    private static final String PLUGIN_NAME = "Plugin-Name";
    private static final String PLUGIN_ORGANIZATION = "Plugin-Organization";
    private static final String PLUGIN_ORGANIZATION_URL = "Plugin-OrganizationUrl";
    private static final String PLUGIN_CLASS = "Plugin-Class";
    private static final String PLUGIN_KEY = "Plugin-Key";
    private static final String POM_VERSION = "Version";
    private static final String POM_GROUP_ID = "GroupId";
    private static final String POM_ARTIFACT_ID = "ArtifactId";
    private static final Logger LOGGER = Loggers.get(PluginContext.class);
    private static PluginContext ctx;
    private PluginManifestInfo manifestInfo = null;
    Map<String, Object> pluginProperties = new HashMap<String, Object>();

    private PluginContext() {
    }

    public static synchronized PluginContext get() {
        if (ctx == null) {
            ctx = new PluginContext();
        }
        return ctx;
    }

    private String getManifestOrPropertyValue(Attributes attributes, String string) {
        String string2 = attributes == null ? (String)this.pluginProperties.get(string) : attributes.getValue(string);
        LOGGER.debug("{} = {}", (Object)string, (Object)string2);
        return string2;
    }

    private PluginManifestInfo getManifestOrPropertiesInfo(Attributes attributes) {
        LOGGER.debug("Loading manifest properties ...");
        PluginManifestInfo pluginManifestInfo = new PluginManifestInfo();
        pluginManifestInfo.setPluginClass(this.getManifestOrPropertyValue(attributes, PLUGIN_CLASS));
        pluginManifestInfo.setOrganizationUrl(this.getManifestOrPropertyValue(attributes, PLUGIN_ORGANIZATION_URL));
        pluginManifestInfo.setPluginOrganization(this.getManifestOrPropertyValue(attributes, PLUGIN_ORGANIZATION));
        pluginManifestInfo.setPluginName(this.getManifestOrPropertyValue(attributes, PLUGIN_NAME));
        pluginManifestInfo.setPluginVersion(this.getManifestOrPropertyValue(attributes, PLUGIN_VERSION));
        Date date = null;
        String string = this.getManifestOrPropertyValue(attributes, PLUGIN_BUILD_DATE);
        if (StringUtils.isNotBlank(string)) {
            try {
                String string2 = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern();
                date = DateUtils.parseDate(string, new String[]{string2});
            }
            catch (ParseException parseException) {
                LOGGER.warn("Couldn't parse plugin build date: " + string, parseException);
            }
        }
        pluginManifestInfo.setPluginBuildDate(date);
        pluginManifestInfo.setPluginDescription(this.getManifestOrPropertyValue(attributes, PLUGIN_DESCRIPTION));
        pluginManifestInfo.setPluginKey(this.getManifestOrPropertyValue(attributes, PLUGIN_KEY));
        pluginManifestInfo.setPluginLicense(this.getManifestOrPropertyValue(attributes, PLUGIN_LICENSE));
        pluginManifestInfo.setPluginHomepage(this.getManifestOrPropertyValue(attributes, PLUGIN_HOMEPAGE));
        pluginManifestInfo.setPluginTermsConditionsUrl(this.getManifestOrPropertyValue(attributes, PLUGIN_TERMS_CONDITIONS_URL));
        pluginManifestInfo.setPomVersion(this.getManifestOrPropertyValue(attributes, POM_VERSION));
        pluginManifestInfo.setPomGroupId(this.getManifestOrPropertyValue(attributes, POM_GROUP_ID));
        pluginManifestInfo.setPomArtifactId(this.getManifestOrPropertyValue(attributes, POM_ARTIFACT_ID));
        return pluginManifestInfo;
    }

    public synchronized PluginManifestInfo getPluginManifestInfo() {
        if (this.manifestInfo == null) {
            InputStream inputStream2;
            block7: {
                if (StringUtils.isNotBlank((String)this.getProperty(PLUGIN_KEY))) {
                    LOGGER.warn("Use this feature only for testing! \"Plugin-Key\" property was defined so plugin manifest info will be gotten from properties instead of manifest file.");
                    this.manifestInfo = this.getManifestOrPropertiesInfo(null);
                    return this.manifestInfo;
                }
                inputStream2 = null;
                try {
                    Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
                    while (enumeration.hasMoreElements()) {
                        inputStream2 = enumeration.nextElement().openStream();
                        Manifest manifest = new Manifest(inputStream2);
                        Attributes attributes = manifest.getMainAttributes();
                        if (attributes == null || attributes.getValue(PLUGIN_KEY) == null) continue;
                        this.manifestInfo = this.getManifestOrPropertiesInfo(attributes);
                        break;
                    }
                    if (this.manifestInfo != null) break block7;
                    throw new NoPluginManifestException();
                }
                catch (IOException iOException) {
                    try {
                        throw new PluginFatalException("Error searching plugin manifest", iOException);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream2);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly(inputStream2);
        }
        return this.manifestInfo;
    }

    public String getPluginKey() {
        PluginManifestInfo pluginManifestInfo = this.getPluginManifestInfo();
        if (pluginManifestInfo == null) {
            throw new PluginFatalException("Couldn't get plugin key");
        }
        return pluginManifestInfo.getPluginKey();
    }

    public String getPluginVersion() {
        PluginManifestInfo pluginManifestInfo = this.getPluginManifestInfo();
        if (pluginManifestInfo == null) {
            throw new PluginFatalException("Couldn't get plugin version");
        }
        return pluginManifestInfo.getPluginVersion();
    }

    public String getPluginHomepageUrl() {
        PluginManifestInfo pluginManifestInfo = this.getPluginManifestInfo();
        if (pluginManifestInfo == null) {
            throw new PluginFatalException("Couldn't get plugin homepage url");
        }
        return pluginManifestInfo.getPluginHomepage();
    }

    public String getPomGroupId() {
        PluginManifestInfo pluginManifestInfo = this.getPluginManifestInfo();
        if (pluginManifestInfo == null) {
            throw new PluginFatalException("Couldn't get pom groupId");
        }
        return pluginManifestInfo.getPomGroupId();
    }

    public String getPomArtifactId() {
        PluginManifestInfo pluginManifestInfo = this.getPluginManifestInfo();
        if (pluginManifestInfo == null) {
            throw new PluginFatalException("Couldn't get pom artifactId");
        }
        return pluginManifestInfo.getPomArtifactId();
    }

    public void setProperty(String string, Object object) {
        LOGGER.debug("set property {} = {}", (Object)string, object);
        this.pluginProperties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.pluginProperties.get(string);
    }

    public void clearProperties() {
        this.pluginProperties.clear();
    }
}

