/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.util;

import com.bitegarden.sonar.plugins.report.util.ChartSeries;
import es.sonarqube.utils.FormatUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class ChartUtils {
    public static final Color LINE_COLOR_BLUE = new Color(100, 171, 215);
    public static final Color FILL_COLOR_BLUE = new Color(201, 226, 241);
    public static final Color LINE_COLOR_GREEN = new Color(100, 184, 88);
    public static final Color FILL_COLOR_GREEN = new Color(195, 227, 200);
    public static final Color LINE_COLOR_RED = new Color(207, 104, 106);
    public static final Color FILL_COLOR_RED = new Color(243, 217, 218);

    private ChartUtils() {
    }

    public static BufferedImage createAreaChart(int n, int n2, List<ChartSeries> list, Font font, Font font2, String string, Locale locale) {
        XYChart xYChart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(n)).height(n2)).build();
        ((XYStyler)xYChart.getStyler()).setLocale(locale);
        ((XYStyler)xYChart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        ((XYStyler)xYChart.getStyler()).setPlotBorderColor(ChartColor.BLACK.getColor());
        ((XYStyler)xYChart.getStyler()).setPlotBackgroundColor(ChartColor.WHITE.getColor());
        ((XYStyler)xYChart.getStyler()).setChartBackgroundColor(ChartColor.WHITE.getColor());
        ((XYStyler)xYChart.getStyler()).setYAxisMin(0.0);
        ((XYStyler)xYChart.getStyler()).setYAxisLabelAlignment(AxesChartStyler.TextAlignment.Right);
        ((XYStyler)xYChart.getStyler()).setChartTitleFont(font2.deriveFont(0).deriveFont(40.0f));
        ((XYStyler)xYChart.getStyler()).setChartTitlePadding(40);
        xYChart.setTitle(string);
        NumberFormat numberFormat = FormatUtils.getNumber(locale);
        numberFormat.setMaximumFractionDigits(0);
        if (numberFormat instanceof DecimalFormat) {
            numberFormat.setMaximumFractionDigits(2);
            ((XYStyler)xYChart.getStyler()).setYAxisDecimalPattern(((DecimalFormat)numberFormat).toPattern());
        }
        ((XYStyler)xYChart.getStyler()).setAxisTickLabelsFont(font.deriveFont(0).deriveFont(18.0f));
        ((XYStyler)xYChart.getStyler()).setAxisTickLabelsColor(ChartColor.BLACK.getColor());
        ((XYStyler)xYChart.getStyler()).setDatePattern("YYYY-MM-dd");
        ((XYStyler)xYChart.getStyler()).setLegendVisible(false);
        for (ChartSeries chartSeries : list) {
            XYSeries xYSeries = xYChart.addSeries(chartSeries.getMetricKey(), chartSeries.getDates(), chartSeries.getValues());
            xYSeries.setMarker(SeriesMarkers.NONE);
            xYSeries.setLineColor(chartSeries.getLineColor());
            xYSeries.setLineWidth(8.0f);
            xYSeries.setSmooth(true);
            xYSeries.setFillColor(chartSeries.getFillColor());
        }
        return BitmapEncoder.getBufferedImage(xYChart);
    }
}

