/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.util;

import es.sonarqube.api.SonarQubeProject;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.model.SonarQubeQualifier;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Components;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.components.ShowRequest;
import org.sonarqube.ws.client.projectbranches.ListRequest;

public final class ReportUtils {
    private static final String URL_COULD_NOT_BE_OPENED = "URL %s could not be opened.";
    private static final String MALFORMED_TEMPLATE_URL = "Template file url %s is malformed. Using default...";
    private static final String ILLEGAL_ARGUMENT = "The path %s is incorrect. Using default...";
    private static final String DEFAULT_TEMPLATE_PATH_IN_JAR = "/static/templates/default-template.odt";
    private static final String SONARCLOUD_URL = "https://sonarcloud.io";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtils.class);

    private ReportUtils() {
    }

    public static InputStream getTemplateInputStream(String string) {
        InputStream inputStream2;
        if (string == null) {
            inputStream2 = ReportUtils.getDefaultTemplate();
        } else {
            try {
                inputStream2 = new URL(string).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.warn(String.format(MALFORMED_TEMPLATE_URL, string));
                inputStream2 = ReportUtils.getDefaultTemplate();
            }
            catch (IOException iOException) {
                LOGGER.warn(String.format(URL_COULD_NOT_BE_OPENED, string), iOException);
                inputStream2 = ReportUtils.getDefaultTemplate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warn(String.format(ILLEGAL_ARGUMENT, string), illegalArgumentException);
                inputStream2 = ReportUtils.getDefaultTemplate();
            }
        }
        return inputStream2;
    }

    public static InputStream getDefaultTemplate() {
        return ReportUtils.class.getResourceAsStream(DEFAULT_TEMPLATE_PATH_IN_JAR);
    }

    public static String getVersion() {
        try {
            Properties properties = new Properties();
            properties.load(ReportUtils.class.getResourceAsStream("/META-INF/maven/com.bitegarden.sonar.plugins/bitegarden-sonarcloud-report/pom.properties"));
            return properties.getProperty("version", "unknown");
        }
        catch (IOException iOException) {
            LOGGER.warn("Unable to get version: {}", (Object)iOException.getMessage(), (Object)iOException);
            return "unknown";
        }
    }

    public static String getExpirationDateFromRemainingDays(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(5, (int)l);
        int n = gregorianCalendar.get(5);
        String string = gregorianCalendar.getDisplayName(2, 2, Locale.ENGLISH);
        int n2 = gregorianCalendar.get(1);
        return string + ", " + n + ", " + n2;
    }

    public static SonarQubeProject getBasicProjectInformation(WsClient wsClient, String string) throws SonarQubeException {
        if (string == null || string.isEmpty()) {
            LOGGER.warn("We cannot getting basic info from null or empty project key");
            return new SonarQubeProject();
        }
        try {
            LOGGER.debug("Getting basic project information from resource id -> {}", (Object)string);
            ShowRequest showRequest = new ShowRequest();
            showRequest.setComponent(string);
            Components.ShowWsResponse showWsResponse = wsClient.components().show(showRequest);
            if (showWsResponse != null) {
                String string2;
                Components.Component component = showWsResponse.getComponent();
                String string3 = string2 = component.getKey().isEmpty() ? string : component.getKey();
                if (string2.equals(string)) {
                    return ReportUtils.generateSonarQubeProjectWithBasicInfo(string2, component);
                }
                LOGGER.warn("Project key ({}) and component key ({}) are not the same value. Returning empty project...", (Object)string, (Object)string2);
            }
        }
        catch (HttpException httpException) {
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            throw new SonarQubeException(String.format("Error getting basic project info (%s) info: %s", string, exception.getMessage()), exception);
        }
        return new SonarQubeProject();
    }

    private static SonarQubeProject generateSonarQubeProjectWithBasicInfo(String string, Components.Component component) {
        SonarQubeProject sonarQubeProject = new SonarQubeProject();
        String string2 = component.getAnalysisDate().isEmpty() ? "" : component.getAnalysisDate().substring(0, 10);
        String string3 = component.getName().isEmpty() ? string : component.getName();
        sonarQubeProject.setKey(string);
        sonarQubeProject.setName(string3);
        sonarQubeProject.setLastAnalysis(string2);
        sonarQubeProject.setVersion(component.getVersion());
        sonarQubeProject.setUuid(component.getKey());
        sonarQubeProject.setSonarQubeQualifier(SonarQubeQualifier.PROJECT);
        return sonarQubeProject;
    }

    public static boolean branchExists(WsClient wsClient, String string, String string2) {
        ListRequest listRequest = new ListRequest();
        listRequest.setProject(string);
        ProjectBranches.ListWsResponse listWsResponse = wsClient.projectBranches().list(listRequest);
        if (listWsResponse != null && !listWsResponse.getBranchesList().isEmpty()) {
            for (ProjectBranches.Branch branch : listWsResponse.getBranchesList()) {
                if (!branch.getName().equals(string2)) continue;
                return true;
            }
        }
        LOGGER.warn("Provided branch ({}) not exists, we use main project branch...", (Object)string2);
        return false;
    }

    public static WsClient getWsClient(String string) {
        return WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(SONARCLOUD_URL).token(string).build());
    }
}

