/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.xlsx;

import com.bitegarden.sonar.plugins.report.manager.AppManager;
import com.bitegarden.sonar.plugins.report.manager.AppManagerImpl;
import com.bitegarden.sonar.plugins.report.model.BitegardenReportException;
import com.bitegarden.sonar.plugins.report.util.ParamUtils;
import com.bitegarden.sonar.plugins.report.util.PdfUtils;
import com.bitegarden.sonar.plugins.report.util.ReportUtils;
import com.bitegarden.sonar.plugins.report.xlsx.XlsxReportField;
import com.bitegarden.sonar.plugins.report.xlsx.XlsxReportTab;
import com.bitegarden.sonar.plugins.report.xlsx.XlsxUtils;
import com.google.protobuf.ProtocolStringList;
import es.sonarqube.api.SonarQubeHotspotsBreakdown;
import es.sonarqube.api.SonarQubeHotspotsPerCategory;
import es.sonarqube.api.SonarQubeIssuesBreakdown;
import es.sonarqube.api.SonarQubeIssuesPerRule;
import es.sonarqube.api.SonarQubeProject;
import es.sonarqube.managers.SonarQubeHotspotManager;
import es.sonarqube.managers.SonarQubeIssueManager;
import es.sonarqube.managers.SonarQubeMeasureManager;
import es.sonarqube.managers.SonarQubeProjectManager;
import es.sonarqube.managers.SonarQubeRuleManager;
import es.sonarqube.utils.FormatUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Hotspots;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.Qualitygates;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.hotspots.ShowRequest;

public class XlsxReport {
    private static final Logger LOG = LoggerFactory.getLogger(XlsxReport.class);
    private static final String DEFAULT_XLSX_TEMPLATE = "/static/templates/excel-report_en.xlsx";
    private static final String DEFAULT_TRIAL_XLSX_TEMPLATE = "/static/templates/trial-excel-report_en.xlsx";
    private static final String SPANISH_XLSX_TEMPLATE = "/static/templates/excel-report_es.xlsx";
    private static final String SPANISH_TRIAL_XLSX_TEMPLATE = "/static/templates/trial-excel-report_es.xlsx";
    private static final String QUALITY_GATE_PASSED_TEXT = "PASSED";
    private static final String QUALITY_GATE_FAILED_TEXT = "FAILED";
    private static final int DEFAULT_EVALUATION_ROWS_LIMIT = 5;
    public static final String XLSX_EXTENSION = ".xlsx";

    private XlsxReport() {
    }

    public static void generateXlsx(String string, String string2, String string3, Locale locale, String string4, boolean bl) {
        AppManager appManager = AppManagerImpl.getInstance();
        try (Workbook workbook = XlsxReport.getWorkbook(locale, bl);){
            Object object;
            String string5 = string.replace(':', '-') + XLSX_EXTENSION;
            if (string4 != null && !string4.isEmpty()) {
                object = string4.endsWith(XLSX_EXTENSION) ? "" : XLSX_EXTENSION;
                string5 = string4 + (String)object;
            }
            object = Instant.now();
            WsClient wsClient = ReportUtils.getWsClient(string3);
            SonarQubeMeasureManager sonarQubeMeasureManager = new SonarQubeMeasureManager(wsClient, locale);
            SonarQubeIssueManager sonarQubeIssueManager = new SonarQubeIssueManager(wsClient, locale);
            SonarQubeProjectManager sonarQubeProjectManager = new SonarQubeProjectManager(wsClient, locale);
            SonarQubeProject sonarQubeProject = ReportUtils.getBasicProjectInformation(wsClient, string);
            List<ProjectBranches.Branch> list = sonarQubeProjectManager.getProjectBranches(string);
            sonarQubeProject.setSonarQubeBranchList(list);
            sonarQubeProject.setMainBranch(sonarQubeProjectManager.getProjectMainBranch(list));
            if (string2 == null || string2.isEmpty() || !ReportUtils.branchExists(wsClient, string, string2)) {
                string2 = sonarQubeProject.getMainBranch().getName();
            }
            sonarQubeProject.setLastAnalysis(sonarQubeProjectManager.getProjectAnalysisDate(string, string2));
            sonarQubeProject.setQualityGate(sonarQubeProjectManager.getProjectStatusResponse(string, string2).getProjectStatus());
            Map<String, String> map = sonarQubeMeasureManager.getMeasuresMap(string, string2, PdfUtils.METRIC_KEYS);
            SonarQubeIssuesBreakdown sonarQubeIssuesBreakdown = sonarQubeIssueManager.getIssueBreakdown(string, string2, true);
            Instant instant = Instant.now();
            XlsxReport.generateExecutiveSummarySheet(workbook, string2, map, sonarQubeIssuesBreakdown, sonarQubeProject, locale);
            Instant instant2 = Instant.now();
            long l = Duration.between(instant, instant2).toMillis() / 1000L;
            LOG.info("Executive Summary Sheet generated for {} ( Elapsed time: {} s )", (Object)string, (Object)l);
            instant = Instant.now();
            XlsxReport.generateIssuesByRuleSheet(workbook, sonarQubeIssuesBreakdown.getSonarQubeIssuesPerRuleBySeverity(), wsClient, bl);
            instant2 = Instant.now();
            l = Duration.between(instant, instant2).toMillis() / 1000L;
            LOG.info("Issues by Rule Sheet generated for {} ( Elapsed time: {} s )", (Object)string, (Object)l);
            instant = Instant.now();
            XlsxReport.generateIssuesBreakdownSheet(string, workbook, sonarQubeIssuesBreakdown, bl);
            instant2 = Instant.now();
            l = Duration.between(instant, instant2).toMillis() / 1000L;
            LOG.info("Issues Breakdown Sheet generated for {} ( Elapsed time: {} s )", (Object)string, (Object)l);
            instant = Instant.now();
            XlsxReport.generateSecurityHotspotsBreakdownSheet(string, string2, workbook, wsClient, bl);
            instant2 = Instant.now();
            l = Duration.between(instant, instant2).toMillis() / 1000L;
            LOG.info("Security Hotspots Breakdown Sheet generated for {} ( Elapsed time: {} s )", (Object)string, (Object)l);
            try (Object object2 = new FileOutputStream(string5);){
                Instant instant3 = Instant.now();
                LOG.info("Saving Excel Report file...");
                workbook.write((OutputStream)object2);
                Instant instant4 = Instant.now();
                long l2 = Duration.between(instant3, instant4).toMillis() / 1000L;
                LOG.info("Excel Report file saved. ( Elapsed time: {} s )", (Object)l2);
            }
            object2 = Instant.now();
            long l3 = Duration.between((Temporal)object, (Temporal)object2).toMillis() / 1000L;
            LOG.info("Excel Report generated for {} ( Elapsed time: {} s )", (Object)string, (Object)l3);
        }
        catch (BitegardenReportException bitegardenReportException) {
            LOG.error("Error generating {} sheet for Excel Report, reason: {}", (Object)bitegardenReportException.getStep(), (Object)bitegardenReportException.getMessage());
            LOG.debug("Error generating {} sheet for Excel Report", (Object)bitegardenReportException.getStep(), (Object)bitegardenReportException);
            appManager.exit(-1);
        }
        catch (Exception exception) {
            LOG.error("Error generating Excel report for {}, reason: {}", (Object)string, (Object)exception.getMessage());
            LOG.debug("Error generating Excel report for {}", (Object)string, (Object)exception);
            appManager.exit(-1);
        }
    }

    private static void generateExecutiveSummarySheet(Workbook workbook, String string, Map<String, String> map, SonarQubeIssuesBreakdown sonarQubeIssuesBreakdown, SonarQubeProject sonarQubeProject, Locale locale) throws BitegardenReportException {
        try {
            String string2 = "-period1";
            String string3 = "-";
            String string4 = "%";
            String string5 = sonarQubeProject.getQualityGate().getStatus() == Qualitygates.ProjectStatusResponse.Status.OK ? QUALITY_GATE_PASSED_TEXT : QUALITY_GATE_FAILED_TEXT;
            Sheet sheet = XlsxUtils.getSheet(workbook, XlsxReportTab.SUMMARY);
            XlsxUtils.getCell(sheet, XlsxReportField.PROJECT_NAME).setCellValue(sonarQubeProject.getName());
            XlsxUtils.getCell(sheet, XlsxReportField.BRANCH_NAME).setCellValue(string);
            XlsxUtils.getCell(sheet, XlsxReportField.SIZE_RATING).setCellValue(map.get("size_rating"));
            XlsxUtils.getCell(sheet, XlsxReportField.NCLOC).setCellValue(map.get("ncloc"));
            XlsxUtils.getCell(sheet, XlsxReportField.PROJECT_VERSION).setCellValue(ParamUtils.getProjectVersion(sonarQubeProject, true));
            XlsxUtils.getCell(sheet, XlsxReportField.ANALYSIS_DATE).setCellValue(sonarQubeProject.getLastAnalysis());
            XlsxUtils.getCell(sheet, XlsxReportField.QUALITY_GATE).setCellValue(string5);
            XlsxUtils.getCell(sheet, XlsxReportField.RELIABILITY_RATING).setCellValue(map.get("reliability_rating"));
            XlsxUtils.getCell(sheet, XlsxReportField.SECURITY_RATING).setCellValue(map.get("security_rating"));
            XlsxUtils.getCell(sheet, XlsxReportField.MAINTAINABILITY_RATING).setCellValue(map.get("sqale_rating"));
            XlsxUtils.getCell(sheet, XlsxReportField.BUGS).setCellValue(map.get("bugs"));
            XlsxUtils.getCell(sheet, XlsxReportField.VULNERABILITIES).setCellValue(map.get("vulnerabilities"));
            XlsxUtils.getCell(sheet, XlsxReportField.CODE_SMELLS).setCellValue(map.get("code_smells"));
            XlsxUtils.getCell(sheet, XlsxReportField.SECURITY_HOTSPOTS).setCellValue(map.get("security_hotspots"));
            XlsxUtils.getCell(sheet, XlsxReportField.DEBT_RATIO).setCellValue(map.get("sqale_debt_ratio") + string4);
            XlsxUtils.getCell(sheet, XlsxReportField.RELIABILITY_NEW_CODE).setCellValue(map.getOrDefault("new_reliability_rating" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.SECURITY_NEW_CODE).setCellValue(map.getOrDefault("new_security_rating" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.MAINTAINABILITY_NEW_CODE).setCellValue(map.getOrDefault("new_maintainability_rating" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.BUGS_NEW_CODE).setCellValue(map.getOrDefault("new_bugs" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.VULNERABILITIES_NEW_CODE).setCellValue(map.getOrDefault("new_vulnerabilities" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.CODE_SMELLS_NEW_CODE).setCellValue(map.getOrDefault("new_code_smells" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.SECURITY_HOTSPOTS_NEW_CODE).setCellValue(map.getOrDefault("new_security_hotspots" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.DEBT_RATIO_NEW_CODE).setCellValue(map.getOrDefault("new_sqale_debt_ratio" + string2, string3));
            int n = sonarQubeIssuesBreakdown.getTotalBlockerBugsIssues().intValue();
            int n2 = sonarQubeIssuesBreakdown.getTotalBlockerVulnerabilitiesIssues().intValue();
            int n3 = sonarQubeIssuesBreakdown.getTotalBlockerCodeSmellsIssues().intValue();
            int n4 = sonarQubeIssuesBreakdown.getTotalCriticalBugsIssues().intValue();
            int n5 = sonarQubeIssuesBreakdown.getTotalCriticalVulnerabilitiesIssues().intValue();
            int n6 = sonarQubeIssuesBreakdown.getTotalCriticalCodeSmellsIssues().intValue();
            int n7 = sonarQubeIssuesBreakdown.getTotalMajorBugsIssues().intValue();
            int n8 = sonarQubeIssuesBreakdown.getTotalMajorVulnerabilitiesIssues().intValue();
            int n9 = sonarQubeIssuesBreakdown.getTotalMajorCodeSmellsIssues().intValue();
            int n10 = sonarQubeIssuesBreakdown.getTotalMinorBugsIssues().intValue();
            int n11 = sonarQubeIssuesBreakdown.getTotalMinorVulnerabilitiesIssues().intValue();
            int n12 = sonarQubeIssuesBreakdown.getTotalMinorCodeSmellsIssues().intValue();
            int n13 = sonarQubeIssuesBreakdown.getTotalInfoBugsIssues().intValue();
            int n14 = sonarQubeIssuesBreakdown.getTotalInfoVulnerabilitiesIssues().intValue();
            int n15 = sonarQubeIssuesBreakdown.getTotalInfoCodeSmellsIssues().intValue();
            XlsxUtils.getCell(sheet, XlsxReportField.BLOCKER_BUGS).setCellValue(FormatUtils.getNumber(locale).format(n));
            XlsxUtils.getCell(sheet, XlsxReportField.BLOCKER_VULNERABILITIES).setCellValue(FormatUtils.getNumber(locale).format(n2));
            XlsxUtils.getCell(sheet, XlsxReportField.BLOCKER_CODE_SMELLS).setCellValue(FormatUtils.getNumber(locale).format(n3));
            XlsxUtils.getCell(sheet, XlsxReportField.CRITICAL_BUGS).setCellValue(FormatUtils.getNumber(locale).format(n4));
            XlsxUtils.getCell(sheet, XlsxReportField.CRITICAL_VULNERABILITIES).setCellValue(FormatUtils.getNumber(locale).format(n5));
            XlsxUtils.getCell(sheet, XlsxReportField.CRITICAL_CODE_SMELLS).setCellValue(FormatUtils.getNumber(locale).format(n6));
            XlsxUtils.getCell(sheet, XlsxReportField.MAJOR_BUGS).setCellValue(FormatUtils.getNumber(locale).format(n7));
            XlsxUtils.getCell(sheet, XlsxReportField.MAJOR_VULNERABILITIES).setCellValue(FormatUtils.getNumber(locale).format(n8));
            XlsxUtils.getCell(sheet, XlsxReportField.MAJOR_CODE_SMELLS).setCellValue(FormatUtils.getNumber(locale).format(n9));
            XlsxUtils.getCell(sheet, XlsxReportField.MINOR_BUGS).setCellValue(FormatUtils.getNumber(locale).format(n10));
            XlsxUtils.getCell(sheet, XlsxReportField.MINOR_VULNERABILITIES).setCellValue(FormatUtils.getNumber(locale).format(n11));
            XlsxUtils.getCell(sheet, XlsxReportField.MINOR_CODE_SMELLS).setCellValue(FormatUtils.getNumber(locale).format(n12));
            XlsxUtils.getCell(sheet, XlsxReportField.INFO_BUGS).setCellValue(FormatUtils.getNumber(locale).format(n13));
            XlsxUtils.getCell(sheet, XlsxReportField.INFO_VULNERABILITIES).setCellValue(FormatUtils.getNumber(locale).format(n14));
            XlsxUtils.getCell(sheet, XlsxReportField.INFO_CODE_SMELLS).setCellValue(FormatUtils.getNumber(locale).format(n15));
            XlsxUtils.getCell(sheet, XlsxReportField.COVERAGE).setCellValue(map.getOrDefault("coverage", string3) + string4);
            XlsxUtils.getCell(sheet, XlsxReportField.DUPLICATIONS).setCellValue(map.getOrDefault("duplicated_lines_density", "-") + string4);
            XlsxUtils.getCell(sheet, XlsxReportField.DUPLICATED_BLOCKS).setCellValue(map.getOrDefault("duplicated_blocks", string3));
            XlsxUtils.getCell(sheet, XlsxReportField.UNIT_TESTS).setCellValue(map.getOrDefault("tests", string3));
            XlsxUtils.getCell(sheet, XlsxReportField.COVERAGE_NEW_CODE).setCellValue(map.getOrDefault("new_coverage" + string2, string3));
            XlsxUtils.getCell(sheet, XlsxReportField.DUPLICATIONS_NEW_CODE).setCellValue(map.getOrDefault("new_duplicated_lines_density" + string2, string3));
        }
        catch (Exception exception) {
            throw new BitegardenReportException(exception, "Executive Summary");
        }
    }

    private static void generateIssuesByRuleSheet(Workbook workbook, List<SonarQubeIssuesPerRule> list, WsClient wsClient, boolean bl) throws BitegardenReportException {
        try {
            Sheet sheet = XlsxUtils.getSheet(workbook, XlsxReportTab.ISSUES_BY_RULE);
            SonarQubeRuleManager sonarQubeRuleManager = new SonarQubeRuleManager(wsClient);
            AtomicInteger atomicInteger = new AtomicInteger(1);
            for (SonarQubeIssuesPerRule sonarQubeIssuesPerRule : list) {
                Rules.Rule rule = sonarQubeRuleManager.getRule(sonarQubeIssuesPerRule.getRuleKey());
                String string = XlsxReport.getTagsByRule(rule);
                Row row = sheet.createRow(atomicInteger.getAndIncrement());
                String string2 = sonarQubeIssuesPerRule.getSeverity() == null ? "" : sonarQubeIssuesPerRule.getSeverity().name();
                String string3 = sonarQubeIssuesPerRule.getRuleType() == null ? "" : sonarQubeIssuesPerRule.getRuleType().name();
                XlsxUtils.createCell(workbook, row, 0, null).setCellValue(string2);
                XlsxUtils.createCell(workbook, row, 1, null).setCellValue(sonarQubeIssuesPerRule.getRuleMessage());
                XlsxUtils.createCell(workbook, row, 2, null).setCellValue(sonarQubeIssuesPerRule.getRuleLanguageName());
                XlsxUtils.createCell(workbook, row, 3, null).setCellValue(string3);
                XlsxUtils.createCell(workbook, row, 4, null).setCellValue(sonarQubeIssuesPerRule.getIssueCount().longValue());
                XlsxUtils.createCell(workbook, row, 5, null).setCellValue(string.isEmpty() ? "-" : string);
                if (!bl || atomicInteger.get() <= 5) continue;
                break;
            }
            XlsxReport.autoResizeColumns(sheet, 6);
        }
        catch (Exception exception) {
            throw new BitegardenReportException(exception, "Issues by Rule");
        }
    }

    private static void generateIssuesBreakdownSheet(String string, Workbook workbook, SonarQubeIssuesBreakdown sonarQubeIssuesBreakdown, boolean bl) throws BitegardenReportException {
        try {
            Sheet sheet = XlsxUtils.getSheet(workbook, XlsxReportTab.ISSUES);
            AtomicInteger atomicInteger = new AtomicInteger(1);
            for (Issues.Issue issue : sonarQubeIssuesBreakdown.getIssueList()) {
                String string2 = issue.getComponent().replace(string, "").replace(":", "");
                Row row = sheet.createRow(atomicInteger.getAndIncrement());
                ProtocolStringList protocolStringList = issue.getTagsList();
                XlsxUtils.createCell(workbook, row, 0, null).setCellValue(issue.getSeverity().name());
                XlsxUtils.createCell(workbook, row, 1, null).setCellValue(issue.getMessage());
                XlsxUtils.createCell(workbook, row, 2, null).setCellValue(sonarQubeIssuesBreakdown.getRulesObjects().get(issue.getRule()).getLangName());
                XlsxUtils.createCell(workbook, row, 3, null).setCellValue(issue.getType().name());
                XlsxUtils.createCell(workbook, row, 4, null).setCellValue(string2.contains("/") ? string2.substring(string2.lastIndexOf("/")).replace("/", "") : string2);
                XlsxUtils.createCell(workbook, row, 5, null).setCellValue(string2);
                XlsxUtils.createCell(workbook, row, 6, HorizontalAlignment.CENTER).setCellValue(issue.getLine() == 0 ? "-" : issue.getLine() + "L");
                XlsxUtils.createCell(workbook, row, 7, null).setCellValue(protocolStringList.isEmpty() ? "-" : String.join((CharSequence)",", protocolStringList));
                if (!bl || atomicInteger.get() <= 5) continue;
                break;
            }
            XlsxReport.autoResizeColumns(sheet, 8);
        }
        catch (Exception exception) {
            throw new BitegardenReportException(exception, "Issues Breakdown");
        }
    }

    private static void generateSecurityHotspotsBreakdownSheet(String string, String string2, Workbook workbook, WsClient wsClient, boolean bl) throws BitegardenReportException {
        try {
            Sheet sheet = XlsxUtils.getSheet(workbook, XlsxReportTab.SECURITY_HOTSPOTS);
            AtomicInteger atomicInteger = new AtomicInteger(1);
            SonarQubeHotspotManager sonarQubeHotspotManager = new SonarQubeHotspotManager(wsClient);
            SonarQubeRuleManager sonarQubeRuleManager = new SonarQubeRuleManager(wsClient);
            SonarQubeHotspotsBreakdown sonarQubeHotspotsBreakdown = sonarQubeHotspotManager.getSonarQubeHotspotsBreakdown(Collections.singletonList(string), string2);
            for (SonarQubeHotspotsPerCategory sonarQubeHotspotsPerCategory : sonarQubeHotspotsBreakdown.getSonarQubeHotspotsPerCategoriesByPriority()) {
                String string3 = sonarQubeHotspotsPerCategory.getComponent().replace(string, "").replace(":", "");
                ShowRequest showRequest = new ShowRequest();
                showRequest.setHotspot(sonarQubeHotspotsPerCategory.getKey());
                Hotspots.ShowWsResponse showWsResponse = wsClient.hotspots().show(showRequest);
                String string4 = showWsResponse.getRule().getKey();
                Rules.Rule rule = sonarQubeRuleManager.getRule(string4);
                String string5 = XlsxReport.getTagsByRule(rule);
                Row row = sheet.createRow(atomicInteger.getAndIncrement());
                XlsxUtils.createCell(workbook, row, 0, HorizontalAlignment.CENTER).setCellValue(sonarQubeHotspotsPerCategory.getPriority());
                XlsxUtils.createCell(workbook, row, 1, HorizontalAlignment.CENTER).setCellValue(sonarQubeHotspotsPerCategory.getCategory());
                XlsxUtils.createCell(workbook, row, 2, null).setCellValue(sonarQubeHotspotsPerCategory.getMessage());
                XlsxUtils.createCell(workbook, row, 3, null).setCellValue(string3.contains("/") ? string3.substring(string3.lastIndexOf("/")).replace("/", "") : string3);
                XlsxUtils.createCell(workbook, row, 4, null).setCellValue(string3);
                XlsxUtils.createCell(workbook, row, 5, HorizontalAlignment.CENTER).setCellValue(sonarQubeHotspotsPerCategory.getCodeLine() == 0 ? "-" : sonarQubeHotspotsPerCategory.getCodeLine() + "L");
                XlsxUtils.createCell(workbook, row, 6, null).setCellValue(string5.isEmpty() ? "-" : string5);
                if (!bl || atomicInteger.get() <= 5) continue;
                break;
            }
            XlsxReport.autoResizeColumns(sheet, 7);
        }
        catch (Exception exception) {
            throw new BitegardenReportException(exception, "Security Hotspots Breakdown");
        }
    }

    protected static File getXlsxTemplate(Locale locale, boolean bl) {
        try {
            String string = bl ? (locale.getLanguage().equals("es") ? SPANISH_TRIAL_XLSX_TEMPLATE : DEFAULT_TRIAL_XLSX_TEMPLATE) : (locale.getLanguage().equals("es") ? SPANISH_XLSX_TEMPLATE : DEFAULT_XLSX_TEMPLATE);
            InputStream inputStream2 = XlsxReport.class.getResourceAsStream(string);
            if (inputStream2 == null) {
                return null;
            }
            File file = File.createTempFile(String.valueOf(inputStream2.hashCode()), ".tmp");
            file.deleteOnExit();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                int n;
                byte[] byArray = new byte[1024];
                while ((n = inputStream2.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            return file;
        }
        catch (IOException iOException) {
            LOG.error("Error reading excel template, reason: {}", (Object)iOException.getMessage());
            LOG.debug("Error reading excel template", iOException);
            return null;
        }
    }

    protected static Workbook getWorkbook(Locale locale, boolean bl) throws IOException, InvalidFormatException {
        return new XSSFWorkbook(Objects.requireNonNull(XlsxReport.getXlsxTemplate(locale, bl)));
    }

    private static String getTagsByRule(Rules.Rule rule) {
        ProtocolStringList protocolStringList = rule.getTags().getTagsList();
        ProtocolStringList protocolStringList2 = rule.getSysTags().getSysTagsList();
        return String.join((CharSequence)",", protocolStringList) + String.join((CharSequence)",", protocolStringList2);
    }

    private static void autoResizeColumns(Sheet sheet, int n) {
        for (int i = 0; i < n; ++i) {
            sheet.autoSizeColumn(i, true);
        }
    }
}

