/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SonarQubeHotspotCategory {
    private static final String OTHERS_CATEGORY_VALUE = "Others";
    private static final Map<String, String> SQL_INJECTION_CATEGORY = Collections.singletonMap("sql-injection", "SQL Injection");
    private static final Map<String, String> RCE_CATEGORY = Collections.singletonMap("rce", "Code Injection (RCE)");
    private static final Map<String, String> OBJECT_INJECTION_CATEGORY = Collections.singletonMap("object-injection", "Object Injection");
    private static final Map<String, String> COMMAND_INJECTION_CATEGORY = Collections.singletonMap("command-injection", "Command Injection");
    private static final Map<String, String> PATH_TRAVERSAL_INJECTION_CATEGORY = Collections.singletonMap("path-traversal-injection", "Path Traversal Injection");
    private static final Map<String, String> LDAP_INJECTION_CATEGORY = Collections.singletonMap("ldap-injection", "LDAP Injection");
    private static final Map<String, String> XPATH_INJECTION_CATEGORY = Collections.singletonMap("xpath-injection", "XPath Injection");
    private static final Map<String, String> EXPRESSION_LANG_INJECTION_CATEGORY = Collections.singletonMap("expression-lang-injection", "Expression Language Injection");
    private static final Map<String, String> LOG_INJECTION_CATEGORY = Collections.singletonMap("log-injection", "Log Injection");
    private static final Map<String, String> XXE_CATEGORY = Collections.singletonMap("xxe", "XML External Entity (XXE)");
    private static final Map<String, String> XSS_CATEGORY = Collections.singletonMap("xss", "Cross-Site Scripting (XSS)");
    private static final Map<String, String> DOS_CATEGORY = Collections.singletonMap("dos", "Denial of Service (DoS)");
    private static final Map<String, String> SSRF_CATEGORY = Collections.singletonMap("ssrf", "Server-Side Request Forgery (SSRF)");
    private static final Map<String, String> CSRF_CATEGORY = Collections.singletonMap("csrf", "Cross-Site Request Forgery (CSRF)");
    private static final Map<String, String> HTTP_RESPONSE_SPLITTING_CATEGORY = Collections.singletonMap("http-response-splitting", "HTTP Response Splitting");
    private static final Map<String, String> OPEN_REDIRECT_CATEGORY = Collections.singletonMap("open-redirect", "Open Redirect");
    private static final Map<String, String> WEAK_CRYPTOGRAPHY_CATEGORY = Collections.singletonMap("weak-cryptography", "Weak Cryptography");
    private static final Map<String, String> AUTH_CATEGORY = Collections.singletonMap("auth", "Authentication");
    private static final Map<String, String> INSECURE_CONFIG_CATEGORY = Collections.singletonMap("insecure-conf", "Insecure Configuration");
    private static final Map<String, String> FILE_MANIPULATION_CATEGORY = Collections.singletonMap("file-manipulation", "File Manipulation");
    private static final Map<String, String> ENCRYPT_DATA_CATEGORY = Collections.singletonMap("encrypt-data", "Encryption of Sensitive Data");
    private static final Map<String, String> OTHERS_CATEGORY = Collections.singletonMap("others", "Others");
    private static final Map<String, String> HOTSPOT_CATEGORIES = SonarQubeHotspotCategory.createCategoriesMap();

    private SonarQubeHotspotCategory() {
    }

    public static String getHotspotCategory(String string) {
        return HOTSPOT_CATEGORIES.getOrDefault(string, OTHERS_CATEGORY_VALUE);
    }

    private static Map<String, String> createCategoriesMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(SQL_INJECTION_CATEGORY);
        hashMap.putAll(RCE_CATEGORY);
        hashMap.putAll(OBJECT_INJECTION_CATEGORY);
        hashMap.putAll(COMMAND_INJECTION_CATEGORY);
        hashMap.putAll(PATH_TRAVERSAL_INJECTION_CATEGORY);
        hashMap.putAll(LDAP_INJECTION_CATEGORY);
        hashMap.putAll(XPATH_INJECTION_CATEGORY);
        hashMap.putAll(EXPRESSION_LANG_INJECTION_CATEGORY);
        hashMap.putAll(LOG_INJECTION_CATEGORY);
        hashMap.putAll(XXE_CATEGORY);
        hashMap.putAll(XSS_CATEGORY);
        hashMap.putAll(DOS_CATEGORY);
        hashMap.putAll(SSRF_CATEGORY);
        hashMap.putAll(CSRF_CATEGORY);
        hashMap.putAll(HTTP_RESPONSE_SPLITTING_CATEGORY);
        hashMap.putAll(OPEN_REDIRECT_CATEGORY);
        hashMap.putAll(WEAK_CRYPTOGRAPHY_CATEGORY);
        hashMap.putAll(AUTH_CATEGORY);
        hashMap.putAll(INSECURE_CONFIG_CATEGORY);
        hashMap.putAll(FILE_MANIPULATION_CATEGORY);
        hashMap.putAll(ENCRYPT_DATA_CATEGORY);
        hashMap.putAll(OTHERS_CATEGORY);
        return hashMap;
    }
}

