/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.api;

import es.sonarqube.exceptions.SonarQubeException;
import java.util.Map;

public class SonarQubeOverviewSummary {
    private Integer totalProjects;
    private Map<String, String> measures;
    private String sizeRating;
    private String reliabilityRating;
    private String securityRating;
    private String securityReviewRating;
    private String maintainabilityRating;
    private String duplicationsRating;
    private String healthRating;
    private Map<String, String> sizeRatingDistribution;
    private Map<String, String> reliabilityRatingDistribution;
    private Map<String, String> securityRatingDistribution;
    private Map<String, String> securityReviewRatingDistribution;
    private Map<String, String> maintainabilityRatingDistribution;
    private Map<String, String> duplicationsRatingDistribution;
    private Map<String, String> coverageRatingDistribution;
    private Map<String, String> languageDistribution;
    private Map<String, String> healthRatingDistribution;
    private Map<String, String> issuesBySeverityDistribution;

    public SonarQubeOverviewSummary() {
    }

    public SonarQubeOverviewSummary(Map<String, Object> map) {
        this.measures = (Map)map.get("formattedMeasures");
        this.totalProjects = (Integer)map.get("totalProjects");
        this.sizeRating = (String)map.get("sizeRating");
        this.reliabilityRating = (String)map.get("reliabilityRating");
        this.securityRating = (String)map.get("securityRating");
        this.securityReviewRating = (String)map.get("securityReviewRating");
        this.maintainabilityRating = (String)map.get("maintainabilityRating");
        this.duplicationsRating = (String)map.get("duplicationsRating");
        this.healthRating = (String)map.get("healthRating");
        this.sizeRatingDistribution = (Map)map.get("sizeRatingDistribution");
        this.reliabilityRatingDistribution = (Map)map.get("reliabilityRatingDistribution");
        this.securityRatingDistribution = (Map)map.get("securityRatingDistribution");
        this.securityReviewRatingDistribution = (Map)map.get("securityReviewRatingDistribution");
        this.maintainabilityRatingDistribution = (Map)map.get("maintainabilityRatingDistribution");
        this.duplicationsRatingDistribution = (Map)map.get("duplicationsRatingDistribution");
        this.coverageRatingDistribution = (Map)map.get("coverageRatingDistribution");
        this.languageDistribution = (Map)map.get("languages");
        this.healthRatingDistribution = (Map)map.get("qualityGateDistribution");
        this.issuesBySeverityDistribution = (Map)map.get("issues");
    }

    public Integer getTotalProjects() {
        return this.totalProjects;
    }

    public void setTotalProjects(Integer n) {
        this.totalProjects = n;
    }

    public String getNcloc() {
        return this.measures.get("ncloc");
    }

    public String getBugs() {
        return this.measures.get("bugs");
    }

    public String getVulnerabilities() {
        return this.measures.get("vulnerabilities");
    }

    public String getCodeSmells() {
        return this.measures.get("code_smells");
    }

    public String getSecurityHotspots() {
        return this.measures.get("security_hotspots");
    }

    public String getDuplicationDensity() {
        return this.measures.get("duplicated_lines_density");
    }

    public String getCoverage() {
        return this.measures.get("coverage");
    }

    public String getMeasureValueForMetric(String string) throws SonarQubeException {
        if (this.measures != null && this.measures.containsKey(string)) {
            return this.measures.get(string);
        }
        throw new SonarQubeException("Metric key not found in overview summary measures");
    }

    public String getMaintainabilityRating() {
        return this.maintainabilityRating;
    }

    public String getSecurityReviewRating() {
        return this.securityReviewRating;
    }

    public String getSecurityRating() {
        return this.securityRating;
    }

    public String getReliabilityRating() {
        return this.reliabilityRating;
    }

    public String getSizeRating() {
        return this.sizeRating;
    }

    public String getDuplicationsRating() {
        return this.duplicationsRating;
    }

    public Map<String, String> getSizeRatingDistribution() {
        return this.sizeRatingDistribution;
    }

    public Map<String, String> getReliabilityRatingDistribution() {
        return this.reliabilityRatingDistribution;
    }

    public Map<String, String> getSecurityRatingDistribution() {
        return this.securityRatingDistribution;
    }

    public Map<String, String> getSecurityReviewRatingDistribution() {
        return this.securityReviewRatingDistribution;
    }

    public Map<String, String> getMaintainabilityRatingDistribution() {
        return this.maintainabilityRatingDistribution;
    }

    public Map<String, String> getDuplicationsRatingDistribution() {
        return this.duplicationsRatingDistribution;
    }

    public Map<String, String> getCoverageRatingDistribution() {
        return this.coverageRatingDistribution;
    }

    public String getHealthRating() {
        return this.healthRating;
    }

    public Map<String, String> getLanguageDistribution() {
        return this.languageDistribution;
    }

    public Map<String, String> getHealthRatingDistribution() {
        return this.healthRatingDistribution;
    }

    public Map<String, String> getIssuesBySeverityDistribution() {
        return this.issuesBySeverityDistribution;
    }
}

