/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.exceptions;

import com.google.gson.Gson;
import es.sonarqube.api.SonarQubeError;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.exceptions.SonarQubeForbiddenException;
import org.sonarqube.ws.client.HttpException;

public class ExceptionUtils {
    private static final int FORBIDDEN_CODE = 403;

    private ExceptionUtils() {
    }

    public static SonarQubeException getSonarQubeException(HttpException httpException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (403 == httpException.code()) {
            return new SonarQubeForbiddenException(httpException);
        }
        if (httpException.content() != null && !httpException.content().isEmpty()) {
            SonarQubeError sonarQubeError = new Gson().fromJson(httpException.content(), SonarQubeError.class);
            if (sonarQubeError.getErrors() != null) {
                sonarQubeError.getErrors().forEach(sonarQubeErrorMessage -> stringBuilder.append(sonarQubeErrorMessage.getMsg()).append(","));
            }
        } else {
            stringBuilder.append(httpException.getMessage());
        }
        if (!stringBuilder.toString().isEmpty()) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return new SonarQubeException(stringBuilder.toString(), httpException);
    }
}

