/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.protobuf.GeneratedMessageV3;
import es.sonarqube.api.SonarQubeIssuesBreakdown;
import es.sonarqube.api.SonarQubeIssuesPerRule;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeHotspotManager;
import es.sonarqube.managers.SonarQubeProjectManager;
import es.sonarqube.managers.SonarQubeRuleManager;
import es.sonarqube.managers.SonarQubeServerManager;
import es.sonarqube.managers.SonarQubeURLManager;
import es.sonarqube.model.SonarQubeIssueType;
import es.sonarqube.utils.ParamsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.issues.SearchRequest;

public class SonarQubeIssueManager {
    public static final String BUG = "BUG";
    public static final String VULNERABILITY = "VULNERABILITY";
    public static final String CODE_SMELL = "CODE_SMELL";
    public static final String SECURITY_HOTSPOT = "SECURITY_HOTSPOT";
    public static final String BLOCKER = "BLOCKER";
    public static final String CRITICAL = "CRITICAL";
    public static final String MAJOR = "MAJOR";
    public static final String MINOR = "MINOR";
    public static final String INFO = "INFO";
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeIssueManager.class);
    private static final String ERROR_GETTING_ISSUE_FROM_SEVERITY = "Error getting issues from projects (%s) from severity (%s) ";
    private static final String ERROR_GETTING_ISSUES = "Error getting issues: %s ";
    private static final String ERROR_GETTING_ISSUE_FROM_RULE = "Error getting issues from project (%s) with sonar rule (%s) ";
    private static final String RULES = "rules";
    private static final String FALSE = "false";
    public static final String API_ISSUES_LIMIT_LOG_MESSAGE = "Found {} issues and SonarQube limit is 10000 issues. We will only return the first 10000 issues!";
    private final WsClient wsClient;
    private final Locale userLocale;

    public SonarQubeIssueManager(WsClient wsClient, Locale locale) {
        this.wsClient = wsClient;
        this.userLocale = locale;
    }

    public SonarQubeIssueManager(String string, String string2, Locale locale) {
        this.userLocale = locale;
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static SonarQubeIssuesBreakdown getIssueBreakdown(WsClient wsClient, List<String> list, String string, Locale locale, boolean bl) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getIssueBreakdown(list, string, bl);
    }

    protected static List<Issues.Issue> getIssuesForRule(WsClient wsClient, String string, String string2, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getIssuesForRule(string, string2);
    }

    protected static Map<String, Long> getBlockerRules(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getBlockerRules(list);
    }

    protected static Map<String, Long> getCriticalRules(WsClient wsClient, List<String> list, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).getCriticalRules(list);
    }

    protected static List<Issues.Issue> searchIssuesByAuthor(WsClient wsClient, List<String> list, List<String> list2, String string, Locale locale) throws SonarQubeException {
        return new SonarQubeIssueManager(wsClient, locale).searchIssuesByAuthor(list, list2, string);
    }

    public Map<String, Long> getBlockerRules(List<String> list) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, BLOCKER, "");
    }

    public Map<String, Long> getBlockerRules(String string, String string2) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, BLOCKER, string2);
    }

    public Map<String, Long> getCriticalRules(List<String> list) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, CRITICAL, "");
    }

    public Map<String, Long> getCriticalRules(String string, String string2) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, CRITICAL, string2);
    }

    public Map<String, Long> getIssuesForResolution(List<String> list, String string, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setFacets(Collections.singletonList(RULES));
        searchRequest.setResolutions(Collections.singletonList(string));
        searchRequest.setProjects(list);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForResolutionByProject(List<String> list, String string, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setFacets(Collections.singletonList("projects"));
        searchRequest.setResolutions(Collections.singletonList(string));
        searchRequest.setProjects(list);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForResolution(List<String> list, String string) {
        return this.getIssuesForResolution(list, string, null);
    }

    public Map<String, Long> getIssuesForResolution(String string, String string2) {
        return this.getIssuesForResolution(Collections.singletonList(string), string2, null);
    }

    public Map<String, Long> getIssuesForResolution(String string, String string2, String string3) {
        return this.getIssuesForResolution(Collections.singletonList(string), string2, string3);
    }

    public Map<String, Long> getIssuesByRule(List<String> list, String string) {
        return this.getIssuesByRule(list, string, null, null);
    }

    public Map<String, Long> getIssuesByRule(List<String> list, String string, String string2) {
        return this.getIssuesByRule(list, string, string2, null);
    }

    public Map<String, Long> getIssuesByRule(List<String> list, String string, String string2, String string3) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setFacets(Collections.singletonList(RULES));
        searchRequest.setResolved(FALSE);
        searchRequest.setComponentKeys(list);
        if (string != null && !string.isEmpty()) {
            searchRequest.setBranch(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setTypes(Collections.singletonList(string2));
        }
        if (string3 != null && !string3.isEmpty()) {
            searchRequest.setSeverities(Collections.singletonList(string3));
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesByRule(List<String> list) {
        return this.getIssuesByRule(list, null);
    }

    public Map<String, Long> getIssuesByRule(String string) {
        return this.getIssuesByRule(Collections.singletonList(string), null);
    }

    public Map<String, Long> getIssuesByRule(String string, String string2) {
        return this.getIssuesByRule(Collections.singletonList(string), string2);
    }

    public Map<String, Long> getIssuesTypeByRule(List<String> list, String string, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setFacets(Collections.singletonList(RULES));
        searchRequest.setResolved(FALSE);
        searchRequest.setComponentKeys(list);
        searchRequest.setTypes(Collections.singletonList(string));
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        Common.Facets facets = searchWsResponse.getFacets();
        for (Common.Facet facet : facets.getFacetsList()) {
            for (Common.FacetValue facetValue : facet.getValuesList()) {
                hashMap.put(facetValue.getVal(), facetValue.getCount());
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesTotalBySeverity(String string, String string2, String string3) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(BLOCKER, 0L);
        hashMap.put(CRITICAL, 0L);
        hashMap.put(MAJOR, 0L);
        hashMap.put(MINOR, 0L);
        hashMap.put(INFO, 0L);
        try {
            SearchRequest searchRequest = new SearchRequest();
            if (ParamsUtils.hasValue(string3)) {
                searchRequest.setBranch(string3);
            }
            searchRequest.setComponentKeys(Collections.singletonList(string2));
            searchRequest.setTypes(Collections.singletonList(string));
            searchRequest.setFacets(Collections.singletonList("severities"));
            searchRequest.setResolved(FALSE);
            Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
            for (Common.Facet facet : searchWsResponse.getFacets().getFacetsList()) {
                for (Common.FacetValue facetValue : facet.getValuesList()) {
                    LOGGER.trace("{} -> Severity {} -> {} issues", string, facetValue.getVal(), facetValue.getCount());
                    hashMap.put(facetValue.getVal(), facetValue.getCount());
                }
            }
        }
        catch (HttpException httpException) {
            LOGGER.error("Error getting issues by severity for {} in project {}", (Object)string, (Object)string2);
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error("Error getting issues by severity for {} in project {}", (Object)string, (Object)string2);
            throw new SonarQubeException(String.format("Error getting issues by severity: %s", exception.getMessage()));
        }
        return hashMap;
    }

    public Map<String, Long> getIssuesTotalBySeverity(String string, List<String> list, String string2) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(BLOCKER, 0L);
        hashMap.put(CRITICAL, 0L);
        hashMap.put(MAJOR, 0L);
        hashMap.put(MINOR, 0L);
        hashMap.put(INFO, 0L);
        for (String string3 : list) {
            Map<String, Long> map = this.getIssuesTotalBySeverity(string, string3, string2);
            Long l = (Long)hashMap.get(BLOCKER);
            Long l2 = l + map.get(BLOCKER);
            hashMap.put(BLOCKER, l2);
            l = (Long)hashMap.get(CRITICAL);
            l2 = l + map.get(CRITICAL);
            hashMap.put(CRITICAL, l2);
            l = (Long)hashMap.get(MAJOR);
            l2 = l + map.get(MAJOR);
            hashMap.put(MAJOR, l2);
            l = (Long)hashMap.get(MINOR);
            l2 = l + map.get(MINOR);
            hashMap.put(MINOR, l2);
            l = (Long)hashMap.get(INFO);
            l2 = l + map.get(INFO);
            hashMap.put(INFO, l2);
        }
        return hashMap;
    }

    public Map<String, Long> getIssuesForSeverity(String string, String string2) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, string2, null);
    }

    public Map<String, Long> getIssuesForSeverity(String string, String string2, String string3) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), null, string2, string3);
    }

    public Map<String, Long> getIssuesForType(List<String> list, List<String> list2, String string, String string2) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForTypeByAuthor(list, list2, string2);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> {
                if (facetValue.getVal().equals(string)) {
                    hashMap.put(facetValue.getVal(), facetValue.getCount());
                }
            }));
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string));
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverity(List<String> list, List<String> list2, String string, String string2) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForRules(list, list2, string, "", string2);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string));
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverity(String string, String string2, String string3, String string4, String string5) throws SonarQubeException {
        return this.getIssuesForSeverity(Collections.singletonList(string), string2, string3, string4, string5);
    }

    public Map<String, Long> getIssuesForSeverity(List<String> list, String string, String string2, String string3, String string4) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForRules(list, string, "", string2, string3, string4);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug(String.format(ERROR_GETTING_ISSUE_FROM_SEVERITY, list, string));
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverityByAuthors(List<String> list, String string, String string2, String string3, String string4) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForAuthors(list, string, string2, string3, string4);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.error("Error HTTP getting issues from projects ({}) from severity ({}) ", (Object)list, (Object)string);
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error("Error getting issues from projects ({}) from severity ({}) ", (Object)list, (Object)string);
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getIssuesForSeverityByProjects(List<String> list, String string, String string2, String string3, String string4) throws SonarQubeException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        try {
            Issues.SearchWsResponse searchWsResponse = this.searchIssuesForProjects(list, string, string2, string3, string4);
            searchWsResponse.getFacets().getFacetsList().forEach(facet -> facet.getValuesList().forEach(facetValue -> hashMap.put(facetValue.getVal(), facetValue.getCount())));
        }
        catch (HttpException httpException) {
            LOGGER.error("Error HTTP getting issues from projects ({}) from severity ({}) ", (Object)list, (Object)string);
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error("Error getting issues from projects ({}) from severity ({}) ", (Object)list, (Object)string);
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
        return this.sortByValue(hashMap);
    }

    public List<Issues.Issue> getIssuesForRule(String string, String string2) throws SonarQubeException {
        try {
            return this.searchIssues(Collections.singletonList(string), "", string2);
        }
        catch (HttpException httpException) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_RULE, string, string2));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_RULE, string, string2));
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
    }

    public List<Issues.Issue> getIssuesForRule(String string, String string2, String string3) throws SonarQubeException {
        try {
            return this.searchIssues(Collections.singletonList(string), "", string2, string3);
        }
        catch (HttpException httpException) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_RULE, string, string2));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_RULE, string, string2));
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
    }

    public List<Issues.Issue> getIssuesForRule(String string, String string2, String string3, String string4) throws SonarQubeException {
        try {
            return this.searchIssues(Collections.singletonList(string), string2, string3, string4);
        }
        catch (HttpException httpException) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_RULE, string, string3));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.error(String.format(ERROR_GETTING_ISSUE_FROM_RULE, string, string3));
            throw new SonarQubeException(String.format(ERROR_GETTING_ISSUES, exception.getMessage()));
        }
    }

    private List<Issues.Issue> searchIssues(List<String> list, String string, String string2) {
        return this.searchIssues(list, string, string2, null);
    }

    private List<Issues.Issue> searchIssues(List<String> list, String string, String string2, String string3) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setComponentKeys(list);
        searchRequest.setResolved(FALSE);
        searchRequest.setFacets(Collections.singletonList(RULES));
        searchRequest.setAdditionalFields(Collections.singletonList(RULES));
        searchRequest.setPs("500");
        if (string3 != null && !string3.isEmpty()) {
            searchRequest.setBranch(string3);
        }
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setRules(Collections.singletonList(string2));
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        ArrayList<Issues.Issue> arrayList = new ArrayList<Issues.Issue>();
        arrayList.addAll(searchWsResponse.getIssuesList());
        if (searchWsResponse.getTotal() > 10000L) {
            LOGGER.warn(API_ISSUES_LIMIT_LOG_MESSAGE, (Object)searchWsResponse.getTotal());
        }
        if (searchWsResponse.getTotal() > (long)searchWsResponse.getPs()) {
            int n = (int)Math.floor((double)searchWsResponse.getTotal() / (double)searchWsResponse.getPs()) + 1;
            n = Math.min(n, 20);
            for (int i = 2; i <= n; ++i) {
                searchRequest.setP("" + i);
                searchWsResponse = this.wsClient.issues().search(searchRequest);
                arrayList.addAll(searchWsResponse.getIssuesList());
            }
        }
        return arrayList;
    }

    private void searchIssuesAndRules(List<String> list, String string, String string2, List<Issues.Issue> list2, Map<String, Common.Rule> map, List<String> list3) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string2));
        searchRequest.setComponentKeys(list);
        searchRequest.setResolved(FALSE);
        searchRequest.setFacets(Collections.singletonList(RULES));
        searchRequest.setAdditionalFields(Collections.singletonList(RULES));
        searchRequest.setTypes(list3);
        searchRequest.setPs("500");
        if (string != null && !string.isEmpty()) {
            searchRequest.setBranch(string);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        list2.addAll(searchWsResponse.getIssuesList());
        searchWsResponse.getRules().getRulesList().forEach(rule -> map.putIfAbsent(rule.getKey(), (Common.Rule)rule));
        if (searchWsResponse.getTotal() > 10000L) {
            LOGGER.warn(API_ISSUES_LIMIT_LOG_MESSAGE, (Object)searchWsResponse.getTotal());
        }
        if (searchWsResponse.getTotal() > (long)searchWsResponse.getPs()) {
            int n = (int)Math.floor((double)searchWsResponse.getTotal() / (double)searchWsResponse.getPs()) + 1;
            n = Math.min(n, 20);
            for (int i = 2; i <= n; ++i) {
                searchRequest.setP("" + i);
                searchWsResponse = this.wsClient.issues().search(searchRequest);
                list2.addAll(searchWsResponse.getIssuesList());
                searchWsResponse.getRules().getRulesList().forEach(rule -> map.putIfAbsent(rule.getKey(), (Common.Rule)rule));
            }
        }
    }

    private void searchSecurityHotspotsIssues(List<String> list, String string, List<Issues.Issue> list2, Map<String, Common.Rule> map) throws SonarQubeException {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setComponentKeys(list);
        searchRequest.setAdditionalFields(Collections.singletonList(RULES));
        searchRequest.setPs("500");
        searchRequest.setStatuses(Collections.singletonList("TO_REVIEW"));
        if (string != null && !string.isEmpty()) {
            searchRequest.setBranch(string);
        }
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        list2.addAll(this.getSecurityHotspotsIssues(searchWsResponse));
        searchWsResponse.getRules().getRulesList().forEach(rule -> map.putIfAbsent(rule.getKey(), (Common.Rule)rule));
        if (searchWsResponse.getTotal() > 10000L) {
            LOGGER.warn(API_ISSUES_LIMIT_LOG_MESSAGE, (Object)searchWsResponse.getTotal());
        }
        if (searchWsResponse.getTotal() > (long)searchWsResponse.getPs()) {
            int n = (int)Math.floor((double)searchWsResponse.getTotal() / (double)searchWsResponse.getPs()) + 1;
            n = Math.min(n, 20);
            for (int i = 2; i <= n; ++i) {
                searchRequest.setP("" + i);
                searchWsResponse = this.wsClient.issues().search(searchRequest);
                list2.addAll(this.getSecurityHotspotsIssues(searchWsResponse));
                searchWsResponse.getRules().getRulesList().forEach(rule -> map.putIfAbsent(rule.getKey(), (Common.Rule)rule));
            }
        }
    }

    private List<Issues.Issue> getSecurityHotspotsIssues(Issues.SearchWsResponse searchWsResponse) throws SonarQubeException {
        ArrayList<Issues.Issue> arrayList = new ArrayList<Issues.Issue>();
        for (Issues.Issue issue : searchWsResponse.getIssuesList()) {
            String string = SonarQubeRuleManager.getRule(this.wsClient, issue.getRule()).getSeverity();
            Issues.Issue issue2 = Issues.Issue.newBuilder(issue).setSeverity(Common.Severity.valueOf(string)).build();
            arrayList.add(issue2);
        }
        return arrayList;
    }

    private Issues.SearchWsResponse searchIssuesForTypeByAuthor(List<String> list, List<String> list2, String string) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setResolved(FALSE);
        searchRequest.setFacets(Collections.singletonList("types"));
        if (list != null && !list.isEmpty()) {
            searchRequest.setProjects(list);
        }
        if (list2 != null && !list2.isEmpty()) {
            searchRequest.setAuthor(list2);
        }
        if (string != null && !string.isEmpty()) {
            searchRequest.setBranch(string);
        }
        return this.wsClient.issues().search(searchRequest);
    }

    private Issues.SearchWsResponse searchIssuesForRules(List<String> list, List<String> list2, String string, String string2, String string3) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setResolved(FALSE);
        searchRequest.setFacets(Collections.singletonList(RULES));
        searchRequest.setAdditionalFields(Collections.singletonList(RULES));
        if (list != null && !list.isEmpty()) {
            searchRequest.setProjects(list);
        }
        if (list2 != null && !list2.isEmpty()) {
            searchRequest.setAuthor(list2);
        }
        if (string3 != null && !string3.isEmpty()) {
            searchRequest.setBranch(string3);
        }
        if (!string2.isEmpty()) {
            searchRequest.setRules(Collections.singletonList(string2));
        }
        return this.wsClient.issues().search(searchRequest);
    }

    private Issues.SearchWsResponse searchIssuesForRules(List<String> list, String string, String string2, String string3, String string4, String string5) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setProjects(list);
        searchRequest.setResolved(FALSE);
        searchRequest.setFacets(Collections.singletonList(RULES));
        searchRequest.setAdditionalFields(Collections.singletonList(RULES));
        searchRequest.setCreatedAfter(string4);
        searchRequest.setCreatedBefore(string5);
        if (string3 != null && !string3.isEmpty()) {
            searchRequest.setBranch(string3);
        }
        if (!string2.isEmpty()) {
            searchRequest.setRules(Collections.singletonList(string2));
        }
        return this.wsClient.issues().search(searchRequest);
    }

    private Issues.SearchWsResponse searchIssuesForAuthors(List<String> list, String string, String string2, String string3, String string4) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setProjects(list);
        searchRequest.setResolved(FALSE);
        searchRequest.setFacets(Collections.singletonList(SonarQubeIssueManager.getAuthorFacetsParam(this.wsClient)));
        searchRequest.setCreatedAfter(string3);
        searchRequest.setCreatedBefore(string4);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        return this.wsClient.issues().search(searchRequest);
    }

    public List<Issues.Issue> searchIssuesByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        GeneratedMessageV3 generatedMessageV3;
        LOGGER.debug("Searching issues by author: ({}) and branch ({})", (Object)list, (Object)string);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setResolved(FALSE);
        searchRequest.setAuthor(list);
        searchRequest.setPs("500");
        if (list2 != null && !list2.isEmpty()) {
            searchRequest.setProjects(list2);
            if (list2.size() == 1) {
                if (string != null && !string.isEmpty()) {
                    searchRequest.setBranch(string);
                } else {
                    generatedMessageV3 = SonarQubeProjectManager.getProjectMainBranch(this.wsClient, SonarQubeProjectManager.getProjectBranches(this.wsClient, list2.get(0), this.userLocale), this.userLocale);
                    searchRequest.setBranch(((ProjectBranches.Branch)generatedMessageV3).getName());
                }
            }
        }
        generatedMessageV3 = this.wsClient.issues().search(searchRequest);
        ArrayList<Issues.Issue> arrayList = new ArrayList<Issues.Issue>();
        arrayList.addAll(((Issues.SearchWsResponse)generatedMessageV3).getIssuesList());
        if (((Issues.SearchWsResponse)generatedMessageV3).getTotal() > 10000L) {
            LOGGER.warn(API_ISSUES_LIMIT_LOG_MESSAGE, (Object)((Issues.SearchWsResponse)generatedMessageV3).getTotal());
        }
        if (((Issues.SearchWsResponse)generatedMessageV3).getTotal() > (long)((Issues.SearchWsResponse)generatedMessageV3).getPs()) {
            int n = (int)Math.floor((double)((Issues.SearchWsResponse)generatedMessageV3).getTotal() / (double)((Issues.SearchWsResponse)generatedMessageV3).getPs()) + 1;
            n = Math.min(n, 20);
            for (int i = 2; i <= n; ++i) {
                searchRequest.setP("" + i);
                generatedMessageV3 = this.wsClient.issues().search(searchRequest);
                arrayList.addAll(((Issues.SearchWsResponse)generatedMessageV3).getIssuesList());
            }
        }
        return arrayList;
    }

    private Issues.SearchWsResponse searchIssuesForProjects(List<String> list, String string, String string2, String string3, String string4) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setSeverities(Collections.singletonList(string));
        searchRequest.setProjects(list);
        searchRequest.setResolved(FALSE);
        searchRequest.setFacets(Collections.singletonList("projects"));
        searchRequest.setCreatedAfter(string3);
        searchRequest.setCreatedBefore(string4);
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        return this.wsClient.issues().search(searchRequest);
    }

    public Map<String, Long> getBugRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForType(null, list, BUG, string);
    }

    public Map<String, Long> getBugRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForType(list, list2, BUG, string);
    }

    public Map<String, Long> getVulnerabilityRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForType(null, list, VULNERABILITY, string);
    }

    public Map<String, Long> getVulnerabilityRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForType(list, list2, VULNERABILITY, string);
    }

    public Map<String, Long> getCodeSmellsRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForType(null, list, CODE_SMELL, string);
    }

    public Map<String, Long> getCodeSmellsRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForType(list, list2, CODE_SMELL, string);
    }

    public Map<String, Long> getBlockerRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, BLOCKER, string);
    }

    public Map<String, Long> getBlockerRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, BLOCKER, string);
    }

    public Map<String, Long> getCriticalRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, CRITICAL, string);
    }

    public Map<String, Long> getCriticalRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, CRITICAL, string);
    }

    public Map<String, Long> getMajorRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, MAJOR, string);
    }

    public Map<String, Long> getMajorRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, MAJOR, string);
    }

    public Map<String, Long> getMinorRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, MINOR, string);
    }

    public Map<String, Long> getMinorRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, MINOR, string);
    }

    public Map<String, Long> getInfoRules(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, null, INFO, string);
    }

    public Map<String, Long> getInfoRulesFromResourceIdsByAuthor(List<String> list, List<String> list2, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(list, list2, INFO, string);
    }

    public Map<String, Long> getInfoRulesByAuthor(List<String> list, String string) throws SonarQubeException {
        return this.getIssuesForSeverity(null, list, INFO, string);
    }

    public SonarQubeIssuesBreakdown getIssueBreakdown(String string, String string2, boolean bl, SonarQubeIssueType ... sonarQubeIssueTypeArray) throws SonarQubeException {
        return this.getIssueBreakdown(Collections.singletonList(string), string2, bl, sonarQubeIssueTypeArray);
    }

    public SonarQubeIssuesBreakdown getIssueBreakdown(String string, String string2, boolean bl) throws SonarQubeException {
        return this.getIssueBreakdown(Collections.singletonList(string), string2, bl);
    }

    public SonarQubeIssuesBreakdown getIssueBreakdown(String string, boolean bl) throws SonarQubeException {
        return this.getIssueBreakdown(Collections.singletonList(string), null, bl);
    }

    public SonarQubeIssuesBreakdown getIssueBreakdown(List<String> list, boolean bl) throws SonarQubeException {
        return this.getIssueBreakdown(list, null, bl, SonarQubeIssueType.ALL);
    }

    public SonarQubeIssuesBreakdown getIssueBreakdown(List<String> list, String string, boolean bl) throws SonarQubeException {
        return this.getIssueBreakdown(list, string, bl, SonarQubeIssueType.ALL);
    }

    public SonarQubeIssuesBreakdown getIssueBreakdown(List<String> list, boolean bl, SonarQubeIssueType ... sonarQubeIssueTypeArray) throws SonarQubeException {
        return this.getIssueBreakdown(list, null, bl, sonarQubeIssueTypeArray);
    }

    public SonarQubeIssuesBreakdown getIssueBreakdown(List<String> list, String string, boolean bl, SonarQubeIssueType ... sonarQubeIssueTypeArray) throws SonarQubeException {
        SonarQubeIssuesBreakdown sonarQubeIssuesBreakdown = new SonarQubeIssuesBreakdown();
        try {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap3 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap4 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap5 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap6 = new HashMap<String, Long>();
            List<SonarQubeIssueType> list2 = Arrays.asList(sonarQubeIssueTypeArray);
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, Long> hashMap7 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap8 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap9 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap10 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap11 = new HashMap<String, Long>();
            if (ParamsUtils.addBugs(list2)) {
                arrayList.add(SonarQubeIssueType.BUG.name());
                hashMap7.putAll(this.getIssuesByRule(list, string, BUG, BLOCKER));
                hashMap2.putAll(hashMap7);
                sonarQubeIssuesBreakdown.setBlockerBugsRules(hashMap7);
                hashMap8.putAll(this.getIssuesByRule(list, string, BUG, CRITICAL));
                hashMap3.putAll(hashMap8);
                sonarQubeIssuesBreakdown.setCriticalBugsRules(hashMap8);
                hashMap9.putAll(this.getIssuesByRule(list, string, BUG, MAJOR));
                hashMap4.putAll(hashMap9);
                sonarQubeIssuesBreakdown.setMajorBugsRules(hashMap9);
                hashMap10.putAll(this.getIssuesByRule(list, string, BUG, MINOR));
                hashMap5.putAll(hashMap10);
                sonarQubeIssuesBreakdown.setMinorBugsRules(hashMap10);
                hashMap11.putAll(this.getIssuesByRule(list, string, BUG, INFO));
                hashMap6.putAll(hashMap11);
                sonarQubeIssuesBreakdown.setInfoBugsRules(hashMap11);
                sonarQubeIssuesBreakdown.setTotalBlockerBugsIssues(this.getTotalValuesByMap(hashMap7));
                sonarQubeIssuesBreakdown.setTotalCriticalBugsIssues(this.getTotalValuesByMap(hashMap8));
                sonarQubeIssuesBreakdown.setTotalMajorBugsIssues(this.getTotalValuesByMap(hashMap9));
                sonarQubeIssuesBreakdown.setTotalMinorBugsIssues(this.getTotalValuesByMap(hashMap10));
                sonarQubeIssuesBreakdown.setTotalInfoBugsIssues(this.getTotalValuesByMap(hashMap11));
            }
            HashMap<String, Long> hashMap12 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap13 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap14 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap15 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap16 = new HashMap<String, Long>();
            if (ParamsUtils.addVulnerabilities(list2)) {
                arrayList.add(SonarQubeIssueType.VULNERABILITY.name());
                hashMap12.putAll(this.getIssuesByRule(list, string, VULNERABILITY, BLOCKER));
                hashMap2.putAll(hashMap12);
                sonarQubeIssuesBreakdown.setBlockerVulnerabilitiesRules(hashMap12);
                hashMap13.putAll(this.getIssuesByRule(list, string, VULNERABILITY, CRITICAL));
                hashMap3.putAll(hashMap13);
                sonarQubeIssuesBreakdown.setCriticalVulnerabilitiesRules(hashMap13);
                hashMap14.putAll(this.getIssuesByRule(list, string, VULNERABILITY, MAJOR));
                hashMap4.putAll(hashMap14);
                sonarQubeIssuesBreakdown.setMajorVulnerabilitiesRules(hashMap14);
                hashMap15.putAll(this.getIssuesByRule(list, string, VULNERABILITY, MINOR));
                hashMap5.putAll(hashMap15);
                sonarQubeIssuesBreakdown.setMinorVulnerabilitiesRules(hashMap15);
                hashMap16.putAll(this.getIssuesByRule(list, string, VULNERABILITY, INFO));
                hashMap6.putAll(hashMap16);
                sonarQubeIssuesBreakdown.setInfoVulnerabilitiesRules(hashMap16);
                sonarQubeIssuesBreakdown.setTotalBlockerVulnerabilitiesIssues(this.getTotalValuesByMap(hashMap12));
                sonarQubeIssuesBreakdown.setTotalCriticalVulnerabilitiesIssues(this.getTotalValuesByMap(hashMap13));
                sonarQubeIssuesBreakdown.setTotalMajorVulnerabilitiesIssues(this.getTotalValuesByMap(hashMap14));
                sonarQubeIssuesBreakdown.setTotalMinorVulnerabilitiesIssues(this.getTotalValuesByMap(hashMap15));
                sonarQubeIssuesBreakdown.setTotalInfoVulnerabilitiesIssues(this.getTotalValuesByMap(hashMap16));
            }
            HashMap<String, Long> hashMap17 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap18 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap19 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap20 = new HashMap<String, Long>();
            HashMap<String, Long> hashMap21 = new HashMap<String, Long>();
            if (ParamsUtils.addCodeSmells(list2)) {
                arrayList.add(SonarQubeIssueType.CODE_SMELL.name());
                hashMap17.putAll(this.getIssuesByRule(list, string, CODE_SMELL, BLOCKER));
                hashMap2.putAll(hashMap17);
                sonarQubeIssuesBreakdown.setBlockerCodeSmellsRules(hashMap17);
                hashMap18.putAll(this.getIssuesByRule(list, string, CODE_SMELL, CRITICAL));
                hashMap3.putAll(hashMap18);
                sonarQubeIssuesBreakdown.setCriticalCodeSmellsRules(hashMap18);
                hashMap19.putAll(this.getIssuesByRule(list, string, CODE_SMELL, MAJOR));
                hashMap4.putAll(hashMap19);
                sonarQubeIssuesBreakdown.setMajorCodeSmellsRules(hashMap19);
                hashMap20.putAll(this.getIssuesByRule(list, string, CODE_SMELL, MINOR));
                hashMap5.putAll(hashMap20);
                sonarQubeIssuesBreakdown.setMinorCodeSmellsRules(hashMap20);
                hashMap21.putAll(this.getIssuesByRule(list, string, CODE_SMELL, INFO));
                hashMap6.putAll(hashMap21);
                sonarQubeIssuesBreakdown.setInfoCodeSmellsRules(hashMap21);
                sonarQubeIssuesBreakdown.setTotalBlockerCodeSmellsIssues(this.getTotalValuesByMap(hashMap17));
                sonarQubeIssuesBreakdown.setTotalCriticalCodeSmellsIssues(this.getTotalValuesByMap(hashMap18));
                sonarQubeIssuesBreakdown.setTotalMajorCodeSmellsIssues(this.getTotalValuesByMap(hashMap19));
                sonarQubeIssuesBreakdown.setTotalMinorCodeSmellsIssues(this.getTotalValuesByMap(hashMap20));
                sonarQubeIssuesBreakdown.setTotalInfoCodeSmellsIssues(this.getTotalValuesByMap(hashMap21));
            }
            hashMap.putAll(hashMap2);
            hashMap.putAll(hashMap3);
            hashMap.putAll(hashMap4);
            hashMap.putAll(hashMap5);
            hashMap.putAll(hashMap6);
            sonarQubeIssuesBreakdown.setBlockerRules(this.sortByValue(hashMap2));
            sonarQubeIssuesBreakdown.setCriticalRules(this.sortByValue(hashMap3));
            sonarQubeIssuesBreakdown.setMajorRules(this.sortByValue(hashMap4));
            sonarQubeIssuesBreakdown.setMinorRules(this.sortByValue(hashMap5));
            sonarQubeIssuesBreakdown.setInfoRules(this.sortByValue(hashMap6));
            Long l = this.getTotalValuesByMap(hashMap2) + this.getTotalValuesByMap(hashMap3) + this.getTotalValuesByMap(hashMap4) + this.getTotalValuesByMap(hashMap5) + this.getTotalValuesByMap(hashMap6);
            sonarQubeIssuesBreakdown.setTotalIssuesCount(l);
            sonarQubeIssuesBreakdown.setTotalBlockerIssues(this.getTotalValuesByMap(hashMap2));
            sonarQubeIssuesBreakdown.setTotalCriticalIssues(this.getTotalValuesByMap(hashMap3));
            sonarQubeIssuesBreakdown.setTotalMajorIssues(this.getTotalValuesByMap(hashMap4));
            sonarQubeIssuesBreakdown.setTotalMinorIssues(this.getTotalValuesByMap(hashMap5));
            sonarQubeIssuesBreakdown.setTotalInfoIssues(this.getTotalValuesByMap(hashMap6));
            if (bl) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                HashMap<String, Common.Rule> hashMap22 = new HashMap<String, Common.Rule>();
                ArrayList<Issues.Issue> arrayList3 = new ArrayList<Issues.Issue>();
                this.searchIssuesAndRules(list, string, BLOCKER, arrayList3, hashMap22, arrayList);
                sonarQubeIssuesBreakdown.setBlockerIssues(arrayList3);
                ArrayList<Issues.Issue> arrayList4 = new ArrayList<Issues.Issue>(arrayList3);
                ArrayList<Issues.Issue> arrayList5 = new ArrayList<Issues.Issue>();
                this.searchIssuesAndRules(list, string, CRITICAL, arrayList5, hashMap22, arrayList);
                arrayList4.addAll(arrayList5);
                sonarQubeIssuesBreakdown.setCriticalIssues(arrayList5);
                ArrayList<Issues.Issue> arrayList6 = new ArrayList<Issues.Issue>();
                this.searchIssuesAndRules(list, string, MAJOR, arrayList6, hashMap22, arrayList);
                arrayList4.addAll(arrayList6);
                sonarQubeIssuesBreakdown.setMajorIssues(arrayList6);
                ArrayList<Issues.Issue> arrayList7 = new ArrayList<Issues.Issue>();
                this.searchIssuesAndRules(list, string, MINOR, arrayList7, hashMap22, arrayList);
                arrayList4.addAll(arrayList7);
                sonarQubeIssuesBreakdown.setMinorIssues(arrayList7);
                ArrayList<Issues.Issue> arrayList8 = new ArrayList<Issues.Issue>();
                this.searchIssuesAndRules(list, string, INFO, arrayList8, hashMap22, arrayList);
                arrayList4.addAll(arrayList8);
                sonarQubeIssuesBreakdown.setInfoIssues(arrayList8);
                if (!SonarQubeHotspotManager.useHotspotApiEndpoint(this.wsClient.wsConnector().baseUrl(), SonarQubeServerManager.getSonarQubeVersion(this.wsClient))) {
                    this.searchSecurityHotspotsIssues(list, string, arrayList4, hashMap22);
                    hashMap.putAll(this.getIssuesByRule(list, string, SECURITY_HOTSPOT, ""));
                }
                arrayList4.forEach(issue -> arrayList2.add(issue.getKey()));
                sonarQubeIssuesBreakdown.setIssuesKeysList(arrayList2);
                if (ParamsUtils.addBugs(list2)) {
                    sonarQubeIssuesBreakdown.setBlockerBugsIssues(this.getIssuesByType(arrayList3, Common.RuleType.BUG));
                    sonarQubeIssuesBreakdown.setCriticalBugsIssues(this.getIssuesByType(arrayList5, Common.RuleType.BUG));
                    sonarQubeIssuesBreakdown.setMajorBugsIssues(this.getIssuesByType(arrayList6, Common.RuleType.BUG));
                    sonarQubeIssuesBreakdown.setMinorBugsIssues(this.getIssuesByType(arrayList7, Common.RuleType.BUG));
                    sonarQubeIssuesBreakdown.setInfoBugsIssues(this.getIssuesByType(arrayList8, Common.RuleType.BUG));
                    sonarQubeIssuesBreakdown.setBlockerSonarQubeBugsIssuesPerRule(this.getIssuesPerRuleList(hashMap7, hashMap22, arrayList3, list, string));
                    sonarQubeIssuesBreakdown.setCriticalSonarQubeBugsIssuesPerRule(this.getIssuesPerRuleList(hashMap8, hashMap22, arrayList5, list, string));
                    sonarQubeIssuesBreakdown.setMajorSonarQubeBugsIssuesPerRule(this.getIssuesPerRuleList(hashMap9, hashMap22, arrayList6, list, string));
                    sonarQubeIssuesBreakdown.setMinorSonarQubeBugsIssuesPerRule(this.getIssuesPerRuleList(hashMap10, hashMap22, arrayList7, list, string));
                    sonarQubeIssuesBreakdown.setInfoSonarQubeBugsIssuesPerRule(this.getIssuesPerRuleList(hashMap11, hashMap22, arrayList8, list, string));
                }
                if (ParamsUtils.addVulnerabilities(list2)) {
                    sonarQubeIssuesBreakdown.setBlockerVulnerabilitiesIssues(this.getIssuesByType(arrayList3, Common.RuleType.VULNERABILITY));
                    sonarQubeIssuesBreakdown.setCriticalVulnerabilitiesIssues(this.getIssuesByType(arrayList5, Common.RuleType.VULNERABILITY));
                    sonarQubeIssuesBreakdown.setMajorVulnerabilitiesIssues(this.getIssuesByType(arrayList6, Common.RuleType.VULNERABILITY));
                    sonarQubeIssuesBreakdown.setMinorVulnerabilitiesIssues(this.getIssuesByType(arrayList7, Common.RuleType.VULNERABILITY));
                    sonarQubeIssuesBreakdown.setInfoVulnerabilitiesIssues(this.getIssuesByType(arrayList8, Common.RuleType.VULNERABILITY));
                    sonarQubeIssuesBreakdown.setBlockerSonarQubeVulnerabilitiesIssuesPerRule(this.getIssuesPerRuleList(hashMap12, hashMap22, arrayList3, list, string));
                    sonarQubeIssuesBreakdown.setCriticalSonarQubeVulnerabilitiesIssuesPerRule(this.getIssuesPerRuleList(hashMap13, hashMap22, arrayList5, list, string));
                    sonarQubeIssuesBreakdown.setMajorSonarQubeVulnerabilitiesIssuesPerRule(this.getIssuesPerRuleList(hashMap14, hashMap22, arrayList6, list, string));
                    sonarQubeIssuesBreakdown.setMinorSonarQubeVulnerabilitiesIssuesPerRule(this.getIssuesPerRuleList(hashMap15, hashMap22, arrayList7, list, string));
                    sonarQubeIssuesBreakdown.setInfoSonarQubeVulnerabilitiesIssuesPerRule(this.getIssuesPerRuleList(hashMap16, hashMap22, arrayList8, list, string));
                }
                if (ParamsUtils.addCodeSmells(list2)) {
                    sonarQubeIssuesBreakdown.setBlockerCodeSmellsIssues(this.getIssuesByType(arrayList3, Common.RuleType.CODE_SMELL));
                    sonarQubeIssuesBreakdown.setCriticalCodeSmellsIssues(this.getIssuesByType(arrayList5, Common.RuleType.CODE_SMELL));
                    sonarQubeIssuesBreakdown.setMajorCodeSmellsIssues(this.getIssuesByType(arrayList6, Common.RuleType.CODE_SMELL));
                    sonarQubeIssuesBreakdown.setMinorCodeSmellsIssues(this.getIssuesByType(arrayList7, Common.RuleType.CODE_SMELL));
                    sonarQubeIssuesBreakdown.setInfoCodeSmellsIssues(this.getIssuesByType(arrayList8, Common.RuleType.CODE_SMELL));
                    sonarQubeIssuesBreakdown.setBlockerSonarQubeCodeSmellsIssuesPerRule(this.getIssuesPerRuleList(hashMap17, hashMap22, arrayList3, list, string));
                    sonarQubeIssuesBreakdown.setCriticalSonarQubeCodeSmellsIssuesPerRule(this.getIssuesPerRuleList(hashMap18, hashMap22, arrayList5, list, string));
                    sonarQubeIssuesBreakdown.setMajorSonarQubeCodeSmellsIssuesPerRule(this.getIssuesPerRuleList(hashMap19, hashMap22, arrayList6, list, string));
                    sonarQubeIssuesBreakdown.setMinorSonarQubeCodeSmellsIssuesPerRule(this.getIssuesPerRuleList(hashMap20, hashMap22, arrayList7, list, string));
                    sonarQubeIssuesBreakdown.setInfoSonarQubeCodeSmellsIssuesPerRule(this.getIssuesPerRuleList(hashMap21, hashMap22, arrayList8, list, string));
                }
                ArrayList<SonarQubeIssuesPerRule> arrayList9 = new ArrayList<SonarQubeIssuesPerRule>(this.getIssuesPerRuleList(this.sortByValue(hashMap), hashMap22, arrayList4, list, string));
                sonarQubeIssuesBreakdown.setSonarQubeIssuesPerRuleBySeverity(arrayList9);
                List<SonarQubeIssuesPerRule> list3 = arrayList9.stream().sorted(Comparator.comparing(SonarQubeIssuesPerRule::getIssueCount).reversed()).collect(Collectors.toList());
                sonarQubeIssuesBreakdown.setSonarQubeIssuesPerRuleBySize(list3);
                sonarQubeIssuesBreakdown.setIssueList(SonarQubeIssueManager.sortSonarQubeIssuesBySeverity(arrayList4));
                sonarQubeIssuesBreakdown.setRulesObjects(hashMap22);
                sonarQubeIssuesBreakdown.setTotalRulesCount(Long.valueOf(hashMap22.size()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error getting SonarQubeIssueBreakdown, we throw a SonarQubeException");
            throw new SonarQubeException(exception);
        }
        return sonarQubeIssuesBreakdown;
    }

    private static List<SonarQubeIssuesPerRule> sortSonarQubeIssuesPerRuleListBySeverity(List<SonarQubeIssuesPerRule> list) {
        List<Common.Severity> list2 = Arrays.asList(Common.Severity.BLOCKER, Common.Severity.CRITICAL, Common.Severity.MAJOR, Common.Severity.MINOR, Common.Severity.INFO);
        return list.stream().sorted(Comparator.comparing(sonarQubeIssuesPerRule -> list2.indexOf(sonarQubeIssuesPerRule.getSeverity()))).collect(Collectors.toList());
    }

    private static List<Issues.Issue> sortSonarQubeIssuesBySeverity(List<Issues.Issue> list) {
        List<Common.Severity> list2 = Arrays.asList(Common.Severity.BLOCKER, Common.Severity.CRITICAL, Common.Severity.MAJOR, Common.Severity.MINOR, Common.Severity.INFO);
        return list.stream().sorted(Comparator.comparing(issue -> list2.indexOf(issue.getSeverity()))).collect(Collectors.toList());
    }

    private Long getTotalValuesByMap(Map<String, Long> map) {
        return map.values().stream().mapToInt(Long::intValue).sum();
    }

    private List<Issues.Issue> getIssuesByType(List<Issues.Issue> list, Common.RuleType ruleType) {
        ArrayList<Issues.Issue> arrayList = new ArrayList<Issues.Issue>();
        list.forEach(issue -> {
            if (issue.getType().equals(ruleType)) {
                arrayList.add((Issues.Issue)issue);
            }
        });
        return arrayList;
    }

    private List<SonarQubeIssuesPerRule> getIssuesPerRuleList(Map<String, Long> map, Map<String, Common.Rule> map2, List<Issues.Issue> list, List<String> list2, String string) throws SonarQubeException {
        ArrayList<SonarQubeIssuesPerRule> arrayList = new ArrayList<SonarQubeIssuesPerRule>();
        String string2 = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
        map.forEach((string3, l) -> {
            SonarQubeIssuesPerRule sonarQubeIssuesPerRule = new SonarQubeIssuesPerRule();
            sonarQubeIssuesPerRule.setRuleKey((String)string3);
            ArrayList<Issues.Issue> arrayList = new ArrayList<Issues.Issue>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            list.forEach(issue -> {
                if (issue.getRule().equalsIgnoreCase((String)string3) && map2.containsKey(string3)) {
                    String string4;
                    sonarQubeIssuesPerRule.setRuleType(issue.getType());
                    sonarQubeIssuesPerRule.setSeverity(issue.getSeverity());
                    sonarQubeIssuesPerRule.setRuleMessage(((Common.Rule)map2.get(string3)).getName());
                    sonarQubeIssuesPerRule.setRuleLanguage(((Common.Rule)map2.get(string3)).getLang());
                    sonarQubeIssuesPerRule.setRuleLanguageName(((Common.Rule)map2.get(string3)).getLangName());
                    sonarQubeIssuesPerRule.setRuleStatus(((Common.Rule)map2.get(string3)).getStatus());
                    sonarQubeIssuesPerRule.setIssueCount((Long)l);
                    String string5 = string4 = issue.getType() == Common.RuleType.SECURITY_HOTSPOT ? "" : issue.getSeverity().name();
                    if (list2.size() == 1) {
                        sonarQubeIssuesPerRule.setIssuesUrl(SonarQubeURLManager.getIssuesUrlWithSeverity(this.wsClient.wsConnector().baseUrl(), (String)list2.get(0), string2, string3, string, string4));
                    } else {
                        sonarQubeIssuesPerRule.setIssuesUrl(SonarQubeURLManager.getIssuesWithSeverityMultiProjectUrl(this.wsClient.wsConnector().baseUrl(), list2, Collections.emptyList(), string2, string3, string4));
                    }
                    arrayList.add((Issues.Issue)issue);
                    arrayList2.add(issue.getKey());
                }
            });
            sonarQubeIssuesPerRule.setIssueList(arrayList);
            sonarQubeIssuesPerRule.setIssuesKeysList(arrayList2);
            if (ParamsUtils.hasValue(sonarQubeIssuesPerRule.getRuleMessage())) {
                arrayList.add(sonarQubeIssuesPerRule);
            }
        });
        return SonarQubeIssueManager.sortSonarQubeIssuesPerRuleListBySeverity(arrayList);
    }

    protected static String getAuthorFacetsParam(WsClient wsClient) {
        String string = "author";
        try {
            String string2 = SonarQubeServerManager.getSonarQubeVersion(wsClient);
            int n = Integer.parseInt(string2.substring(0, 1));
            int n2 = Integer.parseInt(string2.substring(2, 3));
            if (n <= 6 || n == 7 && n2 <= 6) {
                string = "authors";
            }
        }
        catch (SonarQubeException sonarQubeException) {
            LOGGER.error("Error getting SonarQube version to check author param, reason -> {}", (Object)sonarQubeException.getMessage());
            LOGGER.debug("Error getting SonarQube version to check author param", sonarQubeException);
        }
        return string;
    }

    private Map<String, Long> sortByValue(Map<String, Long> map) {
        return map.entrySet().stream().sorted((entry, entry2) -> ((Long)entry2.getValue()).compareTo((Long)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, l2) -> l, LinkedHashMap::new));
    }
}

