/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;

public class SonarQubeServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeServerManager.class);
    private final WsClient wsClient;
    private static final Map<String, String> CLIENT_VERSIONS_MAP = new HashMap<String, String>();

    public SonarQubeServerManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeServerManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static String getSonarQubeVersion(WsClient wsClient) throws SonarQubeException {
        return new SonarQubeServerManager(wsClient).getSonarQubeVersion();
    }

    protected static boolean isAuthenticationRequired(WsClient wsClient) throws SonarQubeException {
        return new SonarQubeServerManager(wsClient).isAuthenticationRequired();
    }

    public String getSonarQubeVersion() throws SonarQubeException {
        try {
            String string = this.wsClient.wsConnector().baseUrl();
            if (string == null || string.isEmpty()) {
                throw new SonarQubeException("We cannot obtain SonarQube version from null or empty base url");
            }
            if (!CLIENT_VERSIONS_MAP.containsKey(string)) {
                LOGGER.debug("First call to get SonarQube version, we call API...");
                String string2 = this.wsClient.server().version();
                CLIENT_VERSIONS_MAP.put(string, string2);
            } else {
                LOGGER.debug("Client has SonarQube version saved on cache, return cache version");
                LOGGER.debug("SonarQube version: {}", (Object)CLIENT_VERSIONS_MAP.get(string));
            }
            return CLIENT_VERSIONS_MAP.get(string);
        }
        catch (HttpException httpException) {
            LOGGER.debug("Error getting SonarQube version");
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug("Error getting SonarQube version");
            throw new SonarQubeException(String.format("Error getting SonarQube version -> %s", exception.getMessage()), exception);
        }
    }

    public boolean isAuthenticationRequired() throws SonarQubeException {
        try {
            boolean bl = this.wsClient.authentication().validate().contains("false");
            LOGGER.debug("SonarQube authentication required: {}", (Object)bl);
            return bl;
        }
        catch (HttpException httpException) {
            LOGGER.debug("Error checking SonarQube authentication ");
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug("Error checking SonarQube authentication");
            throw new SonarQubeException(String.format("Error checking SonarQube authentication -> %s", exception.getMessage()));
        }
    }
}

