/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Settings;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.settings.ValuesRequest;

public class SonarQubeSettingsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeSettingsManager.class);
    private final WsClient wsClient;

    public SonarQubeSettingsManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeSettingsManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    public String get(String string, String string2) {
        LOGGER.debug("Retrieving setting {} for project key: {}", (Object)string2, (Object)string);
        String string3 = "";
        ValuesRequest valuesRequest = new ValuesRequest();
        valuesRequest.setComponent(string);
        valuesRequest.setKeys(Collections.singletonList(string2));
        Settings.ValuesWsResponse valuesWsResponse = this.wsClient.settings().values(valuesRequest);
        if (valuesWsResponse.getSettingsCount() > 0) {
            for (Settings.Setting setting : valuesWsResponse.getSettingsList()) {
                if (!setting.getKey().equals(string2)) continue;
                string3 = setting.getValue();
                break;
            }
        }
        LOGGER.debug("Done! Setting value retrieved!");
        return string3;
    }

    public String get(String string) {
        LOGGER.debug("Retrieving setting {} from SonarQube server...", (Object)string);
        String string2 = "";
        ValuesRequest valuesRequest = new ValuesRequest();
        valuesRequest.setKeys(Collections.singletonList(string));
        Settings.ValuesWsResponse valuesWsResponse = this.wsClient.settings().values(valuesRequest);
        if (valuesWsResponse.getSettingsCount() > 0) {
            for (Settings.Setting setting : valuesWsResponse.getSettingsList()) {
                if (!setting.getKey().equals(string)) continue;
                string2 = setting.getValue();
            }
        }
        LOGGER.debug("Done! Setting value retrieved!");
        return string2;
    }
}

