/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import java.util.Arrays;
import java.util.List;

public class SonarQubeURLManager {
    public static final String UNRESOLVED_URL_PARAM = "resolved=false";
    public static final String RULES_URL_PARAM = "rules=";
    public static final String OLD_ISSUES_SEARCH_URL_PARAM = "issues/search#";
    private static final String MULTIPROJECT_ISSUES = "issues/search#";
    public static final String PROJECT_UUIDS_URL_PARAM = "projectUuids=";
    public static final String ISSUES_PATH = "issues?";
    private static final String MULTIPROJECT_ISSUES_6_5 = "projectUuids=";
    private static final String MULTIPROJECT_ISSUES_7_9 = "projects=";
    private static final String ISSUES = "component_issues?id=";
    private static final String ISSUES_6_5 = "project/issues?id=";
    private static final String MEASURES = "component_measures";
    private static final String HOTSPOTS = "component_security_hotspots?id=";
    private static final String HOTSPOTS_6_5 = "security_hotspots?id=";
    private static final String SONARCLOUD_HOTSPOTS = "project/security_hotspots?id=";
    public static final String SONARCLOUD_BASE_URL = "https://sonarcloud.io";
    public static final String AUTHORS_URL_PARAM = "authors=";
    public static final String TYPES_URL_PARAM = "types=";
    public static final String SEVERITIES_URL_PARAM = "severities=";

    private SonarQubeURLManager() {
    }

    public static String getIssuesUrl(String string, String string2, String string3, String string4) {
        return SonarQubeURLManager.getIssuesUrl(string, string2, string3, string4, "");
    }

    public static String getIssuesUrl(String string, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append(ISSUES).append(string2).append("#");
        } else {
            stringBuilder.append(ISSUES_6_5).append(string2).append("&");
        }
        stringBuilder.append("resolved=false&rules=").append(string4);
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string5));
        return stringBuilder.toString();
    }

    public static String getIssuesUrlWithSeverity(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append(ISSUES).append(string2).append("#");
        } else {
            stringBuilder.append(ISSUES_6_5).append(string2).append("&");
        }
        stringBuilder.append("resolved=false&rules=").append(string4);
        if (string6 != null && !string6.isEmpty()) {
            stringBuilder.append("&").append(SEVERITIES_URL_PARAM).append(string6);
        }
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string5));
        return stringBuilder.toString();
    }

    public static String getHotSpotsUrl(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarCloud(string)) {
            stringBuilder.append(SONARCLOUD_HOTSPOTS).append(string2);
        } else if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append(HOTSPOTS).append(string2);
        } else if (SonarQubeURLManager.isSonarQube7X(string3)) {
            stringBuilder.append(ISSUES_6_5).append(string2).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(TYPES_URL_PARAM).append("SECURITY_HOTSPOT");
        } else {
            stringBuilder.append(HOTSPOTS_6_5).append(string2);
        }
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string4));
        return stringBuilder.toString();
    }

    public static String getIssuesUrlByType(String string, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append(ISSUES).append(string2).append("#");
        } else {
            stringBuilder.append(ISSUES_6_5).append(string2).append("&");
        }
        stringBuilder.append("resolved=false&types=").append(string4);
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string5));
        return stringBuilder.toString();
    }

    public static String getIssuesMultiProjectUrl(String string, List<String> list, List<String> list2, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        String string4 = String.join((CharSequence)",", list2);
        String string5 = String.join((CharSequence)",", list);
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string2)) {
            stringBuilder.append("issues/search#").append("projectUuids=").append(string4).append("|").append(UNRESOLVED_URL_PARAM).append("|").append(RULES_URL_PARAM).append(string3);
        } else if (string2.startsWith("6.4") || string2.startsWith("6.5") || string2.startsWith("6.6") || string2.startsWith("6.7")) {
            stringBuilder.append(ISSUES_PATH).append("projectUuids=").append(string4).append("&resolved=false&rules=").append(string3);
        } else {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string5).append("&resolved=false&rules=").append(string3);
        }
        return stringBuilder.toString();
    }

    public static String getIssuesWithSeverityMultiProjectUrl(String string, List<String> list, List<String> list2, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        String string5 = String.join((CharSequence)",", list2);
        String string6 = String.join((CharSequence)",", list);
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string2)) {
            stringBuilder.append("issues/search#").append("projectUuids=").append(string5).append("|").append(UNRESOLVED_URL_PARAM).append("|").append(RULES_URL_PARAM).append(string3);
        } else if (string2.startsWith("6.4") || string2.startsWith("6.5") || string2.startsWith("6.6") || string2.startsWith("6.7")) {
            stringBuilder.append(ISSUES_PATH).append("projectUuids=").append(string5).append("&resolved=false&rules=").append(string3);
        } else {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string6).append("&resolved=false&rules=").append(string3);
        }
        if (string4 != null && !string4.isEmpty()) {
            stringBuilder.append("&").append(SEVERITIES_URL_PARAM).append(string4);
        }
        return stringBuilder.toString();
    }

    public static String getBugsUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getBugsUrl(string, string2, string3, "");
    }

    public static String getBugsUrl(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append(ISSUES).append(string2).append("#").append(UNRESOLVED_URL_PARAM).append("|");
        } else {
            stringBuilder.append(ISSUES_6_5).append(string2).append("&").append(UNRESOLVED_URL_PARAM).append("&");
        }
        stringBuilder.append("types=BUG");
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string4));
        return stringBuilder.toString();
    }

    public static String getVulnerabilitiesUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getVulnerabilitiesUrl(string, string2, string3, "");
    }

    public static String getVulnerabilitiesUrl(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append(ISSUES).append(string2).append("#").append(UNRESOLVED_URL_PARAM).append("|");
        } else {
            stringBuilder.append(ISSUES_6_5).append(string2).append("&").append(UNRESOLVED_URL_PARAM).append("&");
        }
        stringBuilder.append("types=VULNERABILITY");
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string4));
        return stringBuilder.toString();
    }

    public static String getCodeSmellsUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getCodeSmellsUrl(string, string2, string3, "");
    }

    public static String getCodeSmellsUrl(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append(ISSUES).append(string2).append("#").append(UNRESOLVED_URL_PARAM).append("|");
        } else {
            stringBuilder.append(ISSUES_6_5).append(string2).append("&").append(UNRESOLVED_URL_PARAM).append("&");
        }
        stringBuilder.append("types=CODE_SMELL");
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string4));
        return stringBuilder.toString();
    }

    public static String getMeasureUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getMeasureUrl(string, string2, string3, "");
    }

    public static String getMeasureUrl(String string, String string2, String string3, String string4) {
        return SonarQubeURLManager.addUrlForwardSlash(string) + MEASURES + "?id=" + string2 + "&metric=" + string3 + "&view=list" + SonarQubeURLManager.addBranchParameter(string4);
    }

    public static String getProjectUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getProjectUrl(string, string2, string3, "");
    }

    public static String getProjectUrl(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append("overview?id=");
        } else {
            stringBuilder.append("dashboard?id=");
        }
        stringBuilder.append(string2);
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string4));
        return stringBuilder.toString();
    }

    public static String getTotalIssuesByAuthorUrl(String string, String string2, List<String> list, List<String> list2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        String string4 = String.join((CharSequence)",", list2);
        String string5 = String.join((CharSequence)",", list);
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append("issues/search#").append("projectUuids=").append(string4).append("|").append(UNRESOLVED_URL_PARAM).append("|").append(AUTHORS_URL_PARAM).append(string2);
        } else if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
            stringBuilder.append(ISSUES_PATH).append("projectUuids=").append(string4).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2);
        } else if (string3.startsWith("9.")) {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string5).append("&").append(UNRESOLVED_URL_PARAM).append(SonarQubeURLManager.getAuthorsParameterForSonarQube9x(string2));
        } else if (SonarQubeURLManager.isSonarCloud(string)) {
            stringBuilder.append(ISSUES_6_5).append(string5).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2);
        } else {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string5).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getTotalIssuesByAuthorAndSeverityUrl(String string, List<String> list, List<String> list2, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        String string5 = String.join((CharSequence)",", list2);
        String string6 = String.join((CharSequence)",", list);
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append("issues/search#").append("projectUuids=").append(string5).append("|").append(UNRESOLVED_URL_PARAM).append("|").append(AUTHORS_URL_PARAM).append(string2).append("|").append(SEVERITIES_URL_PARAM).append(string4);
        } else if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
            stringBuilder.append(ISSUES_PATH).append("projectUuids=").append(string5).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(SEVERITIES_URL_PARAM).append(string4);
        } else if (string3.startsWith("9.")) {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string6).append("&").append(UNRESOLVED_URL_PARAM).append(SonarQubeURLManager.getAuthorsParameterForSonarQube9x(string2)).append("&").append(SEVERITIES_URL_PARAM).append(string4);
        } else if (SonarQubeURLManager.isSonarCloud(string)) {
            stringBuilder.append(ISSUES_6_5).append(string6).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(SEVERITIES_URL_PARAM).append(string4);
        } else {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string6).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(SEVERITIES_URL_PARAM).append(string4);
        }
        return stringBuilder.toString();
    }

    public static String getTotalIssuesByAuthorAndTypeUrl(String string, List<String> list, List<String> list2, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        String string5 = String.join((CharSequence)",", list2);
        String string6 = String.join((CharSequence)",", list);
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append("issues/search#").append("projectUuids=").append(string5).append("|").append(UNRESOLVED_URL_PARAM).append("|").append(AUTHORS_URL_PARAM).append(string2).append("|").append(TYPES_URL_PARAM).append(string4);
        } else if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
            stringBuilder.append(ISSUES_PATH).append("projectUuids=").append(string5).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(TYPES_URL_PARAM).append(string4);
        } else if (string3.startsWith("9.")) {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string6).append("&").append(UNRESOLVED_URL_PARAM).append(SonarQubeURLManager.getAuthorsParameterForSonarQube9x(string2)).append("&").append(TYPES_URL_PARAM).append(string4);
        } else if (SonarQubeURLManager.isSonarCloud(string)) {
            stringBuilder.append(ISSUES_6_5).append(string6).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(TYPES_URL_PARAM).append(string4);
        } else {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string6).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(TYPES_URL_PARAM).append(string4);
        }
        return stringBuilder.toString();
    }

    public static String getIssuesByAuthorUrl(String string, List<String> list, List<String> list2, String string2, String string3, String string4, String string5, String string6, String string7) {
        StringBuilder stringBuilder = new StringBuilder(SonarQubeURLManager.addUrlForwardSlash(string));
        String string8 = String.join((CharSequence)",", list2);
        String string9 = String.join((CharSequence)",", list);
        if (SonarQubeURLManager.isSonarQubeVersionMinorThan6Dot4(string3)) {
            stringBuilder.append("issues/search#").append("projectUuids=").append(string8).append("|").append(UNRESOLVED_URL_PARAM).append("|").append(AUTHORS_URL_PARAM).append(string2).append("|").append(SEVERITIES_URL_PARAM).append(string5).append("|").append(TYPES_URL_PARAM).append(string4).append("|").append(RULES_URL_PARAM).append(string6);
        } else if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
            stringBuilder.append(ISSUES_PATH).append("projectUuids=").append(string8).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(SEVERITIES_URL_PARAM).append(string5).append("&").append(TYPES_URL_PARAM).append(string4).append("&").append(RULES_URL_PARAM).append(string6);
        } else if (string3.startsWith("9.")) {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string9).append("&").append(UNRESOLVED_URL_PARAM).append(SonarQubeURLManager.getAuthorsParameterForSonarQube9x(string2)).append("&").append(SEVERITIES_URL_PARAM).append(string5).append("&").append(TYPES_URL_PARAM).append(string4).append("&").append(RULES_URL_PARAM).append(string6);
        } else if (SonarQubeURLManager.isSonarCloud(string)) {
            stringBuilder.append(ISSUES_6_5).append(string9).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(SEVERITIES_URL_PARAM).append(string5).append("&").append(TYPES_URL_PARAM).append(string4).append("&").append(RULES_URL_PARAM).append(string6);
        } else {
            stringBuilder.append(ISSUES_PATH).append(MULTIPROJECT_ISSUES_7_9).append(string9).append("&").append(UNRESOLVED_URL_PARAM).append("&").append(AUTHORS_URL_PARAM).append(string2).append("&").append(SEVERITIES_URL_PARAM).append(string5).append("&").append(TYPES_URL_PARAM).append(string4).append("&").append(RULES_URL_PARAM).append(string6);
        }
        stringBuilder.append(SonarQubeURLManager.addBranchParameter(string7));
        return stringBuilder.toString();
    }

    private static String getAuthorsParameterForSonarQube9x(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = Arrays.asList(string2.split(","));
        list.forEach(string -> stringBuilder.append("&author=").append((String)string));
        return stringBuilder.toString();
    }

    private static String addUrlForwardSlash(String string) {
        if (string == null || string.isEmpty()) {
            return "/";
        }
        if (!string.endsWith("/")) {
            return string + "/";
        }
        return string;
    }

    private static boolean isSonarQubeVersionMinorThan6Dot4(String string) {
        return string.startsWith("5.") || string.startsWith("6.3") || string.startsWith("6.2") || string.startsWith("6.1") || string.startsWith("6.0");
    }

    private static String addBranchParameter(String string) {
        if (string != null && !string.isEmpty()) {
            return "&branch=" + string;
        }
        return "";
    }

    public static boolean isSonarCloud(String string) {
        return string != null && string.startsWith(SONARCLOUD_BASE_URL);
    }

    private static boolean isSonarQube7X(String string) {
        return string != null && string.startsWith("7.");
    }
}

