/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.utils;

import es.sonarqube.model.CoverageSVGParams;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVGUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVGUtils.class);
    public static final String BRANCH = "<svg viewBox=\"0 0 16 16\" height=\"18\" width=\"18\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\"><path d=\"M12.5 6.5c0-1.1-.9-2-2-2s-2 .9-2 2c0 .8.5 1.5 1.2 1.8-.3.6-.7 1.1-1.2 1.4-.9.5-1.9.5-2.5.4V4c.9-.2 1.5-1 1.5-1.9 0-1.1-.9-2-2-2s-2 .9-2 2C3.5 3 4.1 3.8 5 4v8c-.9.2-1.5 1-1.5 1.9 0 1.1.9 2 2 2s2-.9 2-2c0-.9-.6-1.7-1.5-1.9v-1c.2 0 .5.1.7.1.7 0 1.5-.1 2.2-.6.8-.5 1.4-1.2 1.7-2.1 1.1 0 1.9-.9 1.9-1.9zm-8-4.4c0-.6.4-1 1-1s1 .4 1 1-.4 1-1 1-1-.5-1-1zm2 11.9c0 .6-.4 1-1 1s-1-.4-1-1 .4-1 1-1 1 .4 1 1zm4-6.5c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>";
    private static final String BLOCKER = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\"><path d=\"M8 14c-3.311 0-6-2.689-6-6s2.689-6 6-6 6 2.689 6 6-2.689 6-6 6zM7 9h2V4H7v5zm0 3h2v-2H7v2z\" style=\"fill: rgb(212, 51, 63);fill-rule: nonzero;\"></path></svg>";
    private static final String CRITICAL = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\"><path d=\"M8 2c3.311 0 6 2.689 6 6s-2.689 6-6 6-6-2.689-6-6 2.689-6 6-6zm1 10V7.414l1.893 1.893c.13.124.282.216.457.261a1.006 1.006 0 0 0 1.176-.591 1.01 1.01 0 0 0 .01-.729 1.052 1.052 0 0 0-.229-.355c-1.212-1.212-2.394-2.456-3.638-3.636a1.073 1.073 0 0 0-.169-.123 1.05 1.05 0 0 0-.448-.133h-.104a1.053 1.053 0 0 0-.493.16 1.212 1.212 0 0 0-.162.132C6.08 5.505 4.836 6.687 3.656 7.932a.994.994 0 0 0-.051 1.275c.208.271.548.42.888.389.198-.019.378-.098.535-.218.041-.035.04-.034.079-.071L7 7.414V12h2z\" style=\"fill: rgb(212, 51, 63); fill-rule: nonzero;\"></path></svg>";
    private static final String MAJOR = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 2c3.311 0 6 2.689 6 6s-2.689 6-6 6-6-2.689-6-6 2.689-6 6-6zm.08 2.903c.071.008.14.019.208.039.138.042.26.114.37.205 1.244 1.146 2.426 2.357 3.639 3.536.1.103.181.218.234.352a1.01 1.01 0 0 1 .001.728 1.002 1.002 0 0 1-1.169.609 1.042 1.042 0 0 1-.46-.255L8 7.295l-2.903 2.822c-.039.036-.039.036-.08.07a1.002 1.002 0 0 1-1.604-.947c.032-.196.122-.37.253-.519C4.847 7.51 6.09 6.362 7.303 5.183c.052-.048.106-.093.167-.131a1.041 1.041 0 0 1 .61-.149z\" style=\"fill: rgb(212, 51, 63);\"></path></svg>";
    private static final String MINOR = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 2c3.311 0 6 2.689 6 6s-2.689 6-6 6-6-2.689-6-6 2.689-6 6-6zm1 6.586V4H7v4.586L5.107 6.693a1.178 1.178 0 0 0-.165-.134 1.041 1.041 0 0 0-.662-.152 1 1 0 0 0-.587 1.7c1.212 1.212 2.394 2.456 3.638 3.636.094.08.195.146.311.191a1.008 1.008 0 0 0 1.065-.227c1.213-1.212 2.457-2.394 3.637-3.639a.994.994 0 0 0 .051-1.275 1.012 1.012 0 0 0-.888-.389 1.041 1.041 0 0 0-.535.218c-.04.034-.04.034-.079.071L9 8.586z\" style=\"fill: rgb(176, 213, 19);\"></path></svg>";
    private static final String INFO = "<svg height=\"%s\" width=\"%s\"viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 2c3.311 0 6 2.689 6 6s-2.689 6-6 6-6-2.689-6-6 2.689-6 6-6zm1 5H7v5h2V7zm0-3H7v2h2V4z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>";
    private static final String BUG = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M10.09,1.88A2.86,2.86,0,0,0,8,1a2.87,2.87,0,0,0-2.11.87A2.93,2.93,0,0,0,5,4h6A2.93,2.93,0,0,0,10.09,1.88Z\" style=\"fill: currentcolor;\"></path><path d=\"M14.54,9H13V5.6L14.3,4.42a.5.5,0,0,0,0-.71.49.49,0,0,0-.7,0L12.17,5H3.82L2.34,3.66a.5.5,0,0,0-.67.74L2.94,5.55V9H1.46a.5.5,0,0,0,0,1H3a5.2,5.2,0,0,0,1.05,2.32l-2,1.81a.5.5,0,1,0,.67.74l2-1.82A4.62,4.62,0,0,0,7,14.1V8A1,1,0,0,1,8,7a.94.94,0,0,1,1,.9v6.17A4.55,4.55,0,0,0,11.18,13l2,1.83a.51.51,0,0,0,.33.13.48.48,0,0,0,.37-.17.49.49,0,0,0,0-.7l-2-1.8a5.34,5.34,0,0,0,1-2.29h1.64a.5.5,0,0,0,0-1Z\" style=\"fill: currentcolor;\"></path></svg>";
    private static final String VULNERABILITY = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M12,7.05H6V5a2,2,0,1,1,4,0,1,1,0,0,0,2,0A4,4,0,1,0,4,5V7.06A1.12,1.12,0,0,0,3,8.17V14a1.12,1.12,0,0,0,1.12,1.12H12A1.12,1.12,0,0,0,13.1,14V8.17A1.12,1.12,0,0,0,12,7.05ZM8,13a2,2,0,1,1,2-2A2,2,0,0,1,8,13Z\" style=\"fill: currentcolor;\"></path></svg>";
    private static final String SECURITY_HOTSPOT = "<svg height=\"%s\"  width=\"%s\" viewBox=\"0 0 16 16\" xml:space=\"preserve\" style=\"fill-rule: evenodd;clip-rule: evenodd;stroke-linejoin: round;stroke-miterlimit: 1.41421;\"><path d=\"M14.08 3.23a1 1 0 00-.67-.77L8.16 1a1.06 1.06 0 00-.5 0L2.41 2.46a.94.94 0 00-.67.77c-.08.57-.74 5.63 1.14 8.31A9 9 0 007.68 15a.85.85 0 00.23 0 .78.78 0 00.22 0 8.93 8.93 0 004.81-3.46c1.85-2.68 1.21-7.74 1.14-8.31zM12.21 8a6.15 6.15 0 01-.86 2.42A7.92 7.92 0 018 13V8zM8 3v5H3.59a24.29 24.29 0 010-3.82z\" style=\"fill: currentcolor;\"></path></svg>";
    private static final String CODE_SMELL = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8,15.1a7,7,0,1,0-7-7A7,7,0,0,0,8,15.1Zm.74-8.9,1.46-2.52a.29.29,0,0,1,.25-.14.3.3,0,0,1,.15,0,5.26,5.26,0,0,1,2.61,4.53.28.28,0,0,1-.29.29H10a.28.28,0,0,1-.29-.29,1.78,1.78,0,0,0-.88-1.51A.29.29,0,0,1,8.75,6.2Zm.11,3.44A.23.23,0,0,1,9,9.6a.29.29,0,0,1,.25.14l1.46,2.52a.18.18,0,0,1,0,.13.3.3,0,0,1-.15.27,5.3,5.3,0,0,1-5.23,0,.3.3,0,0,1-.1-.4L6.73,9.74A.29.29,0,0,1,7,9.6a.23.23,0,0,1,.14,0A1.79,1.79,0,0,0,8.86,9.64ZM5.33,3.59a.3.3,0,0,1,.41.1L7.2,6.21a.29.29,0,0,1-.1.4,1.79,1.79,0,0,0-.87,1.51.28.28,0,0,1-.29.29H3a.32.32,0,0,1-.32-.29A5.26,5.26,0,0,1,5.33,3.59Z\" style=\"fill: currentcolor;\"></path></svg>";
    private static final String DUPLICATION_RATING_A = "<svg height=\"%s\" viewBox=\"0 0 34 34\" width=\"%s\"><circle cx=\"17\" cy=\"17\" fill=\"#00aa00\" r=\"5.667\"></circle><path d=\"M15.181 2.135c0 1.08.803 1.973 1.844 2.115 5.325.01 9.884 3.285 11.782 7.93v-.004a2.135 2.135 0 004.086-.87h.13C30.707 4.788 24.524.1 17.233.003a2.135 2.135 0 00-2.052 2.133zM13.59.342a4.12 4.12 0 00-.408 1.793c0 .926.305 1.78.819 2.47C8.406 5.955 4.25 10.992 4.25 17c0 7.042 5.708 12.75 12.75 12.75S29.75 24.042 29.75 17c0-.58-.039-1.152-.114-1.712.357.1.733.154 1.122.154 1.183 0 2.25-.497 3.004-1.294.157.928.238 1.88.238 2.852 0 9.389-7.611 17-17 17S0 26.389 0 17C0 8.78 5.835 1.922 13.589.342z\" fill=\"#e6e6e6\"></path> <path d=\"M32.642 10.303C29.9 3.753 23.264.054 17.367 0h-.13v.001a2.135 2.135 0 000 4.267v.002c7.72.2 10.792 6.058 11.57 7.907a2.135 2.135 0 103.835-1.874z\" fill=\"#00aa00\"></path></svg>";
    private static final String DUPLICATION_RATING_B = "<svg height=\"%s\" viewBox=\"0 0 34 34\" width=\"%s\"><circle cx=\"17\" cy=\"17\" fill=\"#b0d513\" r=\"5.667\"></circle><path d=\"M13.245.416C5.663 2.126 0 8.902 0 17c0 9.389 7.611 17 17 17 3.193 0 6.18-.88 8.733-2.411a4.11 4.11 0 01-1.446-.98 4.107 4.107 0 01-1.122-2.446A12.692 12.692 0 0117 29.75C9.958 29.75 4.25 24.042 4.25 17c0-5.919 4.033-10.896 9.502-12.332a4.107 4.107 0 01-.877-2.543 4.1 4.1 0 01.37-1.709zm15.493 28.88A16.951 16.951 0 0034 17c0-9.389-7.611-17-17-17a2.125 2.125 0 000 4.25c7.042 0 12.75 5.708 12.75 12.75 0 3.628-1.515 6.901-3.947 9.223a2.125 2.125 0 102.935 3.074z\"  fill=\"#e6e6e6\"></path> <path d=\"M14.875 2.125C14.875.951 15.826 0 17 0c9.389 0 17 7.611 17 17 0 4.836-2.022 9.204-5.262 12.297a2.125 2.125 0 01-2.935-3.074A12.708 12.708 0 0029.75 17c0-7.042-5.708-12.75-12.75-12.75a2.125 2.125 0 01-2.125-2.125z\" fill=\"#b0d513\"></path></svg>";
    private static final String DUPLICATION_RATING_C = "<svg height=\"%s\" viewBox=\"0 0 34 34\" width=\"%s\"><circle cx=\"17\" cy=\"17\" fill=\"#eabe06\" r=\"5.667\"></circle><path d=\"M14.875 2.125c0 1.174.951 2.125 2.125 2.125 7.042 0 12.75 5.708 12.75 12.75S24.042 29.75 17 29.75c-3.474 0-6.623-1.39-8.923-3.643a2.125 2.125 0 00-2.985 3.026A16.945 16.945 0 0017 34c9.389 0 17-7.611 17-17S26.389 0 17 0a2.125 2.125 0 00-2.125 2.125zM2.712 26.215a4.11 4.11 0 01.931-1.477 4.107 4.107 0 012.407-1.203A12.691 12.691 0 014.25 17c0-5.919 4.033-10.896 9.502-12.332a4.107 4.107 0 01-.877-2.543c0-.61.132-1.188.37-1.709C5.662 2.126 0 8.902 0 17c0 3.396.996 6.56 2.712 9.215z\"  fill=\"#e6e6e6\"></path> <path d=\"M14.875 2.125C14.875.951 15.826 0 17 0c9.389 0 17 7.611 17 17s-7.611 17-17 17a16.952 16.952 0 01-11.898-4.857 2.125 2.125 0 012.975-3.036A12.702 12.702 0 0017 29.75c7.042 0 12.75-5.708 12.75-12.75S24.042 4.25 17 4.25a2.125 2.125 0 01-2.125-2.125z\" fill=\"#eabe06\"></path></svg>";
    private static final String DUPLICATION_RATING_D = "<svg height=\"%s\" viewBox=\"0 0 34 34\" width=\"%s\"> <circle cx=\"17\" cy=\"17\" fill=\"#ed7d20\" r=\"5.667\"></circle> <path d=\"M13.245.416A17.024 17.024 0 00.415 13.245a4.11 4.11 0 011.709-.37c.96 0 1.842.327 2.543.877a12.773 12.773 0 019.084-9.084 4.107 4.107 0 01-.877-2.543c0-.61.132-1.188.37-1.709zM0 17c0 9.389 7.611 17 17 17s17-7.611 17-17S26.389 0 17 0a2.125 2.125 0 000 4.25c7.042 0 12.75 5.708 12.75 12.75S24.042 29.75 17 29.75 4.25 24.042 4.25 17A2.125 2.125 0 000 17z\"  fill=\"#e6e6e6\"></path> <path d=\"M14.875 2.125C14.875.951 15.826 0 17 0c9.389 0 17 7.611 17 17s-7.611 17-17 17S0 26.389 0 17a2.125 2.125 0 014.25 0c0 7.042 5.708 12.75 12.75 12.75S29.75 24.042 29.75 17 24.042 4.25 17 4.25a2.125 2.125 0 01-2.125-2.125z\" fill=\"#ed7d20\"></path></svg>";
    private static final String DUPLICATION_RATING_E = "<svg height=\"%s\" viewBox=\"0 0 34 34\" width=\"%s\"><circle cx=\"17\" cy=\"17\" fill=\"#d4333f\" r=\"5.667\"></circle><path d=\"M13.458 2.125c0 .903.282 1.74.762 2.429C8.515 5.822 4.25 10.914 4.25 17c0 7.042 5.708 12.75 12.75 12.75S29.75 24.042 29.75 17c0-6.804-5.33-12.363-12.042-12.73v-.02a2.125 2.125 0 01-.184-4.242 2.148 2.148 0 01.568.026C26.972.597 34 7.978 34 17c0 9.389-7.611 17-17 17S0 26.389 0 17C0 8.679 5.979 1.754 13.875.287a4.232 4.232 0 00-.417 1.838z\"  fill=\"#d4333f\"></path></svg>";
    private static final String DEFAULT_SEVERITY_ICON_WIDTH = "16";
    private static final String DEFAULT_SEVERITY_ICON_HEIGHT = "16";
    private static final String DEFAULT_DUPLICATION_ICON_WIDTH = "40";
    private static final String DEFAULT_DUPLICATION_ICON_HEIGHT = "40";
    private static final String ISSUE_STATUS_OPEN = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>";
    private static final String ISSUE_STATUS_CONFIRMED = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M10 8c0 .552-.195 1.023-.586 1.414-.39.39-.862.586-1.414.586a1.926 1.926 0 0 1-1.414-.586A1.928 1.928 0 0 1 6 8c0-.552.195-1.023.586-1.414C6.976 6.196 7.448 6 8 6c.552 0 1.023.195 1.414.586.39.39.586.862.586 1.414zM8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>";
    private static final String ISSUE_STATUS_REOPENED = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 12.25v-8.5c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>";
    private static final String ISSUE_STATUS_RESOLVED = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M12.03 6.734a.49.49 0 0 0-.14-.36l-.71-.702a.48.48 0 0 0-.352-.15.474.474 0 0 0-.35.15l-3.19 3.18-1.765-1.766a.479.479 0 0 0-.35-.15.479.479 0 0 0-.353.15l-.71.703a.482.482 0 0 0-.14.358c0 .14.046.258.14.352l2.828 2.828c.098.1.216.15.35.15.142 0 .26-.05.36-.15l4.243-4.242a.475.475 0 0 0 .14-.352l-.001.001zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(51, 51, 51);\"></path></svg>";
    private static final String ISSUE_STATUS_CLOSED = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(51, 51, 51);\"></path></svg>";
    private static final String ISSUE_STATUS_TO_REVIEW = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>";
    private static final String ISSUE_STATUS_IN_REVIEW = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M10 8c0 .552-.195 1.023-.586 1.414-.39.39-.862.586-1.414.586a1.926 1.926 0 0 1-1.414-.586A1.928 1.928 0 0 1 6 8c0-.552.195-1.023.586-1.414C6.976 6.196 7.448 6 8 6c.552 0 1.023.195 1.414.586.39.39.586.862.586 1.414zM8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>";
    private static final String ISSUE_STATUS_REVIEWED = "<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M12.03 6.734a.49.49 0 0 0-.14-.36l-.71-.702a.48.48 0 0 0-.352-.15.474.474 0 0 0-.35.15l-3.19 3.18-1.765-1.766a.479.479 0 0 0-.35-.15.479.479 0 0 0-.353.15l-.71.703a.482.482 0 0 0-.14.358c0 .14.046.258.14.352l2.828 2.828c.098.1.216.15.35.15.142 0 .26-.05.36-.15l4.243-4.242a.475.475 0 0 0 .14-.352l-.001.001zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(51, 51, 51);\"></path></svg>";
    private static final String DEFAULT_ISSUE_STATUS_ICON_WIDTH = "16";
    private static final String DEFAULT_ISSUE_STATUS_ICON_HEIGHT = "16";
    private static final double DEFAULT_COVERAGE_SVG_SIZE = 40.0;
    private static final String DEFAULT_MEASURE_VALUE = "-";
    private static final String DEFAULT_COVERAGE_MAIN_COLOR = "00aa00";
    private static final String DEFAULT_COVERAGE_SECONDARY_COLOR = "a4030f";
    private static final String DEFAULT_COVERAGE_GAP_COLOR = "f6f8fa";
    private static final int ALL_ANGLE_CIRCLE = 360;
    private static final int ANGLE = 90;
    private static SVGUtils instance;

    public static SVGUtils getInstance() {
        if (instance == null) {
            instance = new SVGUtils();
        }
        return instance;
    }

    private SVGUtils() {
    }

    public String getIconBySeverity(String string) {
        return this.getIconBySeverity(string, "16", "16");
    }

    public String getIconBySeverity(String string, String string2, String string3) {
        if ("BLOCKER".equalsIgnoreCase(string)) {
            return String.format(BLOCKER, string2, string3);
        }
        if ("CRITICAL".equalsIgnoreCase(string)) {
            return String.format(CRITICAL, string2, string3);
        }
        if ("MAJOR".equalsIgnoreCase(string)) {
            return String.format(MAJOR, string2, string3);
        }
        if ("MINOR".equalsIgnoreCase(string)) {
            return String.format(MINOR, string2, string3);
        }
        if ("INFO".equalsIgnoreCase(string)) {
            return String.format(INFO, string2, string3);
        }
        return "";
    }

    public String getIconByType(String string, String string2, String string3) {
        if ("BUG".equalsIgnoreCase(string)) {
            return String.format(BUG, string2, string3);
        }
        if ("VULNERABILITY".equalsIgnoreCase(string)) {
            return String.format(VULNERABILITY, string2, string3);
        }
        if ("SECURITY_HOTSPOT".equalsIgnoreCase(string)) {
            return String.format(SECURITY_HOTSPOT, string2, string3);
        }
        if ("CODE_SMELL".equalsIgnoreCase(string)) {
            return String.format(CODE_SMELL, string2, string3);
        }
        return "";
    }

    public String getDuplicateRatingIcon(String string) {
        return this.getDuplicateRatingIcon(string, "40", "40");
    }

    public String getDuplicateRatingIcon(String string, String string2, String string3) {
        if ("A".equals(string)) {
            return String.format(DUPLICATION_RATING_A, string3, string2);
        }
        if ("B".equals(string)) {
            return String.format(DUPLICATION_RATING_B, string3, string2);
        }
        if ("C".equals(string)) {
            return String.format(DUPLICATION_RATING_C, string3, string2);
        }
        if ("D".equals(string)) {
            return String.format(DUPLICATION_RATING_D, string3, string2);
        }
        if ("E".equals(string)) {
            return String.format(DUPLICATION_RATING_E, string3, string2);
        }
        return "";
    }

    public String getCoverageSVG(double d2) {
        return this.getCoverageSVG(d2, 40.0);
    }

    public String getCoverageSVG(String string, String string2) {
        return this.getCoverageSVG(this.coverageStringToDouble(string), Double.parseDouble(string2));
    }

    public String getCoverageSVG(String string, double d2) {
        return this.getCoverageSVG(this.coverageStringToDouble(string), d2);
    }

    public String getCoverageSVG(String string) {
        return this.getCoverageSVG(this.coverageStringToDouble(string), 40.0);
    }

    public String getCoverageSVG(double d2, double d3) {
        return this.getCoverageSVG(d2, d3, DEFAULT_COVERAGE_MAIN_COLOR, DEFAULT_COVERAGE_SECONDARY_COLOR, DEFAULT_COVERAGE_GAP_COLOR);
    }

    public String getCoverageSVG(double d2, double d3, String string, String string2, String string3) {
        string3 = d2 == 0.0 || d2 == 100.0 ? "transparent" : string3;
        CoverageSVGParams coverageSVGParams = new CoverageSVGParams(d2, d3);
        return "<svg width=\"" + d3 + "\" height=\"" + d3 + "\">" + this.getPath(coverageSVGParams, string2, coverageSVGParams.getStrokeWidth(), coverageSVGParams.getTotal(), false, 0.0) + this.getPath(coverageSVGParams, string, coverageSVGParams.getStrokeWidth(), coverageSVGParams.getSVGValue(), true, 90.0) + this.getPath(coverageSVGParams, string3, coverageSVGParams.getStrokeGapWidth(), coverageSVGParams.getGapWidth(), true, -270.0) + this.getPath(coverageSVGParams, string3, coverageSVGParams.getStrokeGapWidth(), coverageSVGParams.getGapWidth(), true, this.getRotationValue(coverageSVGParams.getValue())) + "</svg>";
    }

    private String getPath(CoverageSVGParams coverageSVGParams, String string, Double d2, Double d3, boolean bl, Double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<path");
        stringBuilder.append(" d=\"M %s,%s a %s,%s 0 0,1 %s,0 a %s,%s 0 0,1 -%s,0\"");
        stringBuilder.append(" fill=\"none\"");
        stringBuilder.append(" stroke=\"#%s\"");
        stringBuilder.append(" stroke-width=\"%s\"");
        stringBuilder.append(" stroke-dasharray=\"%s %s\"");
        if (bl) {
            stringBuilder.append(" transform=\"rotate(%s %s %s)\"");
        }
        stringBuilder.append(" />");
        return String.format(stringBuilder.toString(), coverageSVGParams.getEllipticalArc(), coverageSVGParams.getCoordinate(), coverageSVGParams.getRadio(), coverageSVGParams.getRadio(), coverageSVGParams.getRadio() * 2.0, coverageSVGParams.getRadio(), coverageSVGParams.getRadio(), coverageSVGParams.getRadio() * 2.0, string, d2, d3, coverageSVGParams.getTotal(), d4, coverageSVGParams.getCoordinate(), coverageSVGParams.getCoordinate());
    }

    private double getRotationValue(double d2) {
        return 360.0 * d2 / 100.0 - 90.0 + 180.0;
    }

    public String getBranchIcon() {
        return BRANCH;
    }

    public String getIssueStatusIcon(String string) {
        return this.getIssueStatusIcon(string, "16", "16");
    }

    public String getIssueStatusIcon(String string, String string2, String string3) {
        if ("OPEN".equals(string)) {
            return String.format("<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>", string2, string3);
        }
        if ("REOPENED".equals(string)) {
            return String.format(ISSUE_STATUS_REOPENED, string2, string3);
        }
        if ("CLOSED".equals(string)) {
            return String.format(ISSUE_STATUS_CLOSED, string2, string3);
        }
        if ("CONFIRMED".equals(string)) {
            return String.format("<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M10 8c0 .552-.195 1.023-.586 1.414-.39.39-.862.586-1.414.586a1.926 1.926 0 0 1-1.414-.586A1.928 1.928 0 0 1 6 8c0-.552.195-1.023.586-1.414C6.976 6.196 7.448 6 8 6c.552 0 1.023.195 1.414.586.39.39.586.862.586 1.414zM8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>", string2, string3);
        }
        if ("RESOLVED".equals(string)) {
            return String.format("<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M12.03 6.734a.49.49 0 0 0-.14-.36l-.71-.702a.48.48 0 0 0-.352-.15.474.474 0 0 0-.35.15l-3.19 3.18-1.765-1.766a.479.479 0 0 0-.35-.15.479.479 0 0 0-.353.15l-.71.703a.482.482 0 0 0-.14.358c0 .14.046.258.14.352l2.828 2.828c.098.1.216.15.35.15.142 0 .26-.05.36-.15l4.243-4.242a.475.475 0 0 0 .14-.352l-.001.001zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(51, 51, 51);\"></path></svg>", string2, string3);
        }
        if ("TO_REVIEW".equals(string)) {
            return String.format("<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>", string2, string3);
        }
        if ("IN_REVIEW".equals(string)) {
            return String.format("<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M10 8c0 .552-.195 1.023-.586 1.414-.39.39-.862.586-1.414.586a1.926 1.926 0 0 1-1.414-.586A1.928 1.928 0 0 1 6 8c0-.552.195-1.023.586-1.414C6.976 6.196 7.448 6 8 6c.552 0 1.023.195 1.414.586.39.39.586.862.586 1.414zM8 3.75c-.77 0-1.482.19-2.133.57A4.25 4.25 0 0 0 4.32 5.867c-.38.65-.57 1.362-.57 2.133 0 .77.19 1.482.57 2.133.38.65.896 1.167 1.547 1.547.65.38 1.362.57 2.133.57.77 0 1.482-.19 2.133-.57a4.242 4.242 0 0 0 1.547-1.547c.38-.65.57-1.362.57-2.133 0-.77-.19-1.482-.57-2.133a4.25 4.25 0 0 0-1.547-1.547A4.153 4.153 0 0 0 8 3.75zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(75, 159, 213);\"></path></svg>", string2, string3);
        }
        if ("REVIEWED".equals(string)) {
            return String.format("<svg height=\"%s\" width=\"%s\" viewBox=\"0 0 16 16\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\" style=\"fill-rule: evenodd; clip-rule: evenodd; stroke-linejoin: round; stroke-miterlimit: 1.41421;\"><path d=\"M12.03 6.734a.49.49 0 0 0-.14-.36l-.71-.702a.48.48 0 0 0-.352-.15.474.474 0 0 0-.35.15l-3.19 3.18-1.765-1.766a.479.479 0 0 0-.35-.15.479.479 0 0 0-.353.15l-.71.703a.482.482 0 0 0-.14.358c0 .14.046.258.14.352l2.828 2.828c.098.1.216.15.35.15.142 0 .26-.05.36-.15l4.243-4.242a.475.475 0 0 0 .14-.352l-.001.001zM14 8c0 1.09-.268 2.092-.805 3.012a5.96 5.96 0 0 1-2.183 2.183A5.863 5.863 0 0 1 8 14a5.863 5.863 0 0 1-3.012-.805 5.96 5.96 0 0 1-2.183-2.183A5.863 5.863 0 0 1 2 8c0-1.09.268-2.092.805-3.012a5.96 5.96 0 0 1 2.183-2.183A5.863 5.863 0 0 1 8 2c1.09 0 2.092.268 3.012.805a5.96 5.96 0 0 1 2.183 2.183C13.732 5.908 14 6.91 14 8z\" style=\"fill: rgb(51, 51, 51);\"></path></svg>", string2, string3);
        }
        return "";
    }

    private double coverageStringToDouble(String string) {
        LOGGER.debug("Original coverage value (String) -> [{}]", (Object)string);
        if (string != null && (string.contains("%") || string.contains(" "))) {
            string = StringUtils.remove(string, "%").trim();
        }
        if (string == null || DEFAULT_MEASURE_VALUE.equals(string)) {
            string = "0";
        } else if (string.contains(",")) {
            string = string.replace(",", ".");
        }
        LOGGER.debug("Converted coverage value (String) -> [{}]", (Object)string);
        Double d2 = 0.0;
        try {
            d2 = NumberFormat.getNumberInstance(Locale.US).parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            LOGGER.error("Error parsing coverage value {}", (Object)string);
        }
        return d2;
    }
}

