/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ReSave {
    public static void main(String[] args2) throws Exception {
        boolean initDrawing = false;
        boolean saveToMemory = false;
        for (String filename : args2) {
            if (filename.equals("-dg")) {
                initDrawing = true;
                continue;
            }
            if (filename.equals("-bos")) {
                saveToMemory = true;
                continue;
            }
            System.out.print("reading " + filename + "...");
            try (FileInputStream is = new FileInputStream(filename);
                 HSSFWorkbook wb = new HSSFWorkbook(is);){
                System.out.println("done");
                for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                    HSSFSheet sheet = wb.getSheetAt(i);
                    if (!initDrawing) continue;
                    sheet.getDrawingPatriarch();
                }
                String outputFile = filename.replace(".xls", "-saved.xls");
                if (!saveToMemory) {
                    System.out.print("saving to " + outputFile + "...");
                }
                try (OutputStream os = saveToMemory ? new ByteArrayOutputStream() : new FileOutputStream(outputFile);){
                    wb.write(os);
                }
                System.out.println("done");
            }
        }
    }
}

