/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.poi.ss.util.NumberToTextConverter;

final class MathX {
    private MathX() {
    }

    public static double round(double n, int p) {
        return MathX.round(n, p, RoundingMode.HALF_UP);
    }

    public static double roundUp(double n, int p) {
        return MathX.round(n, p, RoundingMode.UP);
    }

    public static double roundDown(double n, int p) {
        return MathX.round(n, p, RoundingMode.DOWN);
    }

    private static double round(double n, int p, RoundingMode rounding) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return Double.NaN;
        }
        String excelNumber = NumberToTextConverter.toText(n);
        return new BigDecimal(excelNumber).setScale(p, rounding).doubleValue();
    }

    public static short sign(double d2) {
        return (short)(d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1));
    }

    public static double average(double[] values2) {
        double ave = 0.0;
        double sum = 0.0;
        for (double value : values2) {
            sum += value;
        }
        ave = sum / (double)values2.length;
        return ave;
    }

    public static double sum(double[] values2) {
        double sum = 0.0;
        for (double value : values2) {
            sum += value;
        }
        return sum;
    }

    public static double sumsq(double[] values2) {
        double sumsq = 0.0;
        for (double value : values2) {
            sumsq += value * value;
        }
        return sumsq;
    }

    public static double product(double[] values2) {
        double product = 0.0;
        if (values2 != null && values2.length > 0) {
            product = 1.0;
            for (double value : values2) {
                product *= value;
            }
        }
        return product;
    }

    public static double min(double[] values2) {
        double min2 = Double.POSITIVE_INFINITY;
        for (double value : values2) {
            min2 = Math.min(min2, value);
        }
        return min2;
    }

    public static double max(double[] values2) {
        double max = Double.NEGATIVE_INFINITY;
        for (double value : values2) {
            max = Math.max(max, value);
        }
        return max;
    }

    public static double floor(double n, double s2) {
        if (s2 == 0.0 && n != 0.0) {
            return Double.NaN;
        }
        return n == 0.0 || s2 == 0.0 ? 0.0 : Math.floor(n / s2) * s2;
    }

    public static double ceiling(double n, double s2) {
        if (n > 0.0 && s2 < 0.0) {
            return Double.NaN;
        }
        return n == 0.0 || s2 == 0.0 ? 0.0 : Math.ceil(n / s2) * s2;
    }

    public static double factorial(int n) {
        double d2 = 1.0;
        if (n >= 0) {
            if (n <= 170) {
                for (int i = 1; i <= n; ++i) {
                    d2 *= (double)i;
                }
            } else {
                d2 = Double.POSITIVE_INFINITY;
            }
        } else {
            d2 = Double.NaN;
        }
        return d2;
    }

    public static double mod(double n, double d2) {
        if (d2 == 0.0) {
            return Double.NaN;
        }
        if (MathX.sign(n) == MathX.sign(d2)) {
            return n % d2;
        }
        return (n % d2 + d2) % d2;
    }

    public static double acosh(double d2) {
        return Math.log(Math.sqrt(Math.pow(d2, 2.0) - 1.0) + d2);
    }

    public static double asinh(double d2) {
        return Math.log(Math.sqrt(d2 * d2 + 1.0) + d2);
    }

    public static double atanh(double d2) {
        return Math.log((1.0 + d2) / (1.0 - d2)) / 2.0;
    }

    public static double cosh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX + ePowNegX) / 2.0;
    }

    public static double sinh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / 2.0;
    }

    public static double tanh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / (ePowX + ePowNegX);
    }

    public static double nChooseK(int n, int k) {
        double d2 = 1.0;
        if (n < 0 || k < 0 || n < k) {
            d2 = Double.NaN;
        } else {
            int maxnk;
            int minnk = Math.min(n - k, k);
            for (int i = maxnk = Math.max(n - k, k); i < n; ++i) {
                d2 *= (double)(i + 1);
            }
            d2 /= MathX.factorial(minnk);
        }
        return d2;
    }
}

