/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

public class Levenshtein {
    private static int minimum(int a2, int b2, int c2) {
        int mi = a2;
        if (b2 < mi) {
            mi = b2;
        }
        if (c2 < mi) {
            mi = c2;
        }
        return mi;
    }

    public static int distance(String s2, String t) {
        int j;
        int i;
        int n = s2.length();
        int m3 = t.length();
        if (n == 0) {
            return m3;
        }
        if (m3 == 0) {
            return n;
        }
        int[][] d2 = new int[n + 1][m3 + 1];
        for (i = 0; i <= n; ++i) {
            d2[i][0] = i;
        }
        for (j = 0; j <= m3; ++j) {
            d2[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s2.charAt(i - 1);
            for (j = 1; j <= m3; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d2[i][j] = Levenshtein.minimum(d2[i - 1][j] + 1, d2[i][j - 1] + 1, d2[i - 1][j - 1] + cost);
            }
        }
        return d2[n][m3];
    }
}

