/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.xmlbeans.SystemProperties;

public class XBeanDebug {
    public static final int TRACE_SCHEMA_LOADING = 1;
    public static final String traceProp = "org.apache.xmlbeans.impl.debug";
    public static final String defaultProp = "";
    private static int _enabled = XBeanDebug.initializeBitsFromProperty();
    private static int _indent = 0;
    static PrintStream _err;

    private static int initializeBitsFromProperty() {
        String prop = SystemProperties.getProperty(traceProp, defaultProp);
        return prop.contains("TRACE_SCHEMA_LOADING") ? 1 : 0;
    }

    public static void enable(int bits) {
        _enabled |= bits;
    }

    public static void disable(int bits) {
        _enabled &= ~bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void trace(int bits, String message, int indent) {
        if (!XBeanDebug.test(bits)) return;
        Class<XBeanDebug> clazz = XBeanDebug.class;
        synchronized (XBeanDebug.class) {
            if (indent < 0) {
                _indent += indent;
            }
            String _indentspace = "                                                                                ";
            String spaces = _indent < 0 ? defaultProp : (_indent > _indentspace.length() ? _indentspace : _indentspace.substring(0, _indent));
            String logmessage = Thread.currentThread().getName() + ": " + spaces + message + "\n";
            System.err.print(logmessage);
            if (indent <= 0) return;
            _indent += indent;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static boolean test(int bits) {
        return (_enabled & bits) != 0;
    }

    public static String log(String message) {
        XBeanDebug.log(message, null);
        return message;
    }

    public static String logStackTrace(String message) {
        XBeanDebug.log(message, new Throwable());
        return message;
    }

    private static synchronized String log(String message, Throwable stackTrace) {
        if (_err == null) {
            try {
                File diagnosticFile = File.createTempFile("xmlbeandebug", ".log");
                _err = new PrintStream(diagnosticFile, "UTF-8");
                System.err.println("Diagnostic XML Bean debug log file created: " + diagnosticFile);
            }
            catch (IOException e2) {
                _err = System.err;
            }
        }
        _err.println(message);
        if (stackTrace != null) {
            stackTrace.printStackTrace(_err);
        }
        return message;
    }

    public static void logException(Throwable t) {
        XBeanDebug.log(t.getMessage(), t);
    }
}

