/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.xpath.saxon;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathException;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SaxonDuration;
import net.sf.saxon.value.SaxonXMLGregorianCalendar;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDate;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlDouble;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlFloat;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlLong;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.XmlTokenSource;
import org.apache.xmlbeans.impl.store.Cur;
import org.apache.xmlbeans.impl.store.Cursor;
import org.apache.xmlbeans.impl.store.Locale;
import org.apache.xmlbeans.impl.xpath.XQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SaxonXQuery
implements XQuery {
    private final XQueryExpression xquery;
    private final String contextVar;
    private final Configuration config;
    private Cur _cur;
    private long _version;
    private XmlOptions _options;

    public SaxonXQuery(String query, String contextVar, Integer boundary, XmlOptions xmlOptions) {
        assert (!contextVar.startsWith(".") && !contextVar.startsWith(".."));
        this._options = xmlOptions;
        this.config = new Configuration();
        StaticQueryContext sc = this.config.newStaticQueryContext();
        Map<String, String> nsMap = xmlOptions.getLoadAdditionalNamespaces();
        if (nsMap != null) {
            nsMap.forEach((arg_0, arg_1) -> ((StaticQueryContext)sc).declareNamespace(arg_0, arg_1));
        }
        this.contextVar = contextVar;
        try {
            this.xquery = sc.compileQuery(query.substring(0, boundary) + " declare variable $" + contextVar + " external;" + query.substring(boundary));
        }
        catch (TransformerException e2) {
            throw new XmlRuntimeException(e2);
        }
    }

    @Override
    public XmlObject[] objectExecute(Cur c2, XmlOptions options) {
        this._version = c2.getLocale().version();
        this._cur = c2.weakCur(this);
        this._options = options;
        return this.objectExecute();
    }

    @Override
    public XmlCursor cursorExecute(Cur c2, XmlOptions options) {
        this._version = c2.getLocale().version();
        this._cur = c2.weakCur(this);
        this._options = options;
        return this.cursorExecute();
    }

    public List execQuery(Object node, Map variableBindings) {
        try {
            Node contextNode = (Node)node;
            Document dom = contextNode.getNodeType() == 9 ? (Document)contextNode : contextNode.getOwnerDocument();
            DocumentWrapper docWrapper = new DocumentWrapper((Node)dom, null, this.config);
            DOMNodeWrapper root = docWrapper.wrap(contextNode);
            DynamicQueryContext dc = new DynamicQueryContext(this.config);
            dc.setContextItem((Item)root);
            dc.setParameter(new StructuredQName("", null, this.contextVar), (GroundedValue)root);
            if (variableBindings != null) {
                for (Map.Entry me : variableBindings.entrySet()) {
                    StructuredQName key = new StructuredQName("", null, (String)me.getKey());
                    Object value = me.getValue();
                    if (value instanceof XmlTokenSource) {
                        Node paramObject = ((XmlTokenSource)value).getDomNode();
                        dc.setParameter(key, (GroundedValue)docWrapper.wrap(paramObject));
                        continue;
                    }
                    try {
                        dc.setParameter(key, (GroundedValue)SaxonXQuery.objectToItem(value, this.config));
                    }
                    catch (XPathException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            List saxonNodes = this.xquery.evaluate(dc);
            ListIterator<NodeOverNodeInfo> it = saxonNodes.listIterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof NodeInfo)) continue;
                NodeOverNodeInfo n = NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)o));
                it.set(n);
            }
            return saxonNodes;
        }
        catch (TransformerException e3) {
            throw new RuntimeException("Error binding " + this.contextVar, e3);
        }
    }

    private static Item objectToItem(Object value, Configuration config) throws XPathException, net.sf.saxon.trans.XPathException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return BooleanValue.get((boolean)((Boolean)value));
        }
        if (value instanceof byte[]) {
            return new HexBinaryValue((byte[])value);
        }
        if (value instanceof Byte) {
            return new Int64Value((long)((Byte)value).byteValue(), BuiltInAtomicType.BYTE, false);
        }
        if (value instanceof Float) {
            return new FloatValue(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new DoubleValue(((Double)value).doubleValue());
        }
        if (value instanceof Integer) {
            return new Int64Value((long)((Integer)value).intValue(), BuiltInAtomicType.INT, false);
        }
        if (value instanceof Long) {
            return new Int64Value(((Long)value).longValue(), BuiltInAtomicType.LONG, false);
        }
        if (value instanceof Short) {
            return new Int64Value((long)((Short)value).shortValue(), BuiltInAtomicType.SHORT, false);
        }
        if (value instanceof String) {
            return new StringValue((CharSequence)((String)value));
        }
        if (value instanceof BigDecimal) {
            return new BigDecimalValue((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return new BigIntegerValue((BigInteger)value);
        }
        if (value instanceof SaxonDuration) {
            return ((SaxonDuration)value).getDurationValue();
        }
        if (value instanceof Duration) {
            Duration dv = (Duration)value;
            return new DurationValue(dv.getSign() >= 0, dv.getYears(), dv.getMonths(), dv.getDays(), dv.getHours(), dv.getMinutes(), (long)dv.getSeconds(), 0);
        }
        if (value instanceof SaxonXMLGregorianCalendar) {
            return ((SaxonXMLGregorianCalendar)value).toCalendarValue();
        }
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar g2 = (XMLGregorianCalendar)value;
            QName gtype = g2.getXMLSchemaType();
            if (gtype.equals(DatatypeConstants.DATETIME)) {
                return DateTimeValue.makeDateTimeValue((CharSequence)value.toString(), (ConversionRules)config.getConversionRules()).asAtomic();
            }
            if (gtype.equals(DatatypeConstants.DATE)) {
                return DateValue.makeDateValue((CharSequence)value.toString(), (ConversionRules)config.getConversionRules()).asAtomic();
            }
            if (gtype.equals(DatatypeConstants.TIME)) {
                return TimeValue.makeTimeValue((CharSequence)value.toString()).asAtomic();
            }
            if (gtype.equals(DatatypeConstants.GYEAR)) {
                return GYearValue.makeGYearValue((CharSequence)value.toString(), (ConversionRules)config.getConversionRules()).asAtomic();
            }
            if (gtype.equals(DatatypeConstants.GYEARMONTH)) {
                return GYearMonthValue.makeGYearMonthValue((CharSequence)value.toString(), (ConversionRules)config.getConversionRules()).asAtomic();
            }
            if (gtype.equals(DatatypeConstants.GMONTH)) {
                String val = value.toString();
                if (val.endsWith("--")) {
                    val = val.substring(0, val.length() - 2);
                }
                return GMonthValue.makeGMonthValue((CharSequence)val).asAtomic();
            }
            if (gtype.equals(DatatypeConstants.GMONTHDAY)) {
                return GMonthDayValue.makeGMonthDayValue((CharSequence)value.toString()).asAtomic();
            }
            if (gtype.equals(DatatypeConstants.GDAY)) {
                return GDayValue.makeGDayValue((CharSequence)value.toString()).asAtomic();
            }
            throw new AssertionError((Object)"Unknown Gregorian date type");
        }
        if (value instanceof QName) {
            QName q = (QName)value;
            return new QNameValue(q.getPrefix(), q.getNamespaceURI(), q.getLocalPart());
        }
        if (value instanceof URI) {
            return new AnyURIValue((CharSequence)value.toString());
        }
        if (value instanceof Map) {
            HashTrieMap htm = new HashTrieMap();
            for (Map.Entry me : ((Map)value).entrySet()) {
                htm.initialPut((AtomicValue)SaxonXQuery.objectToItem(me.getKey(), config), (GroundedValue)SaxonXQuery.objectToItem(me.getValue(), config));
            }
            return htm;
        }
        return new ObjectValue(value);
    }

    public XmlObject[] objectExecute() {
        if (this._cur == null || this._version != this._cur.getLocale().version()) {
            // empty if block
        }
        Map<String, Object> bindings = XmlOptions.maskNull(this._options).getXqueryVariables();
        List resultsList = this.execQuery(this._cur.getDom(), bindings);
        XmlObject[] result = new XmlObject[resultsList.size()];
        for (int i = 0; i < resultsList.size(); ++i) {
            Locale l = Locale.getLocale(this._cur.getLocale().getSchemaTypeLoader(), this._options);
            l.enter();
            Object node = resultsList.get(i);
            Cur res = null;
            try {
                if (!(node instanceof Node)) {
                    res = l.load("<xml-fragment/>").tempCur();
                    res.setValue(node.toString());
                    SchemaType type = this.getType(node);
                    Locale.autoTypeDocument(res, type, null);
                    result[i] = res.getObject();
                } else {
                    res = this.loadNode(l, (Node)node);
                }
                result[i] = res.getObject();
            }
            catch (XmlException e2) {
                throw new RuntimeException(e2);
            }
            finally {
                l.exit();
            }
            res.release();
        }
        this.release();
        return result;
    }

    private SchemaType getType(Object node) {
        SchemaType type = node instanceof Integer ? XmlInteger.type : (node instanceof Double ? XmlDouble.type : (node instanceof Long ? XmlLong.type : (node instanceof Float ? XmlFloat.type : (node instanceof BigDecimal ? XmlDecimal.type : (node instanceof Boolean ? XmlBoolean.type : (node instanceof String ? XmlString.type : (node instanceof Date ? XmlDate.type : XmlAnySimpleType.type)))))));
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor cursorExecute() {
        if (this._cur == null || this._version != this._cur.getLocale().version()) {
            // empty if block
        }
        Map<String, Object> bindings = XmlOptions.maskNull(this._options).getXqueryVariables();
        List resultsList = this.execQuery(this._cur.getDom(), bindings);
        Locale locale = Locale.getLocale(this._cur.getLocale().getSchemaTypeLoader(), this._options);
        locale.enter();
        Cur.CurLoadContext _context = new Cur.CurLoadContext(locale, this._options);
        Cursor resultCur = null;
        try {
            for (int i = 0; i < resultsList.size(); ++i) {
                this.loadNodeHelper(locale, (Node)resultsList.get(i), _context);
            }
            Cur c2 = ((Locale.LoadContext)_context).finish();
            Locale.associateSourceName(c2, this._options);
            Locale.autoTypeDocument(c2, null, this._options);
            resultCur = new Cursor(c2);
        }
        catch (Exception exception) {
        }
        finally {
            locale.exit();
        }
        this.release();
        return resultCur;
    }

    public void release() {
        if (this._cur != null) {
            this._cur.release();
            this._cur = null;
        }
    }

    private Cur loadNode(Locale locale, Node node) {
        Cur.CurLoadContext context = new Cur.CurLoadContext(locale, this._options);
        try {
            this.loadNodeHelper(locale, node, context);
            Cur c2 = ((Locale.LoadContext)context).finish();
            Locale.associateSourceName(c2, this._options);
            Locale.autoTypeDocument(c2, null, this._options);
            return c2;
        }
        catch (Exception e2) {
            throw new XmlRuntimeException(e2.getMessage(), e2);
        }
    }

    private void loadNodeHelper(Locale locale, Node node, Locale.LoadContext context) {
        if (node.getNodeType() == 2) {
            QName attName = new QName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
            context.attr(attName, node.getNodeValue());
        } else {
            locale.loadNode(node, context);
        }
    }
}

