/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import org.knowm.xchart.RadarChartBuilder;
import org.knowm.xchart.RadarSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_Marker;
import org.knowm.xchart.internal.chartpart.Plot_Radar;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.RadarStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.theme.Theme;

public class RadarChart
extends Chart<RadarStyler, RadarSeries> {
    private String[] radiiLabels;

    public RadarChart(int width, int height) {
        super(width, height, new RadarStyler());
        this.plot = new Plot_Radar<RadarStyler, RadarSeries>(this);
        this.legend = new Legend_Marker<RadarStyler, RadarSeries>(this);
    }

    public RadarChart(int width, int height, Theme theme) {
        this(width, height);
        ((RadarStyler)this.styler).setTheme(theme);
    }

    public RadarChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public RadarChart(RadarChartBuilder radarChartBuilder) {
        this(radarChartBuilder.width, radarChartBuilder.height, radarChartBuilder.chartTheme);
        this.setTitle(radarChartBuilder.title);
    }

    public String[] getRadiiLabels() {
        return this.radiiLabels;
    }

    public void setRadiiLabels(String[] radiiLabels) {
        this.radiiLabels = radiiLabels;
    }

    public RadarSeries addSeries(String seriesName, double[] values2) {
        return this.addSeries(seriesName, values2, null);
    }

    public RadarSeries addSeries(String seriesName, double[] values2, String[] tooltipOverrides) {
        this.sanityCheck(seriesName, values2, tooltipOverrides);
        RadarSeries series = new RadarSeries(seriesName, values2, tooltipOverrides);
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private void sanityCheck(String seriesName, double[] values2, String[] annotations) {
        if (this.radiiLabels == null) {
            throw new IllegalArgumentException("Variable labels cannot be null!!!");
        }
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        if (values2 == null) {
            throw new IllegalArgumentException("Values data cannot be null!!!");
        }
        if (values2.length < this.radiiLabels.length) {
            throw new IllegalArgumentException("Too few values!!!");
        }
        for (double d2 : values2) {
            if (!(d2 < 0.0) && !(d2 > 1.0)) continue;
            throw new IllegalArgumentException("Values must be in [0, 1] range!!!");
        }
        if (annotations != null && annotations.length < this.radiiLabels.length) {
            throw new IllegalArgumentException("Too few tool tips!!!");
        }
    }

    @Override
    public void paint(Graphics2D g2, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setSeriesStyles();
        this.paintBackground(g2);
        this.plot.paint(g2);
        this.chartTitle.paint(g2);
        this.legend.paint(g2);
        this.annotations.forEach(x -> x.paint(g2));
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((RadarStyler)this.getStyler()).getSeriesColors(), ((RadarStyler)this.getStyler()).getSeriesMarkers(), ((RadarStyler)this.getStyler()).getSeriesLines());
        for (RadarSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }
}

