/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.knowm.xchart.RadarChart;
import org.knowm.xchart.RadarSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.RadarStyler;

public class PlotContent_Radar<ST extends RadarStyler, S extends RadarSeries>
extends PlotContent_<ST, S> {
    private final RadarStyler styler;
    private static final NumberFormat df = DecimalFormat.getPercentInstance();

    PlotContent_Radar(Chart<ST, S> chart) {
        super(chart);
        this.styler = (RadarStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g2) {
        int i;
        double radarHeight;
        double radarWidth;
        double boundsWidth = this.getBounds().getWidth();
        double boundsHeight = this.getBounds().getHeight();
        if (this.styler.isCircular()) {
            radarHeight = radarWidth = Math.min(boundsWidth, boundsHeight) * this.styler.getPlotContentSize() - (double)(2 * this.styler.getRadiiTitlePadding());
        } else {
            radarWidth = boundsWidth * this.styler.getPlotContentSize() - (double)(2 * this.styler.getRadiiTitlePadding());
            radarHeight = boundsHeight * this.styler.getPlotContentSize() - (double)(2 * this.styler.getRadiiTitlePadding());
        }
        double radarStartX = this.getBounds().getX() + boundsWidth / 2.0 - radarWidth / 2.0;
        double radarStartY = this.getBounds().getY() + boundsHeight / 2.0 - radarHeight / 2.0;
        double radarRadiusX = radarWidth / 2.0;
        double radarRadiusY = radarHeight / 2.0;
        double radarCenterX = radarStartX + radarWidth / 2.0;
        double radarCenterY = radarStartY + radarHeight / 2.0;
        String[] radiiLabels = ((RadarChart)this.chart).getRadiiLabels();
        double radiiAngle = 360.0 / (double)radiiLabels.length;
        int numRadiiLabels = radiiLabels.length;
        double[] cosArr = new double[numRadiiLabels];
        double[] sinArr = new double[numRadiiLabels];
        double startAngle = this.styler.getStartAngleInDegrees() + 90.0;
        for (i = 0; i < numRadiiLabels; ++i) {
            double radians2 = Math.toRadians(startAngle);
            double cos = Math.cos(radians2);
            double sin = Math.sin(radians2);
            cosArr[i] = cos;
            sinArr[i] = sin;
            startAngle += radiiAngle;
        }
        startAngle = this.styler.getStartAngleInDegrees() + 90.0;
        for (i = 0; i < numRadiiLabels; ++i) {
            double cos = cosArr[i];
            double sin = sinArr[i];
            if (this.styler.isRadiiTicksMarksVisible()) {
                double xOffset = radarCenterX + cos * radarRadiusX;
                double yOffset = radarCenterY - sin * radarRadiusY;
                Line2D.Double line = new Line2D.Double(radarCenterX, radarCenterY, xOffset, yOffset);
                g2.setColor(this.styler.getRadiiTickMarksColor());
                g2.setStroke(this.styler.getRadiiTickMarksStroke());
                g2.draw(line);
            }
            if (this.styler.isRadiiTitleVisible()) {
                String radiiLabel = radiiLabels[i];
                TextLayout textLayout = new TextLayout(radiiLabel, this.styler.getRadiiTitleFont(), new FontRenderContext(null, true, false));
                Shape shape = textLayout.getOutline(null);
                Rectangle2D labelBounds = shape.getBounds2D();
                double labelWidth = labelBounds.getWidth();
                double labelHeight = labelBounds.getHeight();
                double xOffset = radarCenterX + cos * radarRadiusX;
                double yOffset = radarCenterY - sin * radarRadiusY;
                xOffset = xOffset - Math.sin(Math.toRadians(startAngle - 90.0)) * (labelWidth / 1.5 + (double)this.styler.getRadiiTitlePadding()) - labelWidth / 2.0;
                yOffset = yOffset - (Math.cos(Math.toRadians(startAngle - 90.0)) - 1.0) * labelHeight / 2.0 - Math.cos(Math.toRadians(startAngle - 90.0)) * 1.4 * (double)this.styler.getRadiiTitlePadding();
                g2.setColor(this.styler.getChartFontColor());
                g2.setFont(this.styler.getBaseFont());
                AffineTransform orig = g2.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(xOffset, yOffset);
                g2.transform(at);
                g2.fill(shape);
                g2.setTransform(orig);
            }
            startAngle += radiiAngle;
        }
        int markCount = this.styler.getRadiiTickMarksCount();
        if (markCount > 0 && this.styler.isRadiiTicksMarksVisible()) {
            g2.setColor(this.styler.getRadiiTickMarksColor());
            g2.setStroke(this.styler.getRadiiTickMarksStroke());
            if (this.styler.getRadarRenderStyle() == RadarStyler.RadarRenderStyle.Circle) {
                Ellipse2D.Double markShape = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);
                double winc = radarRadiusX / (double)markCount;
                double hinc = radarRadiusY / (double)markCount;
                double newXd = radarRadiusX;
                double newYd = radarRadiusY;
                for (int i2 = 0; i2 < markCount; ++i2) {
                    markShape.width = newXd * 2.0;
                    markShape.height = newYd * 2.0;
                    markShape.x = radarCenterX - newXd;
                    markShape.y = radarCenterY - newYd;
                    if (i2 == 0) {
                        g2.setColor(this.styler.getRadiiTickMarksColor().darker());
                    } else {
                        g2.setColor(this.styler.getRadiiTickMarksColor());
                    }
                    g2.draw(markShape);
                    newXd -= winc;
                    newYd -= hinc;
                }
            } else if (this.styler.getRadarRenderStyle() == RadarStyler.RadarRenderStyle.Polygon) {
                double winc = radarRadiusX / (double)markCount;
                double hinc = radarRadiusY / (double)markCount;
                for (int markerInd = 0; markerInd < markCount; ++markerInd) {
                    Path2D.Double path = new Path2D.Double();
                    for (int varInd = 0; varInd < numRadiiLabels; ++varInd) {
                        double cos = cosArr[varInd];
                        double sin = sinArr[varInd];
                        double xOffset = radarCenterX + cos * (radarRadiusX - (double)markerInd * winc);
                        double yOffset = radarCenterY - sin * (radarRadiusY - (double)markerInd * hinc);
                        if (varInd == 0) {
                            path.moveTo(xOffset, yOffset);
                            continue;
                        }
                        path.lineTo(xOffset, yOffset);
                    }
                    path.closePath();
                    if (markerInd == 0) {
                        g2.setColor(this.styler.getRadiiTickMarksColor().darker());
                    } else {
                        g2.setColor(this.styler.getRadiiTickMarksColor());
                    }
                    g2.draw(path);
                }
            }
        }
        NumberFormat decimalFormat = this.styler.getDecimalPattern() == null ? df : new DecimalFormat(this.styler.getDecimalPattern());
        Map map = this.chart.getSeriesMap();
        for (RadarSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            double[] values2 = series.getValues();
            String[] tooltipOverrides = series.getTooltipOverrides();
            g2.setColor(series.getFillColor());
            Path2D.Double path = new Path2D.Double();
            for (int i3 = 0; i3 < numRadiiLabels; ++i3) {
                double cos = cosArr[i3];
                double sin = sinArr[i3];
                double value = values2[i3];
                double xOffset = radarCenterX + cos * (radarRadiusX * value);
                double yOffset = radarCenterY - sin * (radarRadiusY * value);
                if (i3 == 0) {
                    path.moveTo(xOffset, yOffset);
                } else {
                    path.lineTo(xOffset, yOffset);
                }
                if (series.getMarker() != null) {
                    g2.setColor(series.getMarkerColor());
                    series.getMarker().paint(g2, xOffset, yOffset, this.styler.getMarkerSize());
                }
                if (!((RadarStyler)this.chart.getStyler()).isToolTipsEnabled()) continue;
                String label = null;
                if (tooltipOverrides != null) {
                    label = tooltipOverrides[i3];
                }
                if (label == null) {
                    String ystr = decimalFormat.format(value);
                    label = series.getName() + " (" + radiiLabels[i3] + ": " + ystr + ")";
                }
                this.toolTips.addData(xOffset, yOffset, label);
            }
            path.closePath();
            g2.setStroke(series.getLineStyle());
            g2.setColor(series.getLineColor());
            g2.draw(path);
            if (!this.styler.isSeriesFilled()) continue;
            g2.setColor(series.getFillColor());
            g2.fill(path);
        }
    }
}

