/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.ValidationMessages;

@Deprecated
@ServerSide
@ComputeEngineSide
public class XMLProfileParser {
    private static final String ELEMENT_PROFILE = "profile";
    private static final String ELEMENT_RULES = "rules";
    private static final String ELEMENT_RULE = "rule";
    private static final String ELEMENT_PARAMETERS = "parameters";
    private static final String ELEMENT_PARAMETER = "parameter";
    private final RuleFinder ruleFinder;

    @Deprecated
    public XMLProfileParser(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile parseResource(ClassLoader classloader, String xmlClassPath, ValidationMessages messages) {
        RulesProfile rulesProfile;
        InputStreamReader reader = new InputStreamReader(classloader.getResourceAsStream(xmlClassPath), StandardCharsets.UTF_8);
        try {
            rulesProfile = this.parse(reader, messages);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new IllegalStateException("Unable to close stream", e2);
            }
        }
        ((Reader)reader).close();
        return rulesProfile;
    }

    public RulesProfile parse(Reader inputReader, ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create();
        XMLInputFactory inputFactory = XMLProfileParser.initStax();
        try {
            XMLEventReader reader = inputFactory.createXMLEventReader(inputReader);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals(ELEMENT_PROFILE)) continue;
                this.parseProfile(profile, reader, messages);
            }
        }
        catch (XMLStreamException e2) {
            messages.addErrorText("XML is not valid: " + e2.getMessage());
        }
        XMLProfileParser.checkProfile(profile, messages);
        return profile;
    }

    private void parseProfile(RulesProfile profile, XMLEventReader reader, ValidationMessages messages) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_PROFILE)) {
                return;
            }
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            String elementName = element.getName().getLocalPart();
            if (ELEMENT_RULES.equals(elementName)) {
                this.parseRules(profile, reader, messages);
                continue;
            }
            if ("name".equals(elementName)) {
                profile.setName(StringUtils.trim(reader.getElementText()));
                continue;
            }
            if (!"language".equals(elementName)) continue;
            profile.setLanguage(StringUtils.trim(reader.getElementText()));
        }
    }

    private void parseRules(RulesProfile profile, XMLEventReader reader, ValidationMessages messages) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement element;
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_RULES)) {
                return;
            }
            if (!event.isStartElement() || !ELEMENT_RULE.equals(elementName = (element = event.asStartElement()).getName().getLocalPart())) continue;
            this.parseRule(profile, reader, messages);
        }
    }

    private static void checkProfile(RulesProfile profile, ValidationMessages messages) {
        if (StringUtils.isBlank(profile.getName())) {
            messages.addErrorText("The mandatory node <name> is missing.");
        }
        if (StringUtils.isBlank(profile.getLanguage())) {
            messages.addErrorText("The mandatory node <language> is missing.");
        }
    }

    private static XMLInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return xmlFactory;
    }

    private void parseRule(RulesProfile profile, XMLEventReader reader, ValidationMessages messages) throws XMLStreamException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String repositoryKey = null;
        String key = null;
        RulePriority priority = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_RULE)) {
                this.buildRule(profile, messages, parameters, repositoryKey, key, priority);
                return;
            }
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            String elementName = element.getName().getLocalPart();
            if ("repositoryKey".equals(elementName)) {
                repositoryKey = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("key".equals(elementName)) {
                key = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("priority".equals(elementName)) {
                priority = RulePriority.valueOf(StringUtils.trim(reader.getElementText()));
                continue;
            }
            if (!ELEMENT_PARAMETERS.equals(elementName)) continue;
            XMLProfileParser.processParameters(parameters, reader);
        }
    }

    private void buildRule(RulesProfile profile, ValidationMessages messages, Map<String, String> parameters, String repositoryKey, String key, @Nullable RulePriority priority) {
        Rule rule = this.ruleFinder.findByKey(repositoryKey, key);
        if (rule == null) {
            messages.addWarningText("Rule not found: " + XMLProfileParser.ruleToString(repositoryKey, key));
        } else {
            ActiveRule activeRule = profile.activateRule(rule, priority);
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (rule.getParam(entry.getKey()) == null) {
                    messages.addWarningText("The parameter '" + entry.getKey() + "' does not exist in the rule: " + XMLProfileParser.ruleToString(repositoryKey, key));
                    continue;
                }
                activeRule.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    private static String ruleToString(String repositoryKey, String key) {
        return "[repository=" + repositoryKey + ", key=" + key + "]";
    }

    private static void processParameters(Map<String, String> parameters, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement element;
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_PARAMETERS)) {
                return;
            }
            if (!event.isStartElement() || !ELEMENT_PARAMETER.equals(elementName = (element = event.asStartElement()).getName().getLocalPart())) continue;
            XMLProfileParser.processParameter(parameters, reader);
        }
    }

    private static void processParameter(Map<String, String> parameters, XMLEventReader reader) throws XMLStreamException {
        String key = null;
        String value = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_PARAMETER)) {
                if (key != null) {
                    parameters.put(key, value);
                }
                return;
            }
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            String elementName = element.getName().getLocalPart();
            if ("key".equals(elementName)) {
                key = StringUtils.trim(reader.getElementText());
                continue;
            }
            if (!"value".equals(elementName)) continue;
            value = StringUtils.trim(reader.getElementText());
        }
    }
}

