/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rule;

import java.io.Serializable;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.utils.Preconditions;

@Immutable
public class RuleKey
implements Serializable,
Comparable<RuleKey> {
    public static final String EXTERNAL_RULE_REPO_PREFIX = "external_";
    private final String repository;
    private final String rule;
    private final String toString;

    protected RuleKey(String repositoryKey, String ruleKey) {
        this.repository = repositoryKey;
        this.rule = ruleKey;
        this.toString = repositoryKey + ":" + ruleKey;
    }

    public static RuleKey of(String repository, String rule) {
        Preconditions.checkArgument(!StringUtils.isEmpty(repository), "Repository must be set");
        Preconditions.checkArgument(!StringUtils.isEmpty(rule), "Rule must be set");
        return new RuleKey(repository, rule);
    }

    public static RuleKey parse(String s2) {
        int semiColonPos = s2.indexOf(58);
        Preconditions.checkArgument(semiColonPos > 0, "Invalid rule key: " + s2);
        String key = s2.substring(0, semiColonPos);
        String repo = s2.substring(semiColonPos + 1);
        return RuleKey.of(key, repo);
    }

    public String repository() {
        return this.repository;
    }

    public String rule() {
        return this.rule;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleKey ruleKey = (RuleKey)o;
        return this.repository.equals(ruleKey.repository) && this.rule.equals(ruleKey.rule);
    }

    public int hashCode() {
        int result = this.repository.hashCode();
        result = 31 * result + this.rule.hashCode();
        return result;
    }

    public String toString() {
        return this.toString;
    }

    @Override
    public int compareTo(RuleKey o) {
        int compareRepositories = this.repository.compareTo(o.repository);
        if (compareRepositories == 0) {
            return this.rule.compareTo(o.rule);
        }
        return compareRepositories;
    }
}

