/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.apachecommons.io.FilenameUtils;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.PathUtils;

@ScannerSide
@Immutable
public class PathResolver {
    public File relativeFile(File dir, String path) {
        return dir.toPath().resolve(path).normalize().toFile();
    }

    public List<File> relativeFiles(File dir, List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            result.add(this.relativeFile(dir, path));
        }
        return result;
    }

    @Deprecated
    @CheckForNull
    public RelativePath relativePath(Collection<File> dirs, File file) {
        ArrayList<String> stack = new ArrayList<String>();
        for (File cursor = file; cursor != null; cursor = cursor.getParentFile()) {
            File parentDir = PathResolver.parentDir(dirs, cursor);
            if (parentDir != null) {
                return new RelativePath(parentDir, stack.stream().collect(Collectors.joining("/")));
            }
            stack.add(0, cursor.getName());
        }
        return null;
    }

    @CheckForNull
    public String relativePath(Path dir, Path file) {
        Path baseDir = dir.normalize();
        Path path = file.normalize();
        if (!path.startsWith(baseDir)) {
            return null;
        }
        try {
            Path relativized = baseDir.relativize(path);
            return FilenameUtils.separatorsToUnix(relativized.toString());
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    public static Optional<String> relativize(Path dir, Path file) {
        Path baseDir = dir.normalize();
        Path path = file.normalize();
        if (!path.startsWith(baseDir)) {
            return Optional.empty();
        }
        try {
            Path relativized = baseDir.relativize(path);
            return Optional.of(FilenameUtils.separatorsToUnix(relativized.toString()));
        }
        catch (IllegalArgumentException e2) {
            return Optional.empty();
        }
    }

    @CheckForNull
    public String relativePath(File dir, File file) {
        return this.relativePath(dir.toPath(), file.toPath());
    }

    @CheckForNull
    private static File parentDir(Collection<File> dirs, File cursor) {
        for (File dir : dirs) {
            if (!PathUtils.canonicalPath(dir).equals(PathUtils.canonicalPath(cursor))) continue;
            return dir;
        }
        return null;
    }

    @Deprecated
    public static final class RelativePath {
        private File dir;
        private String path;

        public RelativePath(File dir, String path) {
            this.dir = dir;
            this.path = path;
        }

        public File dir() {
            return this.dir;
        }

        public String path() {
            return this.path;
        }
    }
}

