/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.internal.apachecommons.lang.StringEscapeUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;

public final class RuleParamType {
    private static final String OPTION_SEPARATOR = ",";
    public static final RuleParamType STRING = new RuleParamType("STRING", new String[0]);
    public static final RuleParamType TEXT = new RuleParamType("TEXT", new String[0]);
    public static final RuleParamType BOOLEAN = new RuleParamType("BOOLEAN", new String[0]);
    public static final RuleParamType INTEGER = new RuleParamType("INTEGER", new String[0]);
    public static final RuleParamType FLOAT = new RuleParamType("FLOAT", new String[0]);
    private static final String VALUES_PARAM = "values";
    private static final String MULTIPLE_PARAM = "multiple";
    private static final String PARAMETER_SEPARATOR = "=";
    private final String type;
    private final List<String> values;
    private final boolean multiple;
    private final String key;

    private RuleParamType(String type, String ... options) {
        this(type, false, options);
    }

    private RuleParamType(String type, boolean multiple, String ... values2) {
        this.type = type;
        this.values = Arrays.asList(values2);
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        if (multiple) {
            sb.append(OPTION_SEPARATOR);
            sb.append("multiple=");
            sb.append(multiple);
        }
        if (values2.length > 0) {
            sb.append(OPTION_SEPARATOR);
            sb.append("values=");
            sb.append(StringEscapeUtils.escapeCsv(RuleParamType.valuesToCsv(values2)));
        }
        this.key = sb.toString();
        this.multiple = multiple;
    }

    private static String valuesToCsv(String ... values2) {
        StringBuilder sb = new StringBuilder();
        for (String value : values2) {
            sb.append(StringEscapeUtils.escapeCsv(value));
            sb.append(OPTION_SEPARATOR);
        }
        return sb.toString();
    }

    public String type() {
        return this.type;
    }

    public List<String> values() {
        return this.values;
    }

    public boolean multiple() {
        return this.multiple;
    }

    public static RuleParamType singleListOfValues(String ... acceptedValues) {
        String type = PropertyType.SINGLE_SELECT_LIST.name();
        return new RuleParamType(type, acceptedValues);
    }

    public static RuleParamType multipleListOfValues(String ... acceptedValues) {
        String type = PropertyType.SINGLE_SELECT_LIST.name();
        return new RuleParamType(type, true, acceptedValues);
    }

    public static RuleParamType parse(String s2) {
        String[] options;
        if ("i".equals(s2) || "i{}".equals(s2)) {
            return INTEGER;
        }
        if ("s".equals(s2) || "s{}".equals(s2) || "r".equals(s2) || "REGULAR_EXPRESSION".equals(s2)) {
            return STRING;
        }
        if ("b".equals(s2)) {
            return BOOLEAN;
        }
        if (s2.startsWith("s[")) {
            String values2 = StringUtils.substringBetween(s2, "[", "]");
            return RuleParamType.multipleListOfValues(StringUtils.split(values2, ','));
        }
        String format = StringUtils.substringBefore(s2, OPTION_SEPARATOR);
        String values3 = null;
        boolean multiple = false;
        for (String option : options = RuleParamType.csvFormatSplit(s2)) {
            String opt = StringEscapeUtils.unescapeCsv(option);
            if (opt.startsWith("values=")) {
                values3 = StringEscapeUtils.unescapeCsv(StringUtils.substringAfter(opt, "values="));
                continue;
            }
            if (!opt.startsWith("multiple=")) continue;
            multiple = Boolean.parseBoolean(StringUtils.substringAfter(opt, "multiple="));
        }
        if (values3 == null || StringUtils.isBlank(values3)) {
            return new RuleParamType(format, new String[0]);
        }
        return new RuleParamType(format, multiple, RuleParamType.csvFormatSplit(values3));
    }

    private static String[] csvFormatSplit(String input) {
        ArrayList<String> result = new ArrayList<String>();
        boolean betweenQuote = false;
        int startIndex = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c2 = input.charAt(i);
            if (c2 == '\"') {
                betweenQuote = !betweenQuote;
                continue;
            }
            if (betweenQuote || c2 != ',') continue;
            result.add(input.substring(startIndex, i));
            startIndex = i + 1;
        }
        if (startIndex < input.length()) {
            result.add(input.substring(startIndex));
        }
        return result.toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleParamType that = (RuleParamType)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }
}

