/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.rules.RuleType;

public class RuleTagsToTypeConverter {
    public static final String TAG_BUG = "bug";
    public static final String TAG_SECURITY = "security";
    public static final Set<String> RESERVED_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bug", "security")));

    private RuleTagsToTypeConverter() {
    }

    public static RuleType convert(Collection<String> tags) {
        if (tags.contains(TAG_BUG)) {
            return RuleType.BUG;
        }
        if (tags.contains(TAG_SECURITY)) {
            return RuleType.VULNERABILITY;
        }
        return RuleType.CODE_SMELL;
    }
}

