/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report.pdf;

import com.bitegarden.sonar.plugins.report.pdf.Fonts;
import com.bitegarden.sonar.plugins.report.util.ChartSeries;
import com.bitegarden.sonar.plugins.report.util.ChartUtils;
import com.bitegarden.sonar.plugins.report.util.PdfUtils;
import com.bitegarden.sonar.plugins.report.util.ReportConstants;
import com.bitegarden.sonar.plugins.report.util.ReportUtils;
import com.google.protobuf.GeneratedMessageV3;
import es.sonarqube.api.SonarQubeHistoryMeasure;
import es.sonarqube.api.SonarQubeHistoryMetricValue;
import es.sonarqube.api.SonarQubeIssuesBreakdown;
import es.sonarqube.api.SonarQubeProject;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeHotspotManager;
import es.sonarqube.managers.SonarQubeIssueManager;
import es.sonarqube.managers.SonarQubeMeasureManager;
import es.sonarqube.managers.SonarQubeProjectManager;
import es.sonarqube.managers.SonarQubeRuleManager;
import es.sonarqube.managers.SonarQubeServerManager;
import es.sonarqube.utils.FormatUtils;
import es.sonarqube.utils.ParamsUtils;
import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.DateUtils;
import org.sonarqube.ws.Hotspots;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.ProjectBranches;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.WsClient;

public class ReportEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportEngine.class);
    private static final String BUG = "bug";
    private static final String CODE_SMELL = "code_smell";
    private static final String HOTSPOT = "hotspot";
    private static final String SECURITY_HOTSPOT = "security_hotspot";
    private static final String VULNERABILITY = "vulnerability";
    private static final String BLOCKER = "BLOCKER";
    private static final String CRITICAL = "CRITICAL";
    private static final String MAJOR = "MAJOR";
    private static final String MINOR = "MINOR";
    private static final String INFO = "INFO";
    private final PDDocument document;
    private final PDDocument templateSummary;
    private final PDDocument templateIssues;
    private final SonarQubeProject sonarQubeProject;
    private final SonarQubeIssuesBreakdown sonarQubeIssuesBreakdown;
    private final Map<String, String> projectMeasures;
    private final Fonts fonts;
    private final Locale userLocale;
    private final int footerScaledWidth;
    private final int footerScaledHeight;
    private final PDImageXObject pdFooterImage;
    private final String branch;
    private final SonarQubeIssueManager sonarQubeIssueManager;
    private final SonarQubeMeasureManager sonarQubeMeasureManager;
    private final SonarQubeRuleManager sonarQubeRuleManager;
    private final SonarQubeHotspotManager sonarQubeHotspotManager;
    private final SonarQubeServerManager sonarQubeServerManager;
    private final Map<String, Long> totalIssues;
    private final Map<String, Long> totalHotpots;
    private final Map<String, Long> blockerIssues;
    private final Map<String, Long> criticalIssues;
    private final Map<String, Long> majorIssues;
    private final Map<String, Long> minorIssues;
    private final Map<String, Long> infoIssues;
    private final Map<String, Long> blockerHotspots;
    private final Map<String, Long> criticalHotspots;
    private final Map<String, Long> majorHotspots;
    private final Map<String, Long> minorHotspots;
    private final Map<String, Long> infoHotspots;
    private final Map<String, PDImageXObject> iconIssueTypeMap;
    private final Map<String, PDImageXObject> iconSeverityMap;
    private final PDImageXObject iconResource;
    private final PDImageXObject iconTags;
    private final ResourceBundle messages;
    private static final int MAX_ISSUES_IN_RULE_BODY = 16;
    private static final int MAX_ISSUES_IN_FULL_PAGE = 21;
    private final boolean trialLicense;
    private final boolean qualityGateSectionDisabled;
    private final boolean coverageSectionDisabled;

    public ReportEngine(PDDocument pDDocument, PDDocument pDDocument2, PDDocument pDDocument3, String string, String string2, Locale locale, boolean bl, boolean bl2, String string3, WsClient wsClient, boolean bl3) throws IOException, SonarQubeException {
        Object object;
        BufferedImage bufferedImage;
        Fonts fonts;
        this.document = pDDocument;
        this.templateSummary = pDDocument2;
        this.templateIssues = pDDocument3;
        try {
            fonts = new Fonts(pDDocument);
        }
        catch (FontFormatException fontFormatException) {
            LOGGER.warn("Unable to load fonts. Reports may be wrong: {}", (Object)fontFormatException.getMessage());
            fonts = new Fonts();
        }
        this.fonts = fonts;
        this.userLocale = locale;
        this.trialLicense = bl3;
        LOGGER.debug("Creating managers to retrieve information...");
        this.sonarQubeIssueManager = new SonarQubeIssueManager(wsClient, locale);
        this.sonarQubeHotspotManager = new SonarQubeHotspotManager(wsClient);
        this.sonarQubeRuleManager = new SonarQubeRuleManager(wsClient);
        this.sonarQubeServerManager = new SonarQubeServerManager(wsClient);
        this.sonarQubeMeasureManager = new SonarQubeMeasureManager(wsClient, locale);
        SonarQubeProjectManager sonarQubeProjectManager = new SonarQubeProjectManager(wsClient, locale);
        LOGGER.debug("Managers created!");
        LOGGER.info("");
        Instant instant = Instant.now();
        this.sonarQubeProject = ReportUtils.getBasicProjectInformation(wsClient, string);
        this.sonarQubeProject.setKey(string);
        List<ProjectBranches.Branch> list = sonarQubeProjectManager.getProjectBranches(string);
        this.sonarQubeProject.setSonarQubeBranchList(list);
        this.sonarQubeProject.setMainBranch(sonarQubeProjectManager.getProjectMainBranch(list));
        if (string2 == null || string2.isEmpty() || !ReportUtils.branchExists(wsClient, string, string2)) {
            this.branch = this.sonarQubeProject.getMainBranch().getName();
            string2 = this.sonarQubeProject.getMainBranch().getName();
        } else {
            this.branch = string2;
        }
        this.sonarQubeProject.setLastAnalysis(sonarQubeProjectManager.getProjectAnalysisDate(string, string2));
        this.sonarQubeProject.setQualityGate(sonarQubeProjectManager.getProjectStatusResponse(string, string2).getProjectStatus());
        Instant instant2 = Instant.now();
        Double d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("Project information retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.sonarQubeIssuesBreakdown = this.sonarQubeIssueManager.getIssueBreakdown(string, string2, false);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("Issues breakdown retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.projectMeasures = new SonarQubeMeasureManager(wsClient, locale).getMeasuresMap(string, string2, PdfUtils.METRIC_KEYS);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("Measures retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.totalIssues = this.sonarQubeIssueManager.getIssuesByRule(string, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("Issues by rule retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.blockerIssues = this.sonarQubeIssueManager.getIssuesForSeverity(string, BLOCKER, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Blocker issues retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.criticalIssues = this.sonarQubeIssueManager.getIssuesForSeverity(string, CRITICAL, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Critical issues retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.majorIssues = this.sonarQubeIssueManager.getIssuesForSeverity(string, MAJOR, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Major issues retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.minorIssues = this.sonarQubeIssueManager.getIssuesForSeverity(string, MINOR, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Minor issues retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.infoIssues = this.sonarQubeIssueManager.getIssuesForSeverity(string, INFO, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Info issues retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.totalHotpots = this.sonarQubeHotspotManager.getSecurityHotspotsByRule(string, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("Security hotspots by rule retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.blockerHotspots = this.sonarQubeHotspotManager.getSecurityHotspotsForSeverity(string, BLOCKER, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Blocker hotspots retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.criticalHotspots = this.sonarQubeHotspotManager.getSecurityHotspotsForSeverity(string, CRITICAL, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Critical hotspots retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.majorHotspots = this.sonarQubeHotspotManager.getSecurityHotspotsForSeverity(string, MAJOR, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Major hotspots retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.minorHotspots = this.sonarQubeHotspotManager.getSecurityHotspotsForSeverity(string, MINOR, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Minor hotspots retrieved ( {} s )", (Object)d2);
        instant = Instant.now();
        this.infoHotspots = this.sonarQubeHotspotManager.getSecurityHotspotsForSeverity(string, INFO, string2);
        instant2 = Instant.now();
        d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
        LOGGER.info("  Info hotspots retrieved ( {} s )", (Object)d2);
        this.qualityGateSectionDisabled = bl;
        this.coverageSectionDisabled = bl2;
        if (string3.isEmpty()) {
            LOGGER.debug("Loading default footer image from classpath");
            bufferedImage = ImageIO.read(ReportEngine.class.getResourceAsStream("/static/bitegarden.png"));
        } else {
            LOGGER.debug("Loading footer image URL from settings: {}", (Object)string3);
            String string4 = string3;
            try {
                object = new URL(string4);
                bufferedImage = ImageIO.read((URL)object);
            }
            catch (MalformedURLException | IIOException iOException) {
                LOGGER.error("Error loading custom footer image: {}", (Object)string3);
                LOGGER.error("Error: {}", (Object)iOException.getMessage());
                LOGGER.debug("Loading footer error image from classpath");
                bufferedImage = ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/footer-error.png"));
            }
        }
        if (bufferedImage == null) {
            LOGGER.error("Error loading custom footer image: {}", (Object)string3);
            LOGGER.debug("Loading footer error image from classpath");
            bufferedImage = ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/footer-error.png"));
        }
        this.footerScaledWidth = bufferedImage.getHeight() > ReportConstants.MAX_FOOTER_LOGO_HEIGHT ? bufferedImage.getWidth() * ReportConstants.MAX_FOOTER_LOGO_HEIGHT / bufferedImage.getHeight() : bufferedImage.getWidth();
        this.footerScaledHeight = bufferedImage.getHeight() > ReportConstants.MAX_FOOTER_LOGO_HEIGHT ? ReportConstants.MAX_FOOTER_LOGO_HEIGHT.intValue() : bufferedImage.getHeight();
        object = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)object);
        ((OutputStream)object).flush();
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        ((ByteArrayOutputStream)object).close();
        this.pdFooterImage = PDImageXObject.createFromByteArray(pDDocument, byArray, "footer");
        this.iconIssueTypeMap = new HashMap<String, PDImageXObject>();
        this.iconIssueTypeMap.put(BUG, this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/icon-bug.png")), "icon-bug"));
        this.iconIssueTypeMap.put(CODE_SMELL, this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/icon-code_smell.png")), "icon-code_smell"));
        this.iconIssueTypeMap.put(HOTSPOT, this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/icon-hotspot.png")), "icon-hotspot"));
        this.iconIssueTypeMap.put(SECURITY_HOTSPOT, this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/icon-hotspot.png")), "icon-security_hotspot"));
        this.iconIssueTypeMap.put(VULNERABILITY, this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/icon-vulnerability.png")), "icon-vulnerability"));
        this.iconSeverityMap = new HashMap<String, PDImageXObject>();
        this.iconSeverityMap.put("blocker", this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/severity-blocker.png")), "icon-blocker"));
        this.iconSeverityMap.put("critical", this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/severity-critical.png")), "icon-critical"));
        this.iconSeverityMap.put("major", this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/severity-major.png")), "icon-major"));
        this.iconSeverityMap.put("minor", this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/severity-minor.png")), "icon-minor"));
        this.iconSeverityMap.put("info", this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/severity-info.png")), "icon-info"));
        this.iconSeverityMap.put("multiple", this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/severity-multiple.png")), "icon-multiple"));
        this.iconSeverityMap.put("none", this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/severity-none.png")), "icon-none"));
        this.iconResource = this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/resource.png")), "icon-resource");
        this.iconTags = this.generatePDImage(pDDocument, ImageIO.read(ReportEngine.class.getResourceAsStream("/static/images/icon-tag.png")), "icon-tags");
        Locale.setDefault(Locale.ENGLISH);
        this.messages = ResourceBundle.getBundle("org.sonar.l10n.bitegardenReport", locale);
    }

    public void generateExecutiveReport() throws IOException, SonarQubeException {
        PDPage pDPage = this.templateSummary.getPage(0);
        this.document.removePage(0);
        this.document.addPage(pDPage);
        try (PDPageContentStream pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);){
            pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
            this.generateHeader(pDPageContentStream, this.sonarQubeProject, this.projectMeasures, this.branch, this.fonts);
            this.generateMainRatings(pDPageContentStream, this.projectMeasures, this.fonts);
            this.generateOverallSection(pDPageContentStream, this.projectMeasures, this.fonts, this.userLocale);
            this.generateIssuesBySeveritySection(pDPageContentStream, this.sonarQubeIssuesBreakdown, this.userLocale, this.fonts);
            this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), 1);
            this.disableSections(pDPageContentStream);
        }
        this.generateActivityPage(2);
        this.generateLicenseWaterMark(this.document, this.trialLicense);
    }

    public void generateIssuesBreakdownReport() throws SonarQubeException, IOException {
        Rules.Rule rule;
        PDPageContentStream pDPageContentStream;
        PDPage pDPage;
        Long l;
        String string;
        PDPage pDPage2 = this.templateSummary.getPage(0);
        this.document.removePage(0);
        this.document.addPage(pDPage2);
        try (Object object = new PDPageContentStream(this.document, pDPage2, PDPageContentStream.AppendMode.APPEND, true);){
            ((PDPageContentStream)object).setFont(this.fonts.getRegularFont(), 10.0f);
            this.generateHeader((PDPageContentStream)object, this.sonarQubeProject, this.projectMeasures, this.branch, this.fonts);
            this.generateMainRatings((PDPageContentStream)object, this.projectMeasures, this.fonts);
            this.generateOverallSection((PDPageContentStream)object, this.projectMeasures, this.fonts, this.userLocale);
            this.generateIssuesBySeveritySection((PDPageContentStream)object, this.sonarQubeIssuesBreakdown, this.userLocale, this.fonts);
            this.generateFooter((PDPageContentStream)object, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber((PDPageContentStream)object, this.fonts.getRegularFont(), 1);
            this.disableSections((PDPageContentStream)object);
        }
        this.generateActivityPage(2);
        object = this.document.importPage(this.templateIssues.getPage(0));
        try (Object object = new PDPageContentStream(this.document, (PDPage)object, PDPageContentStream.AppendMode.APPEND, true);){
            PdfUtils.drawRightAlignedText((PDPageContentStream)object, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.issues.header"), 515, 802);
            ((PDPageContentStream)object).setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader((PDPageContentStream)object, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            this.generateIssuesByRuleSection((PDPageContentStream)object);
            this.generateFooter((PDPageContentStream)object, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber((PDPageContentStream)object, this.fonts.getRegularFont(), 3);
        }
        object = this.document.importPage(this.templateIssues.getPage(0));
        try (Object object = new PDPageContentStream(this.document, (PDPage)object, PDPageContentStream.AppendMode.APPEND, true);){
            PdfUtils.drawRightAlignedText((PDPageContentStream)object, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.issues.header"), 515, 802);
            ((PDPageContentStream)object).setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader((PDPageContentStream)object, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            this.generateIssuesBySeveritySection((PDPageContentStream)object);
            this.generateFooter((PDPageContentStream)object, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber((PDPageContentStream)object, this.fonts.getRegularFont(), 4);
        }
        object = this.document.importPage(this.templateIssues.getPage(0));
        try (PDPageContentStream pDPageContentStream2 = new PDPageContentStream(this.document, (PDPage)object, PDPageContentStream.AppendMode.APPEND, true);){
            PdfUtils.drawRightAlignedText(pDPageContentStream2, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.hotspots.header"), 515, 802);
            pDPageContentStream2.setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader(pDPageContentStream2, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            this.generateHotspotByRuleSection(pDPageContentStream2);
            this.generateFooter(pDPageContentStream2, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber(pDPageContentStream2, this.fonts.getRegularFont(), 5);
        }
        int n = 6;
        for (Map.Entry<String, Long> entry : this.blockerIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, BLOCKER, false);
                this.generateRuleSummaryIssuesBody(pDPageContentStream, string, BLOCKER);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.blockerHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, BLOCKER, true);
                this.generateRuleSummaryHotspotsBody(pDPageContentStream, string);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.criticalIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, CRITICAL, false);
                this.generateRuleSummaryIssuesBody(pDPageContentStream, string, CRITICAL);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.criticalHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, CRITICAL, true);
                this.generateRuleSummaryHotspotsBody(pDPageContentStream, string);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.majorIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, MAJOR, false);
                this.generateRuleSummaryIssuesBody(pDPageContentStream, string, MAJOR);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.majorHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, MAJOR, true);
                this.generateRuleSummaryHotspotsBody(pDPageContentStream, string);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.minorIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, MINOR, false);
                this.generateRuleSummaryIssuesBody(pDPageContentStream, string, MINOR);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.minorHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, MINOR, true);
                this.generateRuleSummaryHotspotsBody(pDPageContentStream, string);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.infoIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, INFO, false);
                this.generateRuleSummaryIssuesBody(pDPageContentStream, string, INFO);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        for (Map.Entry<String, Long> entry : this.infoHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            pDPage = this.document.importPage(this.templateIssues.getPage(1));
            pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            try {
                pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                rule = this.sonarQubeRuleManager.getRule(string);
                this.generateRuleHeader(pDPageContentStream, rule, l, INFO, true);
                this.generateRuleSummaryHotspotsBody(pDPageContentStream, string);
                this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                ++n;
            }
            finally {
                pDPageContentStream.close();
            }
        }
        this.generateLicenseWaterMark(this.document, this.trialLicense);
    }

    public void generateFullIssuesBreakdownReport() throws SonarQubeException, IOException {
        List<GeneratedMessageV3> list;
        Long l;
        String string;
        PDPage pDPage = this.templateSummary.getPage(0);
        this.document.removePage(0);
        this.document.addPage(pDPage);
        try (Object object = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);){
            ((PDPageContentStream)object).setFont(this.fonts.getRegularFont(), 10.0f);
            this.generateHeader((PDPageContentStream)object, this.sonarQubeProject, this.projectMeasures, this.branch, this.fonts);
            this.generateMainRatings((PDPageContentStream)object, this.projectMeasures, this.fonts);
            this.generateOverallSection((PDPageContentStream)object, this.projectMeasures, this.fonts, this.userLocale);
            this.generateIssuesBySeveritySection((PDPageContentStream)object, this.sonarQubeIssuesBreakdown, this.userLocale, this.fonts);
            this.generateFooter((PDPageContentStream)object, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber((PDPageContentStream)object, this.fonts.getRegularFont(), 1);
            this.disableSections((PDPageContentStream)object);
        }
        this.generateActivityPage(2);
        object = this.document.importPage(this.templateIssues.getPage(0));
        try (Object object = new PDPageContentStream(this.document, (PDPage)object, PDPageContentStream.AppendMode.APPEND, true);){
            PdfUtils.drawRightAlignedText((PDPageContentStream)object, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.issues.header"), 515, 802);
            ((PDPageContentStream)object).setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader((PDPageContentStream)object, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            this.generateIssuesByRuleSection((PDPageContentStream)object);
            this.generateFooter((PDPageContentStream)object, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber((PDPageContentStream)object, this.fonts.getRegularFont(), 3);
        }
        object = this.document.importPage(this.templateIssues.getPage(0));
        try (Object object = new PDPageContentStream(this.document, (PDPage)object, PDPageContentStream.AppendMode.APPEND, true);){
            PdfUtils.drawRightAlignedText((PDPageContentStream)object, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.issues.header"), 515, 802);
            ((PDPageContentStream)object).setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader((PDPageContentStream)object, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            this.generateIssuesBySeveritySection((PDPageContentStream)object);
            this.generateFooter((PDPageContentStream)object, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber((PDPageContentStream)object, this.fonts.getRegularFont(), 4);
        }
        object = this.document.importPage(this.templateIssues.getPage(0));
        try (PDPageContentStream pDPageContentStream = new PDPageContentStream(this.document, (PDPage)object, PDPageContentStream.AppendMode.APPEND, true);){
            PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.hotspots.header"), 515, 802);
            pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            this.generateHotspotByRuleSection(pDPageContentStream);
            this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), 5);
        }
        int n = 6;
        for (Map.Entry<String, Long> entry : this.blockerIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeIssueManager.getIssuesForRule(this.sonarQubeProject.getKey(), BLOCKER, string, this.branch);
            n = this.generateFullIssuesBreakdownFirstPage(n, string, l, list, BLOCKER, false);
            n = this.generateFullIssuesBreakdownPages(n, string, list, false);
        }
        for (Map.Entry<String, Long> entry : this.blockerHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeHotspotManager.getSecurityHotspotsForRule(this.sonarQubeProject.getKey(), string, this.branch);
            n = this.generateFullHotspotsBreakdownFirstPage(n, string, l, list, BLOCKER);
            n = this.generateFullHotspotsBreakdownPages(n, string, list);
        }
        for (Map.Entry<String, Long> entry : this.criticalIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeIssueManager.getIssuesForRule(this.sonarQubeProject.getKey(), CRITICAL, string, this.branch);
            n = this.generateFullIssuesBreakdownFirstPage(n, string, l, list, CRITICAL, false);
            n = this.generateFullIssuesBreakdownPages(n, string, list, false);
        }
        for (Map.Entry<String, Long> entry : this.criticalHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeHotspotManager.getSecurityHotspotsForRule(this.sonarQubeProject.getKey(), string, this.branch);
            n = this.generateFullHotspotsBreakdownFirstPage(n, string, l, list, CRITICAL);
            n = this.generateFullHotspotsBreakdownPages(n, string, list);
        }
        for (Map.Entry<String, Long> entry : this.majorIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeIssueManager.getIssuesForRule(this.sonarQubeProject.getKey(), MAJOR, string, this.branch);
            n = this.generateFullIssuesBreakdownFirstPage(n, string, l, list, MAJOR, false);
            n = this.generateFullIssuesBreakdownPages(n, string, list, false);
        }
        for (Map.Entry<String, Long> entry : this.majorHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeHotspotManager.getSecurityHotspotsForRule(this.sonarQubeProject.getKey(), string, this.branch);
            n = this.generateFullHotspotsBreakdownFirstPage(n, string, l, list, MAJOR);
            n = this.generateFullHotspotsBreakdownPages(n, string, list);
        }
        for (Map.Entry<String, Long> entry : this.minorIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeIssueManager.getIssuesForRule(this.sonarQubeProject.getKey(), MINOR, string, this.branch);
            n = this.generateFullIssuesBreakdownFirstPage(n, string, l, list, MINOR, false);
            n = this.generateFullIssuesBreakdownPages(n, string, list, false);
        }
        for (Map.Entry<String, Long> entry : this.minorHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeHotspotManager.getSecurityHotspotsForRule(this.sonarQubeProject.getKey(), string, this.branch);
            n = this.generateFullHotspotsBreakdownFirstPage(n, string, l, list, MINOR);
            n = this.generateFullHotspotsBreakdownPages(n, string, list);
        }
        for (Map.Entry<String, Long> entry : this.infoIssues.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeIssueManager.getIssuesForRule(this.sonarQubeProject.getKey(), INFO, string, this.branch);
            n = this.generateFullIssuesBreakdownFirstPage(n, string, l, list, INFO, false);
            n = this.generateFullIssuesBreakdownPages(n, string, list, false);
        }
        for (Map.Entry<String, Long> entry : this.infoHotspots.entrySet()) {
            string = entry.getKey();
            l = entry.getValue();
            list = this.sonarQubeHotspotManager.getSecurityHotspotsForRule(this.sonarQubeProject.getKey(), string, this.branch);
            n = this.generateFullHotspotsBreakdownFirstPage(n, string, l, list, INFO);
            n = this.generateFullHotspotsBreakdownPages(n, string, list);
        }
        this.generateLicenseWaterMark(this.document, this.trialLicense);
    }

    private int generateFullIssuesBreakdownFirstPage(int n, String string, Long l, List<Issues.Issue> list, String string2, boolean bl) throws IOException, SonarQubeException {
        PDPage pDPage = this.document.importPage(this.templateIssues.getPage(1));
        try (PDPageContentStream pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);){
            pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            Rules.Rule rule = this.sonarQubeRuleManager.getRule(string);
            this.generateRuleHeader(pDPageContentStream, rule, l, string2, bl);
            this.generateRuleFullIssuesBody(pDPageContentStream, list);
            this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
        }
        return ++n;
    }

    private int generateFullHotspotsBreakdownFirstPage(int n, String string, Long l, List<Hotspots.ShowWsResponse> list, String string2) throws IOException, SonarQubeException {
        PDPage pDPage = this.document.importPage(this.templateIssues.getPage(1));
        try (PDPageContentStream pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);){
            pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            Rules.Rule rule = this.sonarQubeRuleManager.getRule(string);
            this.generateRuleHeader(pDPageContentStream, rule, l, string2, true);
            this.generateRuleFullHotspotsBody(pDPageContentStream, list);
            this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
        }
        return ++n;
    }

    private int generateFullIssuesBreakdownPages(int n, String string, List<Issues.Issue> list, boolean bl) throws IOException {
        if (list.size() > 16) {
            int n2 = (int)Math.ceil((double)(list.size() - 16) / 21.0);
            for (int i = 0; i < n2; ++i) {
                PDPage pDPage = this.document.importPage(this.templateIssues.getPage(2));
                try (PDPageContentStream pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);){
                    pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                    PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                    PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getBoldFont(), 16, string.substring(string.indexOf(58) + 1), 515, 802);
                    String string2 = this.getRuleType(string);
                    if (!bl && (HOTSPOT.equals(string2) || SECURITY_HOTSPOT.equals(string2))) {
                        string2 = VULNERABILITY;
                    }
                    PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getRegularFont(), 8, this.messages.getString("reporting.pdf.breakdown.rule." + string2 + ".header"), 515, 807);
                    this.generateRuleFullIssuesPage(pDPageContentStream, list, i * 21 + 16);
                    this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                    this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                    ++n;
                    continue;
                }
            }
        }
        return n;
    }

    private int generateFullHotspotsBreakdownPages(int n, String string, List<Hotspots.ShowWsResponse> list) throws IOException {
        if (list.size() > 16) {
            int n2 = (int)Math.ceil((double)(list.size() - 16) / 21.0);
            for (int i = 0; i < n2; ++i) {
                PDPage pDPage = this.document.importPage(this.templateIssues.getPage(2));
                try (PDPageContentStream pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);){
                    pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
                    PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
                    PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getBoldFont(), 16, string.substring(string.indexOf(58) + 1), 515, 802);
                    String string2 = this.getRuleType(string);
                    PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getRegularFont(), 8, this.messages.getString("reporting.pdf.breakdown.rule." + string2 + ".header"), 515, 807);
                    this.generateRuleFullHotspotsPage(pDPageContentStream, list, i * 21 + 16);
                    this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
                    this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
                    ++n;
                    continue;
                }
            }
        }
        return n;
    }

    private void generateRuleSummaryIssuesBody(PDPageContentStream pDPageContentStream, String string, String string2) throws SonarQubeException {
        List<Issues.Issue> list = this.sonarQubeIssueManager.getIssuesForRule(this.sonarQubeProject.getKey(), string2, string, this.branch);
        this.drawSummaryIssuesInRuleBody(pDPageContentStream, 30, 16, list);
    }

    private void generateRuleSummaryHotspotsBody(PDPageContentStream pDPageContentStream, String string) throws SonarQubeException {
        List<Hotspots.ShowWsResponse> list = this.sonarQubeHotspotManager.getSecurityHotspotsForRule(this.sonarQubeProject.getKey(), string, this.branch);
        this.drawSummaryHostpostsInRuleBody(pDPageContentStream, 30, 16, list);
    }

    private void generateRuleFullIssuesBody(PDPageContentStream pDPageContentStream, List<Issues.Issue> list) {
        this.drawIssuesInRuleBody(pDPageContentStream, 30, list);
    }

    private void generateRuleFullHotspotsBody(PDPageContentStream pDPageContentStream, List<Hotspots.ShowWsResponse> list) {
        this.drawHotspotsInRuleBody(pDPageContentStream, 30, list);
    }

    private void generateRuleFullIssuesPage(PDPageContentStream pDPageContentStream, List<Issues.Issue> list, int n) {
        this.drawIssuesInFullPage(pDPageContentStream, 30, list, n);
    }

    private void generateRuleFullHotspotsPage(PDPageContentStream pDPageContentStream, List<Hotspots.ShowWsResponse> list, int n) {
        this.drawHotspotsInFullPage(pDPageContentStream, 30, list, n);
    }

    private void generateRuleHeader(PDPageContentStream pDPageContentStream, Rules.Rule rule, Long l, String string, boolean bl) throws IOException {
        Object object;
        CharSequence charSequence;
        String string2 = rule.getType().name().toLowerCase();
        if (!bl && (HOTSPOT.equals(string2) || SECURITY_HOTSPOT.equals(string2))) {
            string2 = VULNERABILITY;
        }
        LOGGER.debug("Generating rule header for: {}", (Object)rule.getKey());
        String string3 = rule.getKey();
        if (rule.getKey().indexOf(58) != -1) {
            string3 = rule.getKey().substring(rule.getKey().indexOf(58) + 1);
        }
        PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getBoldFont(), 16, string3, 515, 802);
        PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getRegularFont(), 8, this.messages.getString("reporting.pdf.breakdown.rule." + string2 + ".header"), 515, 807);
        String string4 = string.toLowerCase();
        PdfUtils.drawIcon(pDPageContentStream, this.iconSeverityMap.get(string4), 26, 685, 20, 20);
        String string5 = rule.getName();
        try {
            if (string5.length() > 70) {
                int n = string5.indexOf(32, 50);
                if (n != -1) {
                    charSequence = string5.substring(0, n).trim();
                    object = string5.substring(n).trim();
                    if (((String)object).length() > 70) {
                        object = ((String)object).substring(60) + " ...";
                    }
                    PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 12, (String)charSequence, 53, 690);
                    PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 12, (String)object, 53, 674);
                } else {
                    PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 12, string5.substring(60) + " ...", 53, 690);
                }
            } else {
                PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 12, rule.getName(), 53, 690);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LOGGER.warn("Error processing rule {} name in header: {}", (Object)rule.getKey(), (Object)string5);
            LOGGER.warn("Error message: {}", (Object)stringIndexOutOfBoundsException.getMessage());
        }
        PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getRegularFont(), 10, rule.getLang(), 454, 705);
        PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 12, FormatUtils.getNumber(this.userLocale).format(l), 529, 705);
        PdfUtils.drawIcon(pDPageContentStream, this.iconIssueTypeMap.get(string2), 485, 685, 20, 20);
        String string6 = Jsoup.parse(rule.getHtmlDesc()).text();
        try {
            PdfUtils.drawTextBlock(pDPageContentStream, this.fonts.getRegularFont(), 9, string6, 53, 655, 4, 120);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LOGGER.warn("Error processing rule {} description in header: {}", (Object)rule.getKey(), (Object)string6);
            LOGGER.warn("Error message: {}", (Object)stringIndexOutOfBoundsException.getMessage());
        }
        charSequence = new StringBuilder();
        object = rule.getSysTags();
        for (Object object2 : ((Rules.SysTags)object).getSysTagsList()) {
            ((StringBuilder)charSequence).append((String)object2).append("    ");
        }
        Rules.Tags tags = rule.getTags();
        for (String string7 : tags.getTagsList()) {
            ((StringBuilder)charSequence).append(string7).append("    ");
        }
        if (((StringBuilder)charSequence).length() > 0) {
            PdfUtils.drawIcon(pDPageContentStream, this.iconTags, 31, 602, 12, 12);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 9, ((StringBuilder)charSequence).toString(), 53, 605);
        }
    }

    private void generateIssuesByRuleSection(PDPageContentStream pDPageContentStream) throws IOException, SonarQubeException {
        Object object;
        PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.topissues.title"), 53, 690);
        String[] stringArray = this.totalIssues.keySet().toArray(new String[0]);
        for (String string : stringArray) {
            object = this.getActiveSeverityForIssue(string).toLowerCase();
            if (!"none".equals(object)) continue;
            LOGGER.debug("Removing security hotspot {} because it is not an issue yet!", (Object)string);
            this.totalIssues.remove(string);
        }
        stringArray = this.totalIssues.keySet().toArray(new String[0]);
        Object[] objectArray = this.totalIssues.values().toArray(new Long[0]);
        int n = 14;
        for (int i = 0; i < this.totalIssues.size(); ++i) {
            String string;
            if (i == 36) {
                PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, "... ... ...", 85, 645 - i * n);
                break;
            }
            string = stringArray[i];
            object = objectArray[i];
            Rules.Rule rule = this.sonarQubeRuleManager.getRule(string);
            String string2 = this.getActiveSeverityForIssue(string).toLowerCase();
            if (this.hasMultipleSeverities(string)) {
                string2 = "multiple";
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconSeverityMap.get(string2), 60, 649 - i * n, 8, 8);
            String string3 = rule.getName();
            if (string3.length() > 95) {
                string3 = string3.substring(0, 95) + "...";
            }
            string3 = string3 + " (" + rule.getLang() + ") ";
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string3, 85, 650 - i * n);
            String string4 = rule.getType().name().toLowerCase();
            if (HOTSPOT.equals(string4) || SECURITY_HOTSPOT.equals(string4)) {
                string4 = VULNERABILITY;
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconIssueTypeMap.get(string4), 464, 648 - i * n, 10, 10);
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getRegularFont(), 8, FormatUtils.getNumber(this.userLocale).format(object), 530, 661 - i * n);
        }
        if (this.totalIssues.size() == 0) {
            pDPageContentStream.setNonStrokingColor(0.2890625f, 0.6484375f, 0.1875f);
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 14, this.messages.getString("reporting.pdf.breakdown.noissues"), 297, 571);
        }
    }

    private void generateHotspotByRuleSection(PDPageContentStream pDPageContentStream) throws IOException, SonarQubeException {
        PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.tophotspots.title"), 53, 690);
        String[] stringArray = this.totalHotpots.keySet().toArray(new String[0]);
        Long[] longArray = this.totalHotpots.values().toArray(new Long[0]);
        int n = 14;
        for (int i = 0; i < this.totalHotpots.size(); ++i) {
            if (i == 36) {
                PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, "... ... ...", 85, 645 - i * n);
                break;
            }
            String string = stringArray[i];
            Long l = longArray[i];
            Rules.Rule rule = this.sonarQubeRuleManager.getRule(string);
            String string2 = this.getActiveSeverityForHotSpot(string).toLowerCase();
            if (this.hasMultipleSeverities(string)) {
                string2 = "multiple";
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconSeverityMap.get(string2), 60, 649 - i * n, 8, 8);
            String string3 = rule.getName();
            if (string3.length() > 95) {
                string3 = string3.substring(0, 95) + "...";
            }
            string3 = string3 + " (" + rule.getLang() + ") ";
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string3, 85, 650 - i * n);
            String string4 = rule.getType().name().toLowerCase();
            PdfUtils.drawIcon(pDPageContentStream, this.iconIssueTypeMap.get(string4), 464, 648 - i * n, 10, 10);
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getRegularFont(), 8, FormatUtils.getNumber(this.userLocale).format(l), 530, 661 - i * n);
        }
        if (this.totalHotpots.size() == 0) {
            pDPageContentStream.setNonStrokingColor(0.2890625f, 0.6484375f, 0.1875f);
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 14, this.messages.getString("reporting.pdf.breakdown.nohotspots"), 297, 571);
        }
    }

    private void generateIssuesBySeveritySection(PDPageContentStream pDPageContentStream) throws IOException, SonarQubeException {
        PdfUtils.drawText(pDPageContentStream, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.breakdown.issuesbyseverity.title"), 53, 690);
        int n = 14;
        int n2 = 36;
        int n3 = 0;
        this.drawRules(pDPageContentStream, n, n2, 0, this.blockerIssues, BLOCKER);
        this.drawRules(pDPageContentStream, n, n2 - (n3 += this.blockerIssues.size()), n3, this.criticalIssues, CRITICAL);
        this.drawRules(pDPageContentStream, n, n2 - (n3 += this.criticalIssues.size()), n3, this.majorIssues, MAJOR);
        this.drawRules(pDPageContentStream, n, n2 - (n3 += this.majorIssues.size()), n3, this.minorIssues, MINOR);
        this.drawRules(pDPageContentStream, n, n2 - (n3 += this.minorIssues.size()), n3, this.infoIssues, INFO);
        if ((n3 += this.infoIssues.size()) == 0) {
            pDPageContentStream.setNonStrokingColor(0.2890625f, 0.6484375f, 0.1875f);
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 14, this.messages.getString("reporting.pdf.breakdown.noissues"), 297, 571);
        }
    }

    private void drawSummaryIssuesInRuleBody(PDPageContentStream pDPageContentStream, int n, int n2, List<Issues.Issue> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (i == n2) {
                PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, "... ... ...", 53, 550 - i * n);
                break;
            }
            Issues.Issue issue = list.get(i);
            String string = issue.getMessage();
            if (string.length() > 110) {
                string = string.substring(0, 110) + "...";
            }
            String string2 = issue.getComponent();
            if ((string2 = string2.substring(string2.lastIndexOf(58) + 1)).length() > 110) {
                string2 = "..." + string2.substring(string2.length() - 110);
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconResource, 40, 538 - i * n, 8, 8);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getLightFont(), 8, string2, 53, 540 - i * n);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string, 53, 530 - i * n);
            if (issue.getLine() == 0) continue;
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 8, "L" + issue.getLine(), 530, 551 - i * n);
        }
    }

    private void drawSummaryHostpostsInRuleBody(PDPageContentStream pDPageContentStream, int n, int n2, List<Hotspots.ShowWsResponse> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (i == n2) {
                PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, "... ... ...", 53, 550 - i * n);
                break;
            }
            Hotspots.ShowWsResponse showWsResponse = list.get(i);
            String string = showWsResponse.getMessage();
            if (string.length() > 110) {
                string = string.substring(0, 110) + "...";
            }
            String string2 = showWsResponse.hasComponent() ? showWsResponse.getComponent().getPath() : showWsResponse.getProject().getPath();
            if ((string2 = string2.substring(string2.lastIndexOf(58) + 1)).length() > 110) {
                string2 = "..." + string2.substring(string2.length() - 110);
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconResource, 40, 538 - i * n, 8, 8);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getLightFont(), 8, string2, 53, 540 - i * n);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string, 53, 530 - i * n);
            if (showWsResponse.getLine() == 0) continue;
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 8, "L" + showWsResponse.getLine(), 530, 551 - i * n);
        }
    }

    private void drawIssuesInRuleBody(PDPageContentStream pDPageContentStream, int n, List<Issues.Issue> list) {
        for (int i = 0; i < list.size() && i != 16; ++i) {
            Issues.Issue issue = list.get(i);
            String string = issue.getMessage();
            if (string.length() > 110) {
                string = string.substring(0, 110) + "...";
            }
            String string2 = issue.getComponent();
            if ((string2 = string2.substring(string2.lastIndexOf(58) + 1)).length() > 110) {
                string2 = "..." + string2.substring(string2.length() - 110);
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconResource, 40, 538 - i * n, 8, 8);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getLightFont(), 8, string2, 53, 540 - i * n);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string, 53, 530 - i * n);
            if (issue.getLine() == 0) continue;
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 8, "L" + issue.getLine(), 530, 551 - i * n);
        }
    }

    private void drawHotspotsInRuleBody(PDPageContentStream pDPageContentStream, int n, List<Hotspots.ShowWsResponse> list) {
        for (int i = 0; i < list.size() && i != 16; ++i) {
            Hotspots.ShowWsResponse showWsResponse = list.get(i);
            String string = showWsResponse.getMessage();
            if (string.length() > 110) {
                string = string.substring(0, 110) + "...";
            }
            String string2 = showWsResponse.hasComponent() ? showWsResponse.getComponent().getPath() : showWsResponse.getProject().getPath();
            if ((string2 = string2.substring(string2.lastIndexOf(58) + 1)).length() > 110) {
                string2 = "..." + string2.substring(string2.length() - 110);
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconResource, 40, 538 - i * n, 8, 8);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getLightFont(), 8, string2, 53, 540 - i * n);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string, 53, 530 - i * n);
            if (showWsResponse.getLine() == 0) continue;
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 8, "L" + showWsResponse.getLine(), 530, 551 - i * n);
        }
    }

    private void drawIssuesInFullPage(PDPageContentStream pDPageContentStream, int n, List<Issues.Issue> list, int n2) {
        for (int i = n2; i < list.size() && i != 21 + n2; ++i) {
            Issues.Issue issue = list.get(i);
            String string = issue.getMessage();
            if (string.length() > 110) {
                string = string.substring(0, 110) + "...";
            }
            String string2 = issue.getComponent();
            if ((string2 = string2.substring(string2.lastIndexOf(58) + 1)).length() > 110) {
                string2 = "..." + string2.substring(string2.length() - 110);
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconResource, 40, 685 - (i - n2) * n, 8, 8);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getLightFont(), 8, string2, 53, 687 - (i - n2) * n);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string, 53, 677 - (i - n2) * n);
            if (issue.getLine() == 0) continue;
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 8, "L" + issue.getLine(), 530, 698 - (i - n2) * n);
        }
    }

    private void drawHotspotsInFullPage(PDPageContentStream pDPageContentStream, int n, List<Hotspots.ShowWsResponse> list, int n2) {
        for (int i = n2; i < list.size() && i != 21 + n2; ++i) {
            Hotspots.ShowWsResponse showWsResponse = list.get(i);
            String string = showWsResponse.getMessage();
            if (string.length() > 110) {
                string = string.substring(0, 110) + "...";
            }
            String string2 = showWsResponse.hasComponent() ? showWsResponse.getComponent().getPath() : showWsResponse.getProject().getPath();
            if ((string2 = string2.substring(string2.lastIndexOf(58) + 1)).length() > 110) {
                string2 = "..." + string2.substring(string2.length() - 110);
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconResource, 40, 685 - (i - n2) * n, 8, 8);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getLightFont(), 8, string2, 53, 687 - (i - n2) * n);
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string, 53, 677 - (i - n2) * n);
            if (showWsResponse.getLine() == 0) continue;
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getBoldFont(), 8, "L" + showWsResponse.getLine(), 530, 698 - (i - n2) * n);
        }
    }

    private void drawRules(PDPageContentStream pDPageContentStream, int n, int n2, int n3, Map<String, Long> map, String string) throws SonarQubeException {
        String[] stringArray = map.keySet().toArray(new String[0]);
        Long[] longArray = map.values().toArray(new Long[0]);
        for (int i = 0; i < map.size(); ++i) {
            if (i == n2) {
                PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, "... ... ...", 85, 650 - (i + n3) * n);
                break;
            }
            if (i > n2) break;
            String string2 = stringArray[i];
            Long l = longArray[i];
            Rules.Rule rule = this.sonarQubeRuleManager.getRule(string2);
            String string3 = string.toLowerCase();
            PdfUtils.drawIcon(pDPageContentStream, this.iconSeverityMap.get(string3), 60, 649 - (i + n3) * n, 8, 8);
            String string4 = rule.getName();
            if (string4.length() > 95) {
                string4 = string4.substring(0, 95) + "...";
            }
            string4 = string4 + " (" + rule.getLang() + ") ";
            PdfUtils.drawText(pDPageContentStream, this.fonts.getRegularFont(), 8, string4, 85, 650 - (i + n3) * n);
            String string5 = rule.getType().name().toLowerCase();
            if (HOTSPOT.equals(string5) || SECURITY_HOTSPOT.equals(string5)) {
                string5 = VULNERABILITY;
            }
            PdfUtils.drawIcon(pDPageContentStream, this.iconIssueTypeMap.get(string5), 464, 648 - (i + n3) * n, 10, 10);
            PdfUtils.drawCenterText(pDPageContentStream, this.fonts.getRegularFont(), 8, FormatUtils.getNumber(this.userLocale).format(l), 530, 661 - (i + n3) * n);
        }
    }

    private void generateHeader(PDPageContentStream pDPageContentStream, SonarQubeProject sonarQubeProject, Map<String, String> map, String string, Fonts fonts) throws IOException {
        LOGGER.trace("Generating header...");
        String string2 = sonarQubeProject.getName();
        String string3 = sonarQubeProject.getLastAnalysis();
        String string4 = sonarQubeProject.getQualityGate().getStatus().name();
        String string5 = map.get("size_rating");
        String string6 = map.get("ncloc");
        String string7 = this.messages.getString("reporting.pdf.report.project.version.label");
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, string2, 53, 742);
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, string3, 458, 742);
        PdfUtils.writeProjectVersionInfo(sonarQubeProject, fonts, string7, pDPageContentStream, 314, 705, true);
        if (string == null) {
            string = sonarQubeProject.getMainBranch().getName();
        }
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, string, 314, 742);
        String string8 = "E";
        if ("OK".equals(string4)) {
            string4 = this.messages.getString("reporting.pdf.quality.gate.status.PASSED");
            string8 = "A";
        } else {
            string4 = this.messages.getString("reporting.pdf.quality.gate.status.FAILED");
        }
        for (int i = 0; i < string4.length() * 6; ++i) {
            PdfUtils.drawEmptyRatingCircle(pDPageContentStream, 467 + i, 705, 9, string8);
        }
        pDPageContentStream.setNonStrokingColor(Color.WHITE);
        PdfUtils.drawText(pDPageContentStream, fonts.getRegularFont(), 10, string4, 466, 702);
        PdfUtils.drawSizeRatingCircle(pDPageContentStream, 69, 705, 12);
        pDPageContentStream.setNonStrokingColor(Color.WHITE);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getLightFont(), 12, string5, 69, 717);
        pDPageContentStream.setNonStrokingColor(Color.BLACK);
        PdfUtils.drawText(pDPageContentStream, fonts.getBoldFont(), 24, string6, 135, 698);
        LOGGER.trace("Header Done!");
    }

    private void generateLicenseWaterMark(PDDocument pDDocument, boolean bl) throws IOException {
        if (bl) {
            LOGGER.debug("Generating watermark...");
            String string = "/static/templates/trial-watermark_en.pdf";
            if (this.userLocale.getLanguage().equals("es")) {
                string = "/static/templates/trial-watermark_es.pdf";
            }
            try (Overlay overlay = new Overlay();){
                PDDocument pDDocument2 = PDDocument.load(ReportEngine.class.getResourceAsStream(string));
                HashMap<Integer, PDDocument> hashMap = new HashMap<Integer, PDDocument>();
                for (int i = 0; i < pDDocument.getNumberOfPages(); ++i) {
                    hashMap.put(i + 1, pDDocument2);
                }
                overlay.setInputPDF(pDDocument);
                overlay.setOverlayPosition(Overlay.Position.FOREGROUND);
                overlay.overlayDocuments(hashMap);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to generate trial watermark in PDF", iOException);
            }
            LOGGER.debug("Watermark Done!");
        }
    }

    private void generateMainRatings(PDPageContentStream pDPageContentStream, Map<String, String> map, Fonts fonts) throws IOException {
        LOGGER.debug("Generating main quality model section...");
        String string = map.get("reliability_rating");
        String string2 = map.get("security_rating");
        String string3 = map.get("sqale_rating");
        PdfUtils.drawRatingCircle(pDPageContentStream, 101, 612, 25, string, fonts.getLightFont());
        PdfUtils.drawRatingCircle(pDPageContentStream, 295, 612, 25, string2, fonts.getLightFont());
        PdfUtils.drawRatingCircle(pDPageContentStream, 486, 612, 25, string3, fonts.getLightFont());
        LOGGER.debug("Done!");
    }

    private void generateOverallSection(PDPageContentStream pDPageContentStream, Map<String, String> map, Fonts fonts, Locale locale) throws IOException {
        Object object;
        PDFont pDFont = fonts.getBoldFont();
        PDFont pDFont2 = fonts.getLightFont();
        LOGGER.debug("Generating overall section...");
        LOGGER.debug("           ... drawing bugs ...");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 24, map.get("bugs"), 101, 570);
        LOGGER.debug("           ... drawing vulnerabilities ...");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 24, map.get("vulnerabilities"), 295, 570);
        LOGGER.debug("           ... drawing code smells ...");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 24, map.get("code_smells"), 486, 570);
        LOGGER.debug("           ... drawing security hotspots ...");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 24, map.get("security_hotspots"), 295, 525);
        LOGGER.debug("           ... drawing debt ratio ...");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 24, map.get("sqale_debt_ratio") + "%", 486, 525);
        map.putIfAbsent("coverage", "0");
        try {
            object = NumberFormat.getInstance(locale).parse(map.get("coverage")).doubleValue();
            LOGGER.debug("           ... drawing coverage circle ... {}", object);
            if (!((Double)object).isNaN()) {
                PdfUtils.drawCoverage(pDPageContentStream, 295, 275, 25, 20, (Double)object);
            }
        }
        catch (ParseException parseException) {
            LOGGER.error("Error parsing coverage: {}", (Object)map.get("coverage"), (Object)parseException);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error drawing coverage circle: {}", (Object)throwable.getMessage());
        }
        LOGGER.debug("           ... drawing coverage ... ");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 24, map.get("coverage") + "%", 295, 255);
        map.putIfAbsent("tests", "0");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("tests"), 295, 190);
        try {
            object = NumberFormat.getInstance(locale).parse(map.get("duplicated_lines_density")).doubleValue();
            LOGGER.debug("           ... drawing duplicated rating circle ... {}", object);
            if (!((Double)object).isNaN()) {
                PdfUtils.drawDuplicatedRatingCircle(pDPageContentStream, 486, 275, 25, (Double)object);
            }
        }
        catch (ParseException parseException) {
            LOGGER.error("Error parsing duplicated lines density: {}", (Object)map.get("duplicated_lines_density"), (Object)parseException);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error drawing duplicated rating circle: {}", (Object)throwable.getMessage());
        }
        LOGGER.debug("           ... drawing duplicated density ... ");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 24, map.get("duplicated_lines_density") + "%", 486, 255);
        LOGGER.debug("           ... drawing duplicated blocks ... ");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("duplicated_blocks"), 486, 190);
        LOGGER.debug("           ... drawing new bugs ... ");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("new_bugs-period1"), 101, 430);
        LOGGER.debug("           ... drawing new vulnerabilities ... ");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("new_vulnerabilities-period1"), 295, 430);
        LOGGER.debug("           ... drawing new code smells ... ");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("new_code_smells-period1"), 486, 430);
        LOGGER.debug("           ... drawing new hotspots ... ");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("new_security_hotspots-period1"), 295, 395);
        LOGGER.debug("           ... drawing new debt ratio ... ");
        map.putIfAbsent("new_sqale_debt_ratio-period1", "0");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("new_sqale_debt_ratio-period1"), 486, 395);
        LOGGER.debug("           ... drawing new maintainability rating ... ");
        object = map.get("new_maintainability_rating-period1");
        if (object != null) {
            PdfUtils.drawRatingCircle(pDPageContentStream, 486, 447, 12, (String)object, pDFont2);
        } else {
            PdfUtils.drawNullRatingCircle(pDPageContentStream, 486, 447, 12, pDFont2);
        }
        LOGGER.debug("           ... drawing new reliability rating ... ");
        String string = map.get("new_reliability_rating-period1");
        if (string != null) {
            PdfUtils.drawRatingCircle(pDPageContentStream, 101, 447, 12, string, pDFont2);
        } else {
            PdfUtils.drawNullRatingCircle(pDPageContentStream, 101, 447, 12, pDFont2);
        }
        LOGGER.debug("           ... drawing new security rating ... ");
        String string2 = map.get("new_security_rating-period1");
        if (string2 != null) {
            PdfUtils.drawRatingCircle(pDPageContentStream, 295, 447, 12, string2, pDFont2);
        } else {
            PdfUtils.drawNullRatingCircle(pDPageContentStream, 295, 447, 12, pDFont2);
        }
        LOGGER.debug("           ... drawing new coverage ... ");
        map.putIfAbsent("new_coverage-period1", "0");
        LOGGER.debug("           ... drawing new duplication density ... ");
        map.putIfAbsent("new_duplicated_lines_density-period1", "0");
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("new_coverage-period1"), 295, 146);
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 18, map.get("new_duplicated_lines_density-period1"), 486, 146);
        LOGGER.debug("Overall Section generated!");
    }

    private void generateIssuesBySeveritySection(PDPageContentStream pDPageContentStream, SonarQubeIssuesBreakdown sonarQubeIssuesBreakdown, Locale locale, Fonts fonts) {
        LOGGER.debug("Generating issues by severity section...");
        Long l = sonarQubeIssuesBreakdown.getTotalBlockerBugsIssues();
        Long l2 = sonarQubeIssuesBreakdown.getTotalBlockerVulnerabilitiesIssues();
        Long l3 = sonarQubeIssuesBreakdown.getTotalBlockerCodeSmellsIssues();
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getBoldFont(), 10, FormatUtils.getNumber(locale).format(l), 68, 269);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getBoldFont(), 10, FormatUtils.getNumber(locale).format(l2), 112, 269);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getBoldFont(), 10, FormatUtils.getNumber(locale).format(l3), 158, 269);
        Long l4 = sonarQubeIssuesBreakdown.getTotalCriticalBugsIssues();
        Long l5 = sonarQubeIssuesBreakdown.getTotalCriticalVulnerabilitiesIssues();
        Long l6 = sonarQubeIssuesBreakdown.getTotalCriticalCodeSmellsIssues();
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getBoldFont(), 10, FormatUtils.getNumber(locale).format(l4), 68, 238);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getBoldFont(), 10, FormatUtils.getNumber(locale).format(l5), 112, 238);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getBoldFont(), 10, FormatUtils.getNumber(locale).format(l6), 157, 238);
        Long l7 = sonarQubeIssuesBreakdown.getTotalMajorBugsIssues();
        Long l8 = sonarQubeIssuesBreakdown.getTotalMajorVulnerabilitiesIssues();
        Long l9 = sonarQubeIssuesBreakdown.getTotalMajorCodeSmellsIssues();
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l7), 68, 208);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l8), 112, 208);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l9), 157, 208);
        Long l10 = sonarQubeIssuesBreakdown.getTotalMinorBugsIssues();
        Long l11 = sonarQubeIssuesBreakdown.getTotalMinorVulnerabilitiesIssues();
        Long l12 = sonarQubeIssuesBreakdown.getTotalMinorCodeSmellsIssues();
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l10), 68, 177);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l11), 112, 177);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l12), 157, 177);
        Long l13 = sonarQubeIssuesBreakdown.getTotalInfoBugsIssues();
        Long l14 = sonarQubeIssuesBreakdown.getTotalInfoVulnerabilitiesIssues();
        Long l15 = sonarQubeIssuesBreakdown.getTotalInfoCodeSmellsIssues();
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l13), 68, 147);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l14), 112, 147);
        PdfUtils.drawCenterText(pDPageContentStream, fonts.getRegularFont(), 10, FormatUtils.getNumber(locale).format(l15), 157, 147);
        LOGGER.debug("Issues by severity section generated.");
    }

    private void generateFooter(PDPageContentStream pDPageContentStream, PDImageXObject pDImageXObject, int n, int n2) {
        try {
            float f = 297.0f - (float)n / 2.0f;
            float f2 = 10.0f;
            pDPageContentStream.drawImage(pDImageXObject, f, f2, (float)n, (float)n2);
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to draw image in PDF", iOException);
        }
    }

    private void generatePageNumber(PDPageContentStream pDPageContentStream, PDFont pDFont, int n) {
        PdfUtils.drawCenterText(pDPageContentStream, pDFont, 10, Integer.toString(n), 555, 33);
    }

    private PDImageXObject generatePDImage(PDDocument pDDocument, BufferedImage bufferedImage, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return PDImageXObject.createFromByteArray(pDDocument, byArray, string);
    }

    private void disableSections(PDPageContentStream pDPageContentStream) {
        try {
            if (this.coverageSectionDisabled) {
                PdfUtils.drawRectangle(pDPageContentStream, 216, 62, 159, 264, Color.WHITE);
            }
            if (this.qualityGateSectionDisabled) {
                PdfUtils.drawRectangle(pDPageContentStream, 453, 684, 114, 48, Color.WHITE);
            }
        }
        catch (IOException iOException) {
            LOGGER.warn("Unable to disable sections: {}", (Object)iOException.getMessage());
        }
    }

    private boolean hasMultipleSeverities(String string) {
        int n = 0;
        if (this.blockerIssues.containsKey(string)) {
            ++n;
        }
        if (this.criticalIssues.containsKey(string)) {
            ++n;
        }
        if (this.majorIssues.containsKey(string)) {
            ++n;
        }
        if (this.minorIssues.containsKey(string)) {
            ++n;
        }
        if (this.infoIssues.containsKey(string)) {
            ++n;
        }
        return n > 1;
    }

    private String getActiveSeverityForIssue(String string) {
        if (this.blockerIssues.containsKey(string)) {
            return BLOCKER;
        }
        if (this.criticalIssues.containsKey(string)) {
            return CRITICAL;
        }
        if (this.majorIssues.containsKey(string)) {
            return MAJOR;
        }
        if (this.minorIssues.containsKey(string)) {
            return MINOR;
        }
        if (this.infoIssues.containsKey(string)) {
            return INFO;
        }
        return "none";
    }

    private String getActiveSeverityForHotSpot(String string) {
        String string2 = "none";
        if (this.blockerHotspots.containsKey(string)) {
            string2 = BLOCKER;
        } else if (this.criticalHotspots.containsKey(string)) {
            string2 = CRITICAL;
        } else if (this.majorHotspots.containsKey(string)) {
            string2 = MAJOR;
        } else if (this.minorHotspots.containsKey(string)) {
            string2 = MINOR;
        } else if (this.infoHotspots.containsKey(string)) {
            string2 = INFO;
        } else {
            try {
                string2 = this.sonarQubeRuleManager.getRule(string).getSeverity();
            }
            catch (SonarQubeException sonarQubeException) {
                LOGGER.error("Error getting hotspot rule severity for {}", (Object)string, (Object)sonarQubeException);
            }
            LOGGER.warn("No severity found for hostpot rule {} ... setting default rule severity {}", (Object)string, (Object)string2);
        }
        LOGGER.debug("Severity for hotspot rule {} is {}", (Object)string, (Object)string2);
        return string2;
    }

    private String getRuleType(String string) {
        String string2 = "none";
        try {
            string2 = this.sonarQubeRuleManager.getRule(string).getType().name().toLowerCase();
        }
        catch (SonarQubeException sonarQubeException) {
            LOGGER.warn("Unable to get rule type from rule {}", (Object)string, (Object)sonarQubeException);
        }
        return string2;
    }

    private void generateActivityPage(int n) throws IOException, SonarQubeException {
        PDPage pDPage = this.document.importPage(this.templateIssues.getPage(0));
        try (PDPageContentStream pDPageContentStream = new PDPageContentStream(this.document, pDPage, PDPageContentStream.AppendMode.APPEND, true);){
            PdfUtils.drawRightAlignedText(pDPageContentStream, this.fonts.getBoldFont(), 16, this.messages.getString("reporting.pdf.evolution.header"), 515, 802);
            pDPageContentStream.setFont(this.fonts.getRegularFont(), 10.0f);
            PdfUtils.generateSimpleHeader(pDPageContentStream, this.sonarQubeProject, this.branch, this.fonts, this.messages);
            this.generateActivitySection(pDPageContentStream);
            this.generateFooter(pDPageContentStream, this.pdFooterImage, this.footerScaledWidth, this.footerScaledHeight);
            this.generatePageNumber(pDPageContentStream, this.fonts.getRegularFont(), n);
        }
    }

    private void generateActivitySection(PDPageContentStream pDPageContentStream) throws IOException, SonarQubeException {
        BufferedImage bufferedImage = this.generateActivityChartForDuplications();
        BufferedImage bufferedImage2 = this.generateActivityChartForMetric("duplicated_lines_density");
        BufferedImage bufferedImage3 = this.generateActivityChartForCoverage();
        BufferedImage bufferedImage4 = this.generateActivityChartForMetric("coverage");
        BufferedImage bufferedImage5 = this.generateActivityChartForMetric("bugs");
        BufferedImage bufferedImage6 = this.generateActivityChartForMetric("vulnerabilities");
        BufferedImage bufferedImage7 = this.generateActivityChartForMetric("security_hotspots");
        BufferedImage bufferedImage8 = this.generateActivityChartForMetric("code_smells");
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage5, 40, 580, 250, 125);
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage6, 310, 580, 250, 125);
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage8, 40, 430, 250, 125);
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage7, 310, 430, 250, 125);
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage3, 40, 130, 250, 125);
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage4, 310, 130, 250, 125);
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage, 40, 280, 250, 125);
        PdfUtils.drawImage(this.document, pDPageContentStream, bufferedImage2, 310, 280, 250, 125);
        PdfUtils.drawRectangle(pDPageContentStream, 25, 45, 540, 60, Color.WHITE);
    }

    private BufferedImage generateActivityChartForDuplications() throws SonarQubeException {
        LOGGER.debug("Generating evolution section for duplications (lines of code vs duplicated lines)");
        ChartSeries chartSeries = this.generateChartSeriesForMetric("ncloc");
        ChartSeries chartSeries2 = this.generateChartSeriesForMetric("duplicated_lines");
        chartSeries2.setLineColor(ChartUtils.LINE_COLOR_RED);
        chartSeries2.setFillColor(ChartUtils.FILL_COLOR_RED);
        String string = this.messages.getString("reporting.chart.duplications");
        return ChartUtils.createAreaChart(1250, 625, Arrays.asList(chartSeries, chartSeries2), this.fonts.getAwtRegularFont(), this.fonts.getAwtBoldFont(), string, this.userLocale);
    }

    private BufferedImage generateActivityChartForMetric(String string) throws SonarQubeException {
        LOGGER.debug("Generating evolution section for {}...", (Object)string);
        ChartSeries chartSeries = this.generateChartSeriesForMetric(string);
        String string2 = this.messages.getString("odt.metric." + string + ".name");
        return ChartUtils.createAreaChart(1250, 625, Arrays.asList(chartSeries), this.fonts.getAwtRegularFont(), this.fonts.getAwtBoldFont(), string2, this.userLocale);
    }

    private BufferedImage generateActivityChartForCoverage() throws SonarQubeException {
        Object object;
        LOGGER.debug("Generating evolution section for coverage (lines to cover vs covered lines)");
        ChartSeries chartSeries = this.generateChartSeriesForMetric("lines_to_cover");
        ChartSeries chartSeries2 = this.generateChartSeriesForMetric("uncovered_lines");
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (int i = 0; i < chartSeries.getValues().size(); ++i) {
            object = chartSeries.getValues().get(i);
            Number number = chartSeries2.getValues().get(i);
            arrayList.add(((Number)object).longValue() - number.longValue());
        }
        ChartSeries chartSeries3 = new ChartSeries("covered_lines", chartSeries.getDates(), arrayList, ChartUtils.LINE_COLOR_GREEN, ChartUtils.FILL_COLOR_GREEN);
        object = this.messages.getString("reporting.chart.coverage");
        return ChartUtils.createAreaChart(1250, 625, Arrays.asList(chartSeries, chartSeries3), this.fonts.getAwtRegularFont(), this.fonts.getAwtBoldFont(), (String)object, this.userLocale);
    }

    private ChartSeries generateChartSeriesForMetric(String string) throws SonarQubeException {
        SonarQubeHistoryMeasure sonarQubeHistoryMeasure = this.sonarQubeMeasureManager.getHistoryMeasures(this.sonarQubeProject.getKey(), this.branch, Arrays.asList(string), "");
        List<SonarQubeHistoryMetricValue> list = sonarQubeHistoryMeasure.getHistoryMetricMapValues().get(string);
        ArrayList<Date> arrayList = new ArrayList<Date>();
        ArrayList<Number> arrayList2 = new ArrayList<Number>();
        for (SonarQubeHistoryMetricValue sonarQubeHistoryMetricValue : list) {
            try {
                LOGGER.debug("ORIGINAL (Date, Value) : ({},{})", (Object)sonarQubeHistoryMetricValue.getDate(), (Object)sonarQubeHistoryMetricValue.getValue());
                Date date = Date.from(DateUtils.parseOffsetDateTime(sonarQubeHistoryMetricValue.getDate()).toInstant());
                arrayList.add(date);
                Number number = 0;
                if (ParamsUtils.hasValue(sonarQubeHistoryMetricValue.getValue())) {
                    number = "coverage".equals(string) || "duplicated_lines_density".equals(string) || "sqale_debt_ratio".equals(string) ? (Number)NumberFormat.getInstance(Locale.ENGLISH).parse(sonarQubeHistoryMetricValue.getValue()) : (Number)FormatUtils.getNumber(Locale.ENGLISH).parse(sonarQubeHistoryMetricValue.getValue());
                }
                arrayList2.add(number);
                LOGGER.debug("PARSED   (Date, Value) : ({},{})", (Object)date, (Object)number);
            }
            catch (Exception exception) {
                LOGGER.warn("Error parsing value to generate activity graph point ({},{}) : {}", sonarQubeHistoryMetricValue.getDate(), sonarQubeHistoryMetricValue.getValue(), exception.getMessage());
            }
        }
        return new ChartSeries(string, arrayList, arrayList2, ChartUtils.LINE_COLOR_BLUE, ChartUtils.FILL_COLOR_BLUE);
    }
}

