/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Users;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.users.SearchRequest;

public class SonarQubeUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeUserManager.class);
    private final WsClient wsClient;

    public SonarQubeUserManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeUserManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected List<Users.SearchWsResponse.User> getUsers(WsClient wsClient) {
        return new SonarQubeUserManager(wsClient).getUsers();
    }

    protected Users.SearchWsResponse.User getUserByEmail(WsClient wsClient, String string) {
        return new SonarQubeUserManager(wsClient).getUserByEmail(string);
    }

    protected Users.SearchWsResponse.User getUserByLogin(WsClient wsClient, String string) {
        return new SonarQubeUserManager(wsClient).getUserByLogin(string);
    }

    protected List<Users.SearchWsResponse.User> getUsersByName(WsClient wsClient, String string) {
        return new SonarQubeUserManager(wsClient).getUsersByName(string);
    }

    public List<Users.SearchWsResponse.User> getUsers() {
        LOGGER.debug("Getting users...");
        return this.wsClient.users().search(new SearchRequest()).getUsersList();
    }

    public Users.SearchWsResponse.User getUserByEmail(String string) {
        LOGGER.debug("Getting user with email: {}", (Object)string);
        return this.getUserWithFilter(string);
    }

    public Users.SearchWsResponse.User getUserByLogin(String string) {
        LOGGER.debug("Getting user with login: {}", (Object)string);
        return this.getUserWithFilter(string);
    }

    public List<Users.SearchWsResponse.User> getUsersByName(String string) {
        LOGGER.debug("Getting users with name: {}", (Object)string);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQ(string);
        return this.wsClient.users().search(searchRequest).getUsersList();
    }

    private Users.SearchWsResponse.User getUserWithFilter(String string) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQ(string);
        List<Users.SearchWsResponse.User> list = this.wsClient.users().search(searchRequest).getUsersList();
        if (list.isEmpty()) {
            LOGGER.debug("User not found, returning empty user...");
            return Users.SearchWsResponse.User.newBuilder().build();
        }
        LOGGER.debug("User found, returning user...");
        return list.get(0);
    }
}

