/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import java.io.IOException;
import java.io.Writer;
import org.sonar.api.internal.apachecommons.lang.StringEscapeUtils;
import org.sonar.api.utils.text.WriterException;

public class CsvWriter {
    private static final String VALUE_SEPARATOR = ",";
    private static final String LINE_SEPARATOR = "\r\n";
    private final Writer writer;

    private CsvWriter(Writer writer) {
        this.writer = writer;
    }

    public static CsvWriter of(Writer writer) {
        return new CsvWriter(writer);
    }

    public CsvWriter values(String ... values2) {
        for (int index = 0; index < values2.length; ++index) {
            String value;
            if (index > 0) {
                this.write(VALUE_SEPARATOR);
            }
            if ((value = values2[index]) != null) {
                this.write(StringEscapeUtils.escapeCsv(value));
            }
            if (index != values2.length - 1) continue;
            this.write(LINE_SEPARATOR);
        }
        return this;
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e2) {
            throw new WriterException("Fail to close CSV output", e2);
        }
    }

    private void write(String s2) {
        try {
            this.writer.append(s2);
        }
        catch (IOException e2) {
            throw new WriterException("Fail to generate CSV with value: " + s2, e2);
        }
    }
}

